<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */
$routes->setAutoRoute(true);
// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');
$route['default_controller'] = 'Welcome';
$route['admin'] = 'admin/login';
$route['admin/Subservice/(:num)'] = 'admin/Subservice/index/$1';
$route['admin/subservice/(:num)'] = 'admin/Subservice/index/$1';
$route['admin/(:any)/add'] = 'admin/$1/form/add';
$route['admin/(:any)/edit/(:any)'] = 'admin/$1/form/edit/$2';
$route['ws/v1/Shop/add'] = 'ws/Shop/save';
$route['ws/v1/(:any)/(:any)'] = 'ws/$1/$2';
$route['ws/v1/(:any)/(:any)/(:any)'] = 'ws/$1/$2/$3';

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
