<?php
namespace App\Libraries;
use App\Controllers\BaseController;
class MY_Controller extends BaseController
{

    public $langugeModule;

    public function __construct()
    {
        //parent::__construct();
    }

    function getSettingDetail()
    {
        $query = $this->db->select("vSettingKey,vSettingValue")->get(TBL_SETTING);

        if ($query->num_rows() > 0)
        {
            $arr = $query->result_array();
            foreach ($arr as $key => $val)
            {
                if (!defined($val["vSettingKey"]))
                {
                    define($val["vSettingKey"], $val["vSettingValue"]);
                }
            }
        } else
            return '';
    }

    function getDefaultLanguageSettings()
    {
        $this->load->model("Language_model", "Language");
        $defaultID = $this->Language->getDefaultLanguage(true);
        return $defaultID;
    }

    function restoreLangugeFileWithData($langugeModule, $type = "All")
    {
        $this->load->model("Language_constant_model", "LanguageConstant");

        $defaultID = $this->getDefaultLanguageSettings();
        $successMsgs = $this->LanguageConstant->getLanguageConstants($defaultID["iLanguageID"]);

        //Get File 
        $this->load->helper('file');
        switch ($type)
        {
            case "All":
                $fileType = "general_lang.php";
                break;
            case "Label":
                $fileType = "label_lang.php";
                break;
            case "Success":
                $fileType = "success_lang.php";
                break;
            case "Error":
                $fileType = "error_lang.php";
                break;
        }

        $pathToSuccessFile = APPPATH . "language/" . strtolower($defaultID["vLanguageCode"]) . "/" . $langugeModule . "/" . $fileType;
        if (!empty($successMsgs))
        {
            $langstr = "";
            $langstr = "<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
                /**
                *
                *Last Updated:  " . date("d/m/Y h:i:s A") . "
                *
                * Description:  " . $langugeModule . " language file for general views
                *
                */" . "\n\n\n";
            foreach ($successMsgs as $key => $lang)
            {
                $langstr.= "\$lang['" . $lang["vLabel"] . "'] = \"" . $lang["vValue"] . "\";" . "\n";
            }
            $langstr .="?>";

            write_file($pathToSuccessFile, $langstr);
        }
    }

    function uploadImage($newFileArr, $uploadPath, $uploadThumbPath = "", $thumbArray = array(), $oldFileName = "")
    {
		//echo "<pre>";
        //print_r($newFileArr);
		//echo $newFileArr["name"];
		//echo $newFileArr["type"];
        //exit;
        // pr($uploadPath);
        if (!empty($newFileArr["name"]))
        {
            $this->load->library('ImageUpload');
            if (isset($newFileArr) && $newFileArr['name'] != '')
            {
                $handleImage = new Upload($newFileArr);
                $newName1 = str_replace(' ', '_', $newFileArr['name']);
                //$newName1 =  $newFileArr['name'];
				//echo $newName1;
				//exit;
				$FileName = substr($newName1, 0 , (strrpos($newName1, ".")));
		    $filetime = round(microtime(true));
		    $ext = substr($newName1, strrpos($newName1, "."));
			//$newName = basename($newName1, $ext) ."_".$filetime;
			$newName =  $FileName."_".$filetime;
			//echo $ext;
			//echo $newName;
				//exit;
				
				
 				//$t = explode('.', $newName1);
                //$e  = array_pop($t);
                //$newName = implode('.', $t);	
				
				//echo $newName;
				//exit;
				// $newName = md5(time() . $newFileArr['name']);
                if ($handleImage->uploaded)
                {
                    $handleImage->file_new_name_body = $newName;
                    $handleImage->allowed = array('image/png', 'image/jpeg', 'image/jpg', 'image/gif', 'video/mp4', 'video/avi', 'video/flv', 'video/wmv');
                    $handleImage->Process($uploadPath);

                    if ($uploadThumbPath != "" && !empty($thumbArray) && is_array($thumbArray))
                    {
                        foreach ($thumbArray as $key => $thumbDimension)
                        {
                            $thumbCount = $key + 1;
                            $handleImage->file_new_name_body = "th" . $thumbCount . "_" . $newName;
                            $handleImage->allowed = array('image/png', 'image/jpeg', 'image/jpg', 'image/gif');
                            $handleImage->image_resize = true;
                            $handleImage->image_ratio_crop = true;
                            $handleImage->image_x = $thumbDimension["X"];
                            $handleImage->image_y = $thumbDimension["Y"];
                            $handleImage->Process($uploadThumbPath);
                        }
                    }
                    if ($handleImage->processed)
                    {
                        if (!empty($oldFileName))
                        {
                            if (file_exists($uploadPath . $oldFileName))
                            {
                                unlink($uploadPath . $oldFileName);
                            }
                            if (file_exists($uploadThumbPath . $oldFileName))
                            {
                                unlink($uploadThumbPath . $oldFileName);
                            }
                        }

                       //return $newName;
					  
						return $newName . "." . $handleImage->file_dst_name_ext;
						
                    } else
                    {
                        return FALSE;
                    }
                } else
                {
                    return FALSE;
                }
            }
        } else if (empty($newFileArr["name"]) && !empty($oldFileName))
        {
            return $oldFileName;
        } else
        {
            return $oldFileName;
        }
    }

    

   

}
