<?php
namespace App\Models;   
use CodeIgniter\Model; 
class General_model extends Model
{

    function __construct()
    {
        parent::__construct();
        
    }

    function getMessages()
    {
        if ($this->session->userdata('ERROR') && array_count_values($this->session->userdata('ERROR')) > 0)
            return $this->load->view('admin/messages/error_view');
        else if ($this->session->userdata('SUCCESS') && array_count_values($this->session->userdata('SUCCESS')) > 0)
            return $this->load->view('admin/messages/success_view');
    }

    public function safe_b64encode($string)
    {

       $data = base64_encode($string);
        $data = str_replace(array('+', '/', '='), array('-', '_', ''), $data);
        return $data;
    }

    public function safe_b64decode($string)
    {
        $data = str_replace(array('-', '_'), array('+', '/'), $string);
        $mod4 = strlen($data) % 4;
        if ($mod4)
        {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }

    function getFrontMessages()
    {
        if ($this->session->userdata('ERROR') && array_count_values($this->session->userdata('ERROR')) > 0){
            return $this->load->view('front/messages/error_view');
        }
        else if ($this->session->userdata('SUCCESS') && array_count_values($this->session->userdata('SUCCESS')) > 0)
            return $this->load->view('front/messages/success_view');
    }

    function getAdminMessages()
    {

        if ($this->session->userdata('ERROR') && array_count_values($this->session->userdata('ERROR')) > 0)
            return $this->load->view('admin/messages/error_view');
        else if ($this->session->userdata('SUCCESS') && array_count_values($this->session->userdata('SUCCESS')) > 0)
            return $this->load->view('admin/messages/success_view');
    }

   
   

    /* TO TRUNCATE LONG STRING */

    function TruncateStr($string, $length = 80, $etc = '...', $breakWords = false)
    {
        if ($length == 0)
            return '';

        if (strlen($string) > $length)
        {
            $length -= strlen($etc);
            $fragment = substr($string, 0, $length + 1);
            if ($breakWords)
                $fragment = substr($fragment, 0, -1);
            else
                $fragment = preg_replace('/\s+(\S+)?$/', '', $fragment);
            return $fragment . " " . $etc;
        } else
            return $string;
    }


    function time_difference($time_1, $time_2)
    {

        $val_1 = new DateTime($time_1);
        $val_2 = new DateTime($time_2);

        $interval = $val_1->diff($val_2);
        $year = $interval->y;
        $month = $interval->m;
        $day = $interval->d;
        $hour = $interval->h;
        $minute = $interval->i;
        $second = $interval->s;

        $output = '';

        if ($year > 0)
        {
            if ($year > 1)
            {
                $output .= $year . " years ";
            } else
            {
                $output .= $year . " year ";
            }
        }

        if ($month > 0)
        {
            if ($month > 1)
            {
                $output .= $month . " months ";
            } else
            {
                $output .= $month . " month ";
            }
        }

        if ($day > 0)
        {
            if ($day > 1)
            {
                $output .= $day . " days ";
            } else
            {
                $output .= $day . " day ";
            }
        }

        if ($hour > 0)
        {
            if ($hour > 1)
            {
                $output .= $hour . " hours ";
            } else
            {
                $output .= $hour . " hour ";
            }
        }

        if ($minute > 0)
        {
            if ($minute > 1)
            {
                $output .= $minute . " minutes ";
            } else
            {
                $output .= $minute . " minute ";
            }
        }

        if ($second > 0)
        {
            if ($second > 1)
            {
                $output .= $second . " seconds";
            } else
            {
                $output .= $second . " second";
            }
        }

        return $output;
    }

    function format_size($size)
    {
        $sizes = array(" Bytes", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB");
        if ($size == 0)
        {
            return('n/a');
        } else
        {
            return (round($size / pow(1024, ($i = floor(log($size, 1024)))), 2) . $sizes[$i]);
        }
    }

    function uk_date_to_mysql_date($date)
    {
        $date_year = substr($date, 6, 4);
        $date_month = substr($date, 3, 2);
        $date_day = substr($date, 0, 2);
        $date = date("Y-m-d", mktime(0, 0, 0, $date_month, $date_day, $date_year));
        return $date;
    }

    function uk_date_to_mysql_date_search($date)
    {
        $date_year = substr($date, 3, 4);
        $date_month = substr($date, 0, 2);
        $date = date("Y-m", mktime(0, 0, 0, $date_month, "01", $date_year));
        return $date;
    }

    function us_date_to_mysql_date($date)
    {
        $date_year = substr($date, 6, 4);
        $date_day = substr($date, 3, 2);
        $date_month = substr($date, 0, 2);
        $date = date("Y-m-d", mktime(0, 0, 0, $date_month, $date_day, $date_year));
        return $date;
    }

    function datediffInWeeks($date1, $date2)
    {
        $diff = strtotime($date2, 0) - strtotime($date1, 0);
        return floor($diff / 604800);
    }

    function monthDiff($date1, $date2)
    {
        $date1 = date(strtotime($date1));
        $date2 = date(strtotime($date2));

        $difference = $date2 - $date1;
        $months = floor($difference / 86400 / 30);

        return $months;
    }

   

    function getDBDateTimeByTimeZone($DateTime, $TimeZone)
    {

        $result = $this->db->query("SELECT CONVERT_TZ('" . $DateTime . "','" . $TimeZone . "',@@session.time_zone) as dt");

        if ($result->num_rows() > 0)
        {
            $row = $result->row_array();
            return $row['dt'];
        } else
            return '';
    }


    function getLatLong($Address)
    {

        $geocode = file_get_contents('http://maps.google.com/maps/api/geocode/json?address=' . str_replace(' ', '+', $Address) . '&sensor=false');

        $output = json_decode($geocode);

        if (strtolower($output->status) == strtolower("OK"))
        {
            $output1['lat'] = $output->results[0]->geometry->location->lat;
            $output1['lon'] = $output->results[0]->geometry->location->lng;

            return $output1;
        } else
            return FALSE;
    }

  
}

?>