<?php
namespace App\Libraries;
use App\Models\Maidtosparkle_model;
class Ws_Controller extends MY_Controller
{

    /**
     * The request has succeeded
     */
    const HTTP_OK = 200;

    /**
     * The request cannot be fulfilled due to multiple errors
     */
    const HTTP_BAD_REQUEST = 400;

    /**
     * The user is unauthorized to access the requested resource
     */
    const HTTP_UNAUTHORIZED = 401;

    /**
     * The requested resource is unavailable at this present time
     */
    const HTTP_FORBIDDEN = 403;

    /**
     * The requested resource could not be found
     *
     * Note: This is sometimes used to mask if there was an UNAUTHORIZED (401) or
     * FORBIDDEN (403) error, for security reasons
     */
    const HTTP_NOT_FOUND = 404;

    /**
     * The request method is not supported by the following resource
     */
    const HTTP_METHOD_NOT_ALLOWED = 405;

    /**
     * The server encountered an unexpected error
     *
     * Note: This is a generic error message when no specific message
     * is suitable
     */
    const HTTP_INTERNAL_SERVER_ERROR = 500;

    public $method;
    public $ws_method;
    public $responseData;
    public $extraData;
    public $status = 0;
    public $http_code = self::HTTP_OK;
    public $message = "OK";
    public $debug_log = [];
    protected $request;
    private $settings = ['auto_resp' => true];
    private $debug = true;
    public $langugeModule = "api";
    public $defaultLanguage;
    public $loggedInUser;

    function __construct()
    {
        parent::__construct();
        //$this->api_version = $this->uri->segment(2);
        $uri = new \CodeIgniter\HTTP\URI(current_url());
        $request = \Config\Services::request();
        $router = service('router');

        $this->api_version = $uri->getSegment(2);
        $this->method = $request->getMethod();
        $this->ws_method = $router->methodName();
        $GET = $POST = [];
        $GET = $request->getGet();
        $POST = $request->getPost();
        $this->request = array_merge($GET, $POST);
        if (!empty($this->request['debug']))
        {
            $this->debug = true;
        }
        //Load Language File to Display Message
        $file = APPPATH . 'language/en/';
        $di = new \RecursiveDirectoryIterator($file, \RecursiveDirectoryIterator::SKIP_DOTS);
        $it = new \RecursiveIteratorIterator($di);

        foreach ($it as $file)
        {
            // if (pathinfo($file, PATHINFO_EXTENSION) == "php")
            // {
            //     $this->lang->load(str_replace('_lang', '', pathinfo($file, PATHINFO_FILENAME)));
            // }
        }

        //$this->load->model("Maidtosparkle_model", "MTS");
        $this->MTS = new Maidtosparkle_model();
        $allowedWs = ['login','changePassword','forgotPassword','logout','getUserlist','getServicelist','searchUserlist','addWork','getCustomerlist','getWorklist','UpdateInOutTime','searchCustomerlist','updateUserLatLng','addWorkHistory','checkAppVersion','saveTeam','getTeamDetail','getWorkStatus','getOfficelist'];

        if (!in_array($this->ws_method, $allowedWs))
        {

         //   $this->loggedInUser = $this->checkAuthentication();
        }
		
	
		
    }

    function checkAuthentication()
    {
        // authenticate user via header token        
        $vToken = $this->getAuthToken();
        if (!empty($vToken))
        {
            // except this services , all other webservices must follow token base authentication
            $getRecord = $this->MTS->authenticate($vToken);

            if (empty($getRecord))
            {
                $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
                $this->message = lang('err_invalid_token');
                exit;
            } else
            {
                return $getRecord["iUserId"];
            }
        } else
        {
            $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
            $this->message = lang('err_invalid_token');
            exit;
        }
    }
	
	

    function __destruct()
    {
        header("content-type:application/json", "", Self::HTTP_OK);
        if ($this->isAutoResp())
        {
            $this->message = (!empty($this->message)) ? $this->message : "";
            if ($this->debug)
            {
                je_mobile($this->status, $this->message, $this->responseData, $this->extraData, $this->debug_log);
            } else
            {
                je_mobile($this->status, $this->message, $this->responseData, $this->extraData);
            }
        }
    }

    /**
     * @return boolean
     *  check authentication 
     * */
    function chk_authentication($iUserID = '')
    {
        $vToken = $this->getAuthToken();
        if (!$this->Token->isValidToken($iUserID, $vToken))
        {
            $this->status_code = 401;
            $this->status = false;
            $this->message = WS_UAF;
            exit;
        } else
        {
            return TRUE;
        }
    }

    /**
     * 
     * @return boolean
     */
    public function isGET()
    {
        if ($this->method == 'GET')
        {
            return true;
        }
        return false;
    }

    /**
     * 
     * @return boolean
     */
    public function isPOST()
    {
        if ($this->method == 'POST')
        {
            return true;
        }
        return false;
    }

    /**
     * 
     * @return boolean
     */
    public function isPUT()
    {
        if ($this->method == 'PUT')
        {
            return true;
        }
        return false;
    }

    /**
     * 
     * @return boolean
     */
    public function isDELETE()
    {
        if ($this->method == 'DELETE')
        {
            return true;
        }
        return false;
    }

    /**
     * 
     * @return mixed
     */
    protected function getRequest()
    {
        return $this->request;
    }

    /**
     * 
     * @return mixed
     */
    protected function setRequest($request)
    {
        $this->request = $request;
    }

    /**
     * 
     * @return boolean
     */
    public function isAutoResp()
    {
        return $this->settings['auto_resp'];
    }

    /**
     * 
     * @param boolean $trueFalse
     */
    public function setAutoResp($trueFalse)
    {
        $this->settings['auto_resp'] = $trueFalse;
    }

    /**
     * 
     * @return boolean
     */
    public function validate($rules, array $messages = []): bool
    {
        // this will validate the request parameter
        // need to implement
        return true;
    }

    public function log($log)
    {
        if (!empty($log))
            $this->debug_log['log'][] = $log;
    }

    /**
     *  @return token string
     *  get authentication header
     * */
    function getAuthToken()
    {
		
        $Authorization = "";
        $headers = getallheaders();
        //print_r($headers);
        if(isset($headers['vauthtoken']) OR isset($headers['vAuthToken']) OR  isset($headers['Vauthtoken'])){
            //print_r($headers);exit;
            //$envHeaderVariable = (ENVIRONMENT == "development") ? $headers['vAuthToken'] : $headers['Vauthtoken'];
    		$envHeaderVariable = isset($headers['vauthtoken']) ? $headers['vauthtoken'] : $headers['vAuthToken'];
    		if(!$envHeaderVariable) $envHeaderVariable = $headers['Vauthtoken'];
            $token = isset($envHeaderVariable) ? urldecode($envHeaderVariable) : "";
            if (substr($token, 0, 7) === 'Bearer ')
            {
                $Authorization = substr($token, 7);
            }
        }
        return $Authorization;
    }

}
