<?php
namespace App\Controllers\Ws;
use App\Libraries\Ws_Controller;
use App\Models\Maidtosparkle_model;

	class Maidtosparkle_dev extends Ws_Controller
	{
		
		
		
		function __construct()
		{
			parent::__construct();
			$this->MTS = new Maidtosparkle_model();
		}
		
		/* 
			*
			*Login 
			*
		*/
		
		function login()
		{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();

				$validation->setRule('vEmail', 'vEmail', 'trim|required');
				$validation->setRule('vPassword', 'vPassword', 'trim|required');
				$PostData = $request->getPost();
				
				if ($validation->run($PostData))
				{
					
					
					$vEmail=$PostData['vEmail'];
					$vPassword=$PostData['vPassword'];
					
					$CheckData = $this->MTS->CheckUser($vEmail,$vPassword);
					if (!empty($CheckData))
					{
                        $authToken = $this->MTS->hashSSHAuthToken($CheckData["vPassword"]);
						
					    $responseData = $this->MTS->addtoken($authToken,$CheckData["id"]);
					    $data = $this->MTS->getUserDetail(array('id'=>$CheckData["id"]));
						
						$data1['id']=$data['id']==""?"":$data['id'];
						$data1['vName']=$data['vName']==""?"":$data['vName'];
				        $data1['vEmail']=$data['vEmail']==""?"":$data['vEmail'];
						//$data1['vImagePath'] = $data['vImagePath']==""?"":BASE_PATH.$data['vImagePath'];add
						$data1['vImagePath'] = $data['vImagePath']==""?"":BASE_PATH."upload/images/dprofile.png";
						$data1['nHContactNo']=$data['nHContactNo']==""?"":$data['nHContactNo'];
			            $data1['nWContactNo']=$data['nWContactNo']==""?"":$data['nWContactNo'];
			            $data1['nCContactNo']=$data['nCContactNo']==""?"":$data['nCContactNo'];
				        $data1['dAmount']=$data['dAmount']==""?"":$data['dAmount'];
						$data1['vToken']=$data['vToken']==""?"":$data['vToken'];
						$data1['isActive']=$data['isActive']==""?"":$data['isActive'];
						$data1['dModifiedDate']=$data['dModifiedDate']==""?"":$data['dModifiedDate'];
						$data1['dCreatedDate']=$data['dCreatedDate']==""?"":$data['dCreatedDate'];
						
                        $this->status = Ws_Controller::HTTP_OK;
                        $this->responseData = $data1;
                        $this->message = "Logged in successfully.";
						
					} 
					else
					{
						$this->status = Ws_Controller::HTTP_NOT_FOUND;
						$this->message = "Registration not found, Please Sign-up!";
					}
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/* 
			* 
			*logout
			*           
		*/
		
		function logout()
		{
			$request = \Config\Services::request();
			if ($request->is('get'))
			{
				$param = $this->getRequest();
				$vToken = $this->getAuthToken();

				$data = $this->MTS->getUserDetail(array("vToken" => $vToken));
				if(empty($vToken))
				{
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					
					$this->message = "No Token Send";
				}
				else
				{
					
					if(isset($data['vToken']) && $data['vToken'] == $vToken)
					{
						$responseData = $this->MTS->removetoken($vToken);
						$edit = $this->MTS->clearLatLng($data['id']);
						$this->status = Ws_Controller::HTTP_OK;
			            
						$this->message = lang('succ_logout');
					}
					else
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Send Wrong Token";
					}
				}
			} 
			else
			{
	
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		/* 
			* 
			*changePassword
			*           
		*/
		
		function changePassword()
		{
			
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('vOldPassword', 'vOldPassword', 'trim|required');
				$validation->setRule('vNewPassword', 'vNewPassword', 'trim|required');
				$vToken = $this->getAuthToken();
				
				if(empty($vToken))
				{
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
					
				}
				else
				{
					
					if($this->MTS->authenticate($vToken))
					{
						$PostData = $request->getPost();
						if ($validation->run($PostData))
						{
							
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken,"isActive"=>1));
							
							if (!empty($getData))
							{
								
								
								
								if (!empty($vToken))
                                {
									if ($PostData["vOldPassword"] != $getData["vPassword"])
                                    {
										$this->status = Ws_Controller::HTTP_BAD_REQUEST;
										$this->message = "Wrong Old Password";
										exit;
									}
									if ($getData["vPassword"] == $PostData["vNewPassword"])
                                    {
										$this->status = Ws_Controller::HTTP_BAD_REQUEST;
										$this->message = "old password and new password same";
										exit;
									}
								}
								
								//$dbData["vPassword"] = $this->request["vNewPassword"];
								$edit = $this->MTS->Update_mts('usermst',array('vPassword'=>$PostData["vNewPassword"]),array('id'=>$getData["id"]));
								if ($edit)
                                {
									$this->status = Ws_Controller::HTTP_OK;
									$this->message = lang('scc_pass_changed');
								} 
								else
                                {
									$this->status = Ws_Controller::HTTP_INTERNAL_SERVER_ERROR;
									$this->message = lang('err_failed_password');
								}
							}
							else
							{
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->message = "Result Not Found";
							}
						} 
						else
						{
							$this->status = Ws_Controller::HTTP_BAD_REQUEST;
							$this->message = "Required Data are  missing";
						}
					}
					else
					{
						
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "Wrong Token Sent";
						
						
					}			
					
				}
			}
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		/* 
			* 
			*forgotPassword
			*           
		*/
		
		function forgotPassword()
		{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('vEmail', 'Email', 'trim|required|valid_email');
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					// $vLoginToken = $this->getAuthToken();
					// if($this->User->authenticate($vLoginToken))
					// {
					
					$whereArray["vEmail"] = $PostData["vEmail"];
					
					//$checkUserExsist = $this->MTS->getUserDetail($whereArray);
					$db = \Config\Database::connect();
					$checkUserExsist = $db->table('usermst')->select('*')
					->where($whereArray)->where("isActive",1)->get()->getRowArray();
					
					if (!empty($checkUserExsist))
					{
						
						$pswd=$this->MTS->random_numbers();
						
						$responseData = $this->MTS->Update_mts('usermst',array("vPassword"=>$pswd),array("id"=>$checkUserExsist['id']));
						
						//Send Mail
						
						$mailBodyArr = array(
						"[NAME]" => $checkUserExsist['vName'],
						"[PASSWORD]" => $pswd);
						
						/* Save to DB */
						
						
						if($this->MTS->sendMailForgotpswd($checkUserExsist['vEmail'], $mailBodyArr)){
							$this->message = "Mail sent with new password.";
							}else{
							$this->message = "Unable to send mail, Please try again.";
						}
						//$this->message = "Mail sent with new password.";
						$this->status = Ws_Controller::HTTP_OK;
						
					}
					else
					{
						$this->status = Ws_Controller::HTTP_NOT_FOUND;
						$this->message = "No account associated with provided email.";
					}
					
					
					
					// }
					// else
					// {
					
					// $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					// //$this->responseData = "";
					// $this->message = "Wrong Token Sent";
					
					
					// }					
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  Userlist 
			*
		*/
		function getUserlist()
		{
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('offset', 'offset', 'trim|required');
				
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$vOffset=$PostData['offset'];
					
					
					$vToken = $this->getAuthToken();
					
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
							
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$uid = $getData['id'];
							$nFranchiseeId =  $getData['nFranchiseeId'];
							
							$data = $this->MTS->selectuser('usermst',array("!id"=>$uid,"nFranchiseeId"=>$nFranchiseeId));
							
							$totalrow = "".count($data)."";
							$datalimit = LIMIT;
							$data = $this->MTS->selectuser('usermst',array("!id"=>$uid,"nFranchiseeId"=>$nFranchiseeId),$vOffset,LIMIT);
							$continue = ($vOffset+LIMIT)<$totalrow?"True":"False";
							
							$limit = array('TotalRecord'=>$totalrow,'limit'=>$datalimit,'continue'=>$continue);
							
							if(empty($data))
							{
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->responseData = array();                
								$this->message = "No Result Found!";
								
								
							}
							else
							{
								
								$array3 = array();
								$arrayDemo = array();
								
								
								for($i=0 ;$i<count($data);$i++)
								{
									//$data1 = array();
									
									$data1[$i]['id'] = $data[$i]['id']==""?"":$data[$i]['id'];
									$data1[$i]['vName'] = $data[$i]['vName']==""?"":$data[$i]['vName'];
									//$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?"":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['vImagePath'] = BASE_PATH."upload/images/dprofile.png";
									
									$array3 = $data1;
									
								}
								
								
								$data2['limit'] = $limit;
								
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $array3;
								$this->extraData = $data2;
								$this->message = "User List";
							}
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "Enter offset value";
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  getServicelist 
			*
		*/
		function getServicelist()
		{

			$request = \Config\Services::request();
			if ($request->is('get'))
			{
				
				$vToken = $this->getAuthToken();
				
				
				if(empty($vToken))
				{
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					//$this->responseData = "";
					$this->message = "No Token Send";
				}
				else
				{
					
					if($this->MTS->authenticate($vToken))
					{
					$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));

					$uid = $getData['id'];
					
					$nFranchiseeId =  $getData['nFranchiseeId'];
						
						$data = $this->MTS->select_mts('servicemst',array('isActive'=>1,"nFranchiseeId"=>$nFranchiseeId));
						
						
						
						// $totalrow = "".count($data)."";
						// $datalimit = LIMIT;
						// $data = $this->MTS->select_mts('servicemst',array(),$vOffset,LIMIT);
						
						//  $continue = ($vOffset+LIMIT)<$totalrow?"True":"False";
						
						// $limit = array('TotalRecord'=>$totalrow,'limit'=>$datalimit,'continue'=>$continue);
						
						if(empty($data))
						{
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();                
							$this->message = "No Result Found!";
							
							
						}
						else
						{
							
							$array3 = array();
							$arrayDemo = array();
							
							
							for($i=0 ;$i<count($data);$i++)
							{
								//$data1 = array();
								
								$data1[$i]['id'] = $data[$i]['id']==""?"":$data[$i]['id'];
								$data1[$i]['vName'] = $data[$i]['vName']==""?"":$data[$i]['vName'];
								
								
								
								$array3 = $data1;
								
							}
							
							
							//$data2['limit'] = $limit;
							
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							//  $this->extraData = $data2;
							$this->message = "Service List";
						}
					}
					else
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();            
						$this->message = "Wrong Token Sent";
						
						
					}			
					
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		/*
			*  searchUserlist 
			*
		*/
		function searchUserlist()
		{
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{	
				$validation = \Config\Services::validation();	
				$validation->setRule('offset', 'offset', 'trim|required');
				$validation->setRule('vSearchQuery', 'vSearchQuery', 'trim|required');
				
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$vOffset=$PostData['offset'];
					$searchQuery=$PostData['vSearchQuery'];
					
					
					$vToken = $this->getAuthToken();
					
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$uid = $getData['id'];
							$nFranchiseeId =  $getData['nFranchiseeId'];

							$data = $this->MTS->select_mts('usermst',array('!id'=>$uid,'isActive'=>1,"nFranchiseeId"=>$nFranchiseeId),0,0,'DESC','vName',$searchQuery);
							
							$totalrow = "".count($data)."";
							$datalimit = LIMIT;
							$data = $this->MTS->select_mts('usermst',array('!id'=>$uid,'isActive'=>1,"nFranchiseeId"=>$nFranchiseeId),$vOffset,LIMIT,'DESC','vName',$searchQuery);
							
							$continue = ($vOffset+LIMIT)<$totalrow?"True":"False";
							
							$limit = array('TotalRecord'=>$totalrow,'limit'=>$datalimit,'continue'=>$continue);
							
							if(empty($data))
							{
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->responseData = array();                
								$this->message = "No Result Found!";
								
								
							}
							else
							{
								
								$array3 = array();
								$arrayDemo = array();
								
								
								for($i=0 ;$i<count($data);$i++)
								{
									//$data1 = array();
									
									$data1[$i]['id'] = $data[$i]['id']==""?"":$data[$i]['id'];
									$data1[$i]['vName'] = $data[$i]['vName']==""?"":$data[$i]['vName'];
									//$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?"":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['vImagePath'] = BASE_PATH."upload/images/dprofile.png";
									
									$array3 = $data1;
									
								}
								
								
								$data2['limit'] = $limit;
								
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $array3;
								$this->extraData = $data2;
								$this->message = "Search User List";
							}
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
			function addWorkNew()
		{
		    
		   
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				
				$validation = \Config\Services::validation();
                //$validation->setRule('nCustId', 'nCustId', 'trim|required');
				//$validation->setRule('tInTime', 'tInTime', 'trim|required'); 
				//$validation->setRule('tOutTime', 'tOutTime', 'trim|required');
				//$validation->setRule('dWorkDate', 'dWorkDate', 'trim|required'); 
				//$validation->setRule('dAmount', 'dAmount', 'trim|required');
				//$validation->setRule('vPaymentMethod', 'vPaymentMethod', 'trim|required'); 
				$validation->setRule('dLat', 'dLat', 'trim|required'); 
				$validation->setRule('dLng', 'dLng', 'trim|required');
				$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
				//$validation->setRule('nSId', 'nSId', 'trim|required'); 
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$isDifferentDay = 0;
					
					$dWorkDateToCompare=$PostData['dWorkDate'];
							
					$nCustId=$PostData['nCustId'];
					
					$nWorkId=$PostData['nWorkId'];
					
					$dAmount=$PostData['dAmount'];
					
					$nTeamId=$PostData['nTeamId'];
					
					
					$isUpdateTeamForOngoingWork = $PostData['isUpdateTeamForOngoingWork'];
					
					$nWorkHistoryId = $PostData['nWorkHistoryId'];
					$tEndTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
					$dDate=date('Y-m-d', $_SERVER['REQUEST_TIME']);
					
					
					
				    $tInTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);//$PostData['tInTime'];
				   $tInTime = empty($tInTime)?NULL:$tInTime;
					
					$tOutTime=$PostData['tOutTime'];
				    $tOutTime = empty($tOutTime)?NULL:$tOutTime;
					
					$dWorkDate= date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);//$PostData['dWorkDate'];
					//echo $dWorkDate;
					//exit;
					//$a = explode('-',$dWorkDate);
					//$dWorkDate = $a[2].'-'.$a[1].'-'.$a[0];
					
					$vPaymentMethod=$PostData['vPaymentMethod'];
					$aWorkList=$PostData['aWorkList'];
					
					$vChequeNo      = $PostData['vChequeNo'];
					$vChequeNo = empty($vChequeNo)?NULL:$vChequeNo;
					$dLat=$PostData['dLat'];
					$dLng=$PostData['dLng'];
					$nDistPrevWork=empty($PostData['nDistPrevWork'])?0:$PostData['nDistPrevWork'];
					
					$dCurrentDate = $this->MTS->getserverdate();
					
					$vToken = $this->getAuthToken();
					if (!empty($vToken))
				    {
						
						if($this->MTS->authenticate($vToken))
						{
						    
						    //	if($nWorkId)
							//	{
								 //   if()
								//    {
						    	  // $this->status = Ws_Controller::HTTP_OK;
								//	$data1 = array();
								//	$data1["isWorkAdded"] = 0;
									
								//	$this->responseData = $data1;
									
								//	$this->message = "Can not add details for previous day work.";
								   // }
							//	}
						    
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$uid = $getData['id'];
							$nUserId = $uid;
							$nFranchiseeId =  $getData['nFranchiseeId'];
							
								// $myFile = "testFile_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".$nUserId.".txt";
        //                         $fh = fopen($myFile, 'a');
        //                         $stringData = json_encode($PostData). " - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
        //                         fwrite($fh, $stringData);
        //                         fclose($fh);
							
							//$workdata = $this->MTS->daywork($uid,$dWorkDate);
							//$nCustId = $workdata['nCustId'];
							if(empty($nCustId))
							{
						     $workdata = $this->MTS->selectone('workhdr',array('id'=>$nWorkId));
							  $nCustId = $workdata['nCustId'];
							}
							else
							{
							   $nCustId=$PostData['nCustId'];
							}
							
							
							   $vDeleteEmpId=$PostData['vDeleteEmpId'];
								    $vAddEmpId=$PostData['vAddEmpId'];
							
							$custdata = $this->MTS->selectone('customermst',array('id'=>$nCustId));
							$custName = $custdata['vName'];
							$wdLat = $custdata['dLat'];
							$wdLng = $custdata['dLng'];
							
								if(date('Y-m-d', $_SERVER['REQUEST_TIME'])!=date('Y-m-d', strtotime($dWorkDateToCompare. " UTC")))
									{
									  
									    
									    $isDifferentDay=1;
									}
							
							if($this->MTS->distance($dLat,$dLng, $wdLat, $wdLng,"ME") < 100 && $isDifferentDay==0 && ($vAddEmpId == "" && $vDeleteEmpId == ""))
							{
								
								 
								$message = "Tried to ".(empty($nWorkId)?"start":"stop")." work away from customer home";
								
								
								if(!empty($nWorkId))
								{
									$responseData = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid,"nCustId"=>$nCustId,"nWorkhdrId"=>$nWorkId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
									
									}else{							
									
									$responseData = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid,"nCustId"=>$nCustId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
								}
								if($responseData)
								{
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									//$this->responseData = $array3;
									$this->message = "Can not update while away from customer's home.";
									}else{
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									//$this->responseData = $array3;
									$this->message = "Can not update while away from customer's home.";
								}
							}
							else
							{
								if($nWorkId && $isUpdateTeamForOngoingWork != 1)
								{
									if(($tOutTime == NULL) || ($tOutTime == ""))
									{
										$tOutTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
									}
									else{
										$tOutTime = $tOutTime;
									}
									
								
								     //$PostData['tInTime'];
				                    if($isDifferentDay==0)
				                    {
									    $Workdata= $this->MTS->update_mts("workhdr",array("nUserId"=>$uid, "dAmount"=>$dAmount, "vPaymentMethod"=>$vPaymentMethod, "vChequeNo"=>$vChequeNo, "nStatus"=>1 , "tOutTime"=>$tOutTime, "dLat"=>$dLat, "dLng"=>$dLng, "dModifiedDate"=>$dCurrentDate),array("id"=>$nWorkId),$nUserId);
				                    }else
				                    {
									    $Workdata= $this->MTS->update_mts("workhdr",array("nUserId"=>$uid, "dAmount"=>$dAmount, "vPaymentMethod"=>$vPaymentMethod, "vChequeNo"=>$vChequeNo, "nStatus"=>1 , "dLat"=>$dLat, "dLng"=>$dLng, "dModifiedDate"=>$dCurrentDate),array("id"=>$nWorkId),$nUserId);
				                    }
									
									for($i=0;$i<count($aWorkList);$i++)
									{
										
										$Workdtlid = $this->MTS->insert_mts("workdtl",array("nFranchiseeId"=>$nFranchiseeId,"nWorkId"=>$nWorkId,"nSId"=>(explode(",",$aWorkList[$i])[0]),"nUserId"=>(explode(",",$aWorkList[$i])[1]),"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
									}
								}
								else
								{
								    
								    $vDeleteEmpId=$PostData['vDeleteEmpId'];
								    $vAddEmpId=$PostData['vAddEmpId'];
								    
								    if($vDeleteEmpId)
								    {
								        $DeletedId = explode(",",$vDeleteEmpId);
								        for($j=0;$j<count($DeletedId);$j++)
								        {
								            $update = $this->MTS->update_mts('teamdtl',array('isActive'=>2),array('nUserId'=>$DeletedId[$j],'nTeamhdrId'=>$nTeamId));
								            
								            $this->MTS->insert_mts("empteammst",array("nUserId"=>$DeletedId[$j],"nTeamId"=>$nTeamId, "nType"=>2, "isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								            
								        }
								    }
								    
								    
								    if($vAddEmpId)
								    {
								        $AddEmpId = explode(",",$vAddEmpId);
								        for($j=0;$j<count($AddEmpId);$j++)
								        {
								            $Teamdata = $this->MTS->selectone('teamhdr',array('id'=>$nTeamId,'isActive'=>1));
								            
								            $update = $this->MTS->insert_mts('teamdtl',array('nFranchiseeId'=>$Teamdata['nFranchiseeId'],'nTeamhdrId'=>$nTeamId,'nUserId'=>$AddEmpId[$j],"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								            
								            	$userdistance  = $this->MTS->sumdistancedata($AddEmpId[$j],$dDate);
							                $nUserTotalDistance = $userdistance['TotalDistance'];
								            
								            $this->MTS->insert_mts("empteammst",array("nUserId"=>$AddEmpId[$j],"nTeamId"=>$nTeamId,"dTotalDistance"=>$nUserTotalDistance, "nType"=>1, "isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								            
								        }
								    }
								    
								    
								    
									if($isUpdateTeamForOngoingWork != 1)
									{
									  $nWorkId = $this->MTS->insert_mts("workhdr",array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid, "nCustId"=>$nCustId, "nTeamId"=>$nTeamId, "dWorkDate"=>$dWorkDate, "tInTime"=>$tInTime, "dLat"=>$dLat, "dLng"=>$dLng, "nDistPrevWork"=>$nDistPrevWork, "isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
									  $update = $this->MTS->update_mts('usermst',array('dTripDistance'=>0),array('id'=>$uid),$nUserId);
									}
									
									
									if(!empty($nWorkHistoryId))
									{
									    	$distance  = $this->MTS->sumdistancedata($uid,$dDate);
							                $nTotalDistance = $distance['TotalDistance'];
							                $WorkHistoryId = $this->MTS->update_mts("workhistory",array("tEndTime"=>$tEndTime, "nTotalDistance"=>$nTotalDistance,"isReachedOffice"=>0),array('id'=>$nWorkHistoryId),$nUserId);
									}
								
								}
								
							
								if ($nWorkId)
								{ 
								    
								    if($isDifferentDay==0){
    									$this->status = Ws_Controller::HTTP_OK;
    										$data1 = array();
    									$data1["isWorkAdded"] = 1;
    									
    									$this->responseData = $data1;
    									$this->message = "Work details successfully added";
								    }else{
								        
    								    $this->status = Ws_Controller::HTTP_OK;
    									$data1 = array();
    									$data1["isWorkAdded"] = 0;
    									
    									$this->responseData = $data1;
    									
    									$this->message = "Can not add details for previous day work.";
								    }
								
								}
								else
								{
									$this->status = Ws_Controller::HTTP_NOT_FOUND;
									//$this->responseData = array();                
									$this->message = "Fail";
								}
							}
							
						}
						else
				        {
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							//$this->responseData = "";
							$this->message = "Wrong Token Sent";
							
							
						}
					}
					else
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
				}
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
			}
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  Customerlist 
			*
		*/
		function getCustomerlist()
		{  
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('offset', 'offset', 'trim|required');
				
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$vOffset=$PostData['offset'];
					
					
					$vToken = $this->getAuthToken();
					
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
					
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$uid = $getData['id'];
							$nFranchiseeId =  $getData['nFranchiseeId'];
							
							$data = $this->MTS->select_mts('customermst',array('isActive'=>1,"nFranchiseeId"=>$nFranchiseeId));
							
							$totalrow = "".count($data)."";
							$datalimit = LIMIT;
							$data = $this->MTS->select_mts('customermst',array('isActive'=>1,"nFranchiseeId"=>$nFranchiseeId),$vOffset,LIMIT);
							
							$continue = ($vOffset+LIMIT)<$totalrow?"True":"False";
							
							$limit = array('TotalRecord'=>$totalrow,'limit'=>$datalimit,'continue'=>$continue);
							
							if(empty($data))
							{
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->responseData = array();                
								$this->message = "No Result Found!";
								
								
							}
							else
							{
								
								$array3 = array();
								$arrayDemo = array();
								
								
								for($i=0 ;$i<count($data);$i++)
								{
									//$data1 = array();
									
									$data1[$i]['id'] = $data[$i]['id']==""?"":$data[$i]['id'];
									$data1[$i]['vName'] = $data[$i]['vName']==""?"":$data[$i]['vName'];
									//$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?"":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?BASE_PATH."upload/images/dprofile.png":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['dLat'] = $data[$i]['dLat']==""?"":$data[$i]['dLat'];
									$data1[$i]['dLng'] = $data[$i]['dLng']==""?"":$data[$i]['dLng'];
									
									
									$array3 = $data1;
									
								}
								
								
								$data2['limit'] = $limit;
								
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $array3;
								$this->extraData = $data2;
								$this->message = "Customer List";
							}
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "Enter offset value";
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  Worklist
			*
		*/
		function getWorklist()
		{
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('offset', 'offset', 'trim|required');
				$validation->setRule('timestamp', 'timestamp', 'trim|required');
				
				$PostData = $request->getPost();
				
				// frank -->
				
				$teamId = $PostData['nTeamId'];
				
				//<--
				
				
				
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					
					$vOffset=$PostData['offset'];
					$timestamp=$PostData['timestamp'];
					
					
					$vToken = $this->getAuthToken();
					
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
					    
						
						if($this->MTS->authenticate($vToken))
						{
						    
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							
								// $myFile = "testLogFile_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".".txt";
        //                         $fh = fopen($myFile, 'a');
        //                         $stringData = json_encode($getData). " worklist - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
        //                         fwrite($fh, $stringData);
        //                         fclose($fh);
							
							
							$uid = $getData['id'];
							$nFranchiseeId =  $getData['nFranchiseeId'];
							
							/*$dCurrentDate = $this->MTS->getserverdate();
							
							$dCurrentDate = date("Y-m-d", strtotime($dCurrentDate));*/

							$dCurrentDate = date("Y-m-d", $timestamp);
							
							
							
							//franklin getting workhdr table based on teamID instead of uid
							
							$data = $this->MTS->getWorklistNew($uid,$dCurrentDate,$nFranchiseeId);
							
				// 			$this->status = Ws_Controller::HTTP_NOT_FOUND;
				// 				$this->responseData = $data;                
				// 				$this->message = "Franklin Test!";
				// 				exit;
							
				// 			$this->status = Ws_Controller::HTTP_NOT_FOUND;
				// 			$data1['result'] = $data;
				// 				$this->responseData = $data1;            
				// 				$this->message = "No Result Foun9d!";
				// 				exit;
				
				            // $data = $this->MTS->getWorklist($uid,$teamId,$dCurrentDate,$nFranchiseeId);
				            
							$totalrow = "".count($data)."";
							$datalimit = LIMIT;
							$data = $this->MTS->getWorklistNew($uid,$dCurrentDate,$nFranchiseeId,$vOffset,LIMIT);
				
				
				            // $data = $this->MTS->getWorklist($uid,$teamId,$dCurrentDate,$nFranchiseeId,$vOffset,LIMIT);
							
							$continue = ($vOffset+LIMIT)<$totalrow?"True":"False";
							
							$limit = array('TotalRecord'=>$totalrow,'limit'=>$datalimit,'continue'=>$continue);
							
							if(empty($data))
							{
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->responseData = array();                
								$this->message = "No Result Found!";
								
								
							}
							else
							{
							 
								
								$array3 = array();
								$arrayDemo = array();
								
								
								for($i=0 ;$i<count($data);$i++)
								{
									//$data1 = array();
									$data1[$i]['workId'] = $data[$i]['workId']==""?"":$data[$i]['workId'];
									$data1[$i]['nTeamId'] = $data[$i]['nTeamId']==""?"":$data[$i]['nTeamId'];
									$data1[$i]['CustomerName'] = $data[$i]['CustomerName']==""?"":$data[$i]['CustomerName'];
									//$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?"":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?BASE_PATH."upload/images/dprofile.png":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['dAmount'] = $data[$i]['dAmount']==""?"":$data[$i]['dAmount'];
									$data1[$i]['dWorkDate'] = $data[$i]['dWorkDate']==""?"":$data[$i]['dWorkDate'];
									$data1[$i]['InTime'] = $data[$i]['InTime']==""?"":$data[$i]['InTime'];
									$data1[$i]['OutTime'] = $data[$i]['OutTime']==""?"":$data[$i]['OutTime'];
									$data1[$i]['nStatus'] = $data[$i]['nStatus']==""?"":$data[$i]['nStatus'];
									$isLeader = $this->MTS->teamLeader($uid,$data1[$i]['nTeamId'],$dCurrentDate,$nFranchiseeId);
									if($isLeader || $data1[$i]['nStatus'] != 0){
									    $data1[$i]['nStatus'] = $data[$i]['nStatus']==""?"":$data[$i]['nStatus'];
									}else{
									    $data1[$i]['nStatus'] = $this->MTS->workStatus($uid,$data[$i]['workId'],$dCurrentDate);
									}
									
									$array3 = $data1;
									
								}
								
								
								$data2['limit'] = $limit;
								
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $array3;
								$this->extraData = $data2;
								$this->message = "WorkList";
							}
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "Enter offset value";
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  UpdateInOutTime
			*
		*/
		function UpdateInOutTime()
		{
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('nWorkId', 'nWorkId', 'trim|required');
				$validation->setRule('nTimeType', 'nTimeType', 'trim|required');
				$validation->setRule('dTime', 'dTime', 'trim|required');
				$validation->setRule('dLat', 'dLat', 'trim|required');
				$validation->setRule('dLng', 'dLng', 'trim|required');
				
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					$nWorkId=$PostData['nWorkId'];
					$nTimeType=$PostData['nTimeType'];
					$dTime=$PostData['dTime'];
					$dLat=$PostData['dLat'];
					$dLng=$PostData['dLng'];
					
					$vToken = $this->getAuthToken();
					
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
							$data = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$nUserId = $data['id'];
							$nFranchiseeId =  $data['nFranchiseeId'];
							
							$vUserName = $data['vName'];
							$workdata = $this->MTS->selectone('workhdr',array('id'=>$nWorkId));
							$update = $this->MTS->Update_mts('workhdr',array('dLat'=>$dLat,'dLng'=>$dLng),array('id'=>$nWorkId),$nUserId);
							$nCustId = $workdata['nCustId'];
							$custdata = $this->MTS->selectone('customermst',array('id'=>$nCustId));
							$custName = $custdata['vName'];
							$wdLat = $custdata['dLat'];
							$wdLng = $custdata['dLng'];
							
							
							if($this->MTS->distance($dLat,$dLng, $wdLat, $wdLng,"ME") < 100)
							{
								
								
								$message = "Tried to ".($nTimeType==1?"start":"stop")." work away from customer home";
								$responseData = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$nUserId,"nWorkhdrId"=>$nWorkId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0),$nUserId);
								
								if($responseData)
								{
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									//$this->responseData = $array3;
									$this->message = "Can not update while away from customer's home.";
									}else{
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									//$this->responseData = $array3;
									$this->message = "Can not update while away from customer's home.";
								}
							}
							else
							{
								if($nTimeType == 1)
								{
									$update = $this->MTS->Update_mts('workhdr',array('tInTime'=>$dTime),array('id'=>$nWorkId),$nUserId);
								}
								else if($nTimeType == 2)
								{
									$update = $this->MTS->Update_mts('workhdr',array('tOutTime'=>$dTime),array('id'=>$nWorkId),$nUserId);
								}
								
								if($update > 0)
								{
									$this->status = Ws_Controller::HTTP_OK;
									//$this->responseData = $array3;
									$this->message = "Update Successfully Done";
								}
								
							}
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  searchCustomerlist 
			*
		*/
		function searchCustomerlist()
		{
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('offset', 'offset', 'trim|required');
				$validation->setRule('vSearchQuery', 'vSearchQuery', 'trim|required');
				
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$vOffset=$PostData['offset'];
					$searchQuery=$PostData['vSearchQuery'];
					
					
					$vToken = $this->getAuthToken();
					
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$uid = $getData['id'];
							$nFranchiseeId =  $getData['nFranchiseeId'];
							
							
							$data = $this->MTS->select_mts('customermst',array("isActive"=>1,"nFranchiseeId"=>$nFranchiseeId),0,0,array(),'vName',$searchQuery);
							
							$totalrow = "".count($data)."";
							$datalimit = LIMIT;
							$data = $this->MTS->select_mts('customermst',array("isActive"=>1,"nFranchiseeId"=>$nFranchiseeId),$vOffset,LIMIT,array(),'vName',$searchQuery);
							
							$continue = ($vOffset+LIMIT)<$totalrow?"True":"False";
							
							$limit = array('TotalRecord'=>$totalrow,'limit'=>$datalimit,'continue'=>$continue);
							
							if(empty($data))
							{
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->responseData = array();                
								$this->message = "No Result Found!";
								
								
							}
							else
							{
								
								$array3 = array();
								$arrayDemo = array();
								
								
								for($i=0 ;$i<count($data);$i++)
								{
									//$data1 = array();
									
									$data1[$i]['id'] = $data[$i]['id']==""?"":$data[$i]['id'];
									$data1[$i]['vName'] = $data[$i]['vName']==""?"":$data[$i]['vName'];
									//$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?"":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?BASE_PATH."upload/images/dprofile.png":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['dLat'] = $data[$i]['dLat']==""?"":$data[$i]['dLat'];
									$data1[$i]['dLng'] = $data[$i]['dLng']==""?"":$data[$i]['dLng'];
									
									
									$array3 = $data1;
									
								}
								
								
								$data2['limit'] = $limit;
								
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $array3;
								$this->extraData = $data2;
								$this->message = "Search Customer List";
							}
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		/*
			*  updateUserLatLng
			*
		*/
		function updateUserLatLng()
		{
			
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				
				$validation = \Config\Services::validation();
				$validation->setRule('dLat', 'dLat', 'trim|required');
				$validation->setRule('dLng', 'dLng', 'trim|required');
				$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
				$validation->setRule('dTripDistance', 'dTripDistance', 'trim|required');																		 
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$dLat=$PostData['dLat'];
					$dLng=$PostData['dLng'];
					$nTeamId=$PostData['nTeamId'];
					$dTripDistance=$PostData['dTripDistance'];						   
	 
					$vToken = $this->getAuthToken();
					
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
						  //  	$myFile = "testLogFile_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".".txt";
        //                         $fh = fopen($myFile, 'a');
        //                         $stringData = json_encode($PostData). " - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
        //                         fwrite($fh, $stringData);
        //                         fclose($fh);
						    
							$userdata = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$nUserId = $userdata['id'];
							
							
							 //   $myFile = "LatLng_with_dist_time_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".$nUserId.".txt";
                                // $fh = fopen($myFile, 'a');
                                // $stringData = $dLat.",".$dLng.",".$dTripDistance." - ".date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
                                // fwrite($fh, $stringData);
                                // fclose($fh);
							
							
						    $update = $this->MTS->Update_mts('usermst',array('dLat'=>$dLat,'dLng'=>$dLng,'dTripDistance'=>$dTripDistance),array('id'=>$nUserId),$nUserId);
							
							
							/*$workdata = $this->MTS->selectone('workhdr',array('nTeamId'=>$nTeamId));
							$nCustId = $workdata['nCustId'];*/
						  
						
							$data =  $this->MTS->Workdata($nTeamId);
							$nCustId = $data['nCustId'];
							$custdata = $this->MTS->selectone('customermst',array('id'=>$nCustId));
							$custlat = $custdata['dLat'];
							$custlng = $custdata['dLng'];
							if(empty($data))
							{
								$data2['status'] = 0;
							}
							else
							{
							 //   $myFile = "testLogFileJames_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".".txt";
        //                          $fh = fopen($myFile, 'a');
        //                         $stringData = json_encode($this->MTS->distance($dLat,$dLng, $custlat, $custlng,"ME")). " update - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
        //                         fwrite($fh, $stringData);
        //                          fclose($fh);
							 // if($this->MTS->distance($dLat,$dLng, $custlat, $custlng,"ME") > 100) 
							   // {

							        $data2['status'] = 1;
							        $data1['workId'] = $data['id']==""?"":$data['id'];
							        $data1['nTeamId'] = $data['nTeamId']==""?"":$data['nTeamId'];
									$data1['CustomerName'] = $custdata['vName']==""?"":$custdata['vName'];
									$data1['CustomerLat'] = $custlat==""?"":$custlat;
									$data1['CustomerLng'] = $custlng==""?"":$custlng;
									$data1['dAmount'] = $data['dAmount']==""?"":$data['dAmount'];
									$data1['dWorkDate'] = $data['dWorkDate']==""?"":$data['dWorkDate'];
									$data1['InTime'] = $data['tInTime']==""?"":$data['tInTime'];
									$data1['OutTime'] = $tOutTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
									
									$data2['OngoingWork'] = $data1;
							    //}
							 //  else
							 //   {
								//  $data2['status'] = 0;
							 //   }
						    }
						    
						  //  	$myFile = "testLogFile_vasanth_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".".txt";
        //                         $fh = fopen($myFile, 'a');
        //                         $stringData = json_encode($dTripDistance). " updateUserLatLngw work - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
        //                         fwrite($fh, $stringData);
        //                         fclose($fh);
						
							if($update)
							{
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $data2;
								$this->message = "Update Successfully Done";
							}
							
							
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
			function addWorkHistoryNew()
		{
			
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				
				$PostData = $request->getPost();
				$nWorkHistoryId = $PostData['nWorkHistoryId'];
				$nOfficeId = $PostData['nOfficeId'];
				$isReachedOffice = $PostData['isReachedOffice'];
				
				if($nWorkHistoryId == "")
				{
					$tStartTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
					$tStartTime = empty($tStartTime)?NULL:$tStartTime;

				}
				else
				{
					$tEndTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
					$tEndTime = empty($tEndTime)?NULL:$tEndTime;
					
				}
				
				$nTeamId=$PostData['nTeamId'];
				
				$nTeamId = empty($nTeamId)?NULL:$nTeamId;
				
				$dDate=date('Y-m-d', $_SERVER['REQUEST_TIME']);
				
				$dCurrentDate = $this->MTS->getserverdate();
				
				$nDistPrevWork=empty($PostData['nDistPrevWork'])?NULL:$PostData['nDistPrevWork'];
				
				$vToken = $this->getAuthToken();
				
				if (!empty($vToken))
				{
					
					if($this->MTS->authenticate($vToken))
					{
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nUserId = $uid;
						$nFranchiseeId =  $getData['nFranchiseeId'];
						
						//distance
						 $nDistPrevWork = empty($getData['dTripDistance'])?NULL:$getData['dTripDistance'] ;
						 
    //                         	$myFile = "testLogFile_vasanth_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".".txt";
    //                             $fh = fopen($myFile, 'a');
    //                             $stringData = json_encode($nDistPrevWork). " addWorkHistoryNew work - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
    //                             fwrite($fh, $stringData);
    //                             fclose($fh);
						
				// 			$myFile = "testFile_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".$nUserId.".txt";
    //                             $fh = fopen($myFile, 'a');
    //                             $stringData = json_encode($PostData). " - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
    //                             fwrite($fh, $stringData);
    //                             fclose($fh);
						
						
						if(empty($nWorkHistoryId))
						{
							
							$WorkHistoryId = $this->MTS->insert_mts("workhistory",array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid,"nTeamId"=>$nTeamId, "tStartTime"=>$tStartTime, "nTotalDistance"=>0, "dModifiedDate"=>$dCurrentDate, "dCreatedDate"=>$dCurrentDate),$nUserId);
							$update = $this->MTS->Update_mts('usermst',array('dTripDistance'=>0),array('id'=>$uid),$nUserId);
							$getTlData = $this->MTS->selectone('teamhdr',array("id"=>$nTeamId, "isLeader"=>1));
							$tlId = $getTlData['nUserId'];
							if ($WorkHistoryId)
				            {
				                if($uid == $tlId){
				                    $data1['isLeader'] = 1;
				                }else{
				                    $data1['isLeader'] = 0;
				                }
								$data1["nWorkHistoryId"]=$WorkHistoryId;
								$data1['update'] = $uid;
								
				                $this->status = Ws_Controller::HTTP_OK;
				                $this->responseData = $data1;
								$this->message = "Work details added Successfully.";
							}
							else
				            {
				                $this->status = Ws_Controller::HTTP_NOT_FOUND;
				                //$this->responseData = array();                
				                $this->message = "Fail";
							}
							
						}
						else if($isReachedOffice == 0)
							{
							$distance  = $this->MTS->sumdistancedata($uid,$dDate);
							
							$nTotalDistance = $distance['TotalDistance'] + $nDistPrevWork;
							
							$WorkHistoryId = $this->MTS->update_mts("workhistory",array("tEndTime"=>$tEndTime, "nTotalDistance"=>$nTotalDistance,"isReachedOffice"=>$isReachedOffice),array('id'=>$nWorkHistoryId),$nUserId);
							if ($WorkHistoryId)
				            {
								$data1["nWorkHistoryId"]=$nWorkHistoryId;
				                $this->status = Ws_Controller::HTTP_OK;
				                $this->responseData = $data1;
								$this->message = "Work details successfully updated.";
							}
							else
				            {
				                $this->status = Ws_Controller::HTTP_NOT_FOUND;
				                //$this->responseData = array();                
				                $this->message = "Fail";
							}
							
						}
						else if($isReachedOffice == 1){
						    
							$distance  = $this->MTS->sumdistancedata($uid,$dDate);
							
							$nDistPrevWork = $this->MTS->getUserDistance($uid);
							
							$nTotalDistance = $distance['TotalDistance'] + $nDistPrevWork;
							
							$WorkHistoryId = $this->MTS->update_mts("workhistory",array("nOfficeId"=>$nOfficeId,"tEndTime"=>$tEndTime, "nTotalDistance"=>$nTotalDistance,"isReachedOffice"=>$isReachedOffice),array('id'=>$nWorkHistoryId),$nUserId);
							
							$updatedistance = $this->MTS->insert_mts('employeedistancemst',array('nEmpId'=>$nUserId,'nTeamId'=>0,'nWorkhdrId'=>0,"dTotalDistance"=>$nDistPrevWork,"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
							
							$update = $this->MTS->Update_mts('usermst',array('dLat'=>NULL,'dLng'=>NULL,'dTripDistance'=>0),array('id'=>$uid),$nUserId);//kkt ,'dTripDistance'=>NULL
							if ($WorkHistoryId)
				            {
								$data1["nWorkHistoryId"]=$nWorkHistoryId;
				                $this->status = Ws_Controller::HTTP_OK;
				                $this->responseData = $data1;
								$this->message = "Work details successfully updated.";
							}
							else
				            {
				                $this->status = Ws_Controller::HTTP_NOT_FOUND;
				                //$this->responseData = array();                
				                $this->message = "Fail";
							}
						}
						else
				            {
				                $this->status = Ws_Controller::HTTP_NOT_FOUND;
				                //$this->responseData = array();                
				                $this->message = "Failed.";
							}
						
						
					}
					else
					{
						
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "Wrong Token Sent";
						
						
					}
				}
				else
				{
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					//$this->responseData = "";
					$this->message = "No Token Send";
				}
				// }
				// else
				// {
				// $this->status = Ws_Controller::HTTP_BAD_REQUEST;
				// $this->message = strip_tags($validation->listErrors());
				// }
			}
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		function checkAppVersion()
		{
			$request = \Config\Services::request();
			if ($request->is('get'))
			{
				
				
				$data = $this->MTS->checkversion();
				
				if(empty($data))
				{
					$this->status = Ws_Controller::HTTP_NOT_FOUND;
					$this->responseData = array();                
					$this->message = "No Result Found!";
					
					
				}
				else
				{		
					$this->status = Ws_Controller::HTTP_OK;
					$this->responseData = $data;
					//  $this->extraData = $data2;
					$this->message = "Version Detail";
				}
				
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  saveTeam 
			*
		*/
		
		function saveTeam()
		{
			
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				
				$PostData = $request->getPost();
				$aUserList=$PostData['aUserList'];
				
				//$EmpId= explode(",",$aUserList);
				//print_r($EmpId);
				//exit;
				$isLeader = 1;
				$dModifiedDate = $this->MTS->getserverdate();
				$vToken = $this->getAuthToken();
				if (!empty($vToken))
				{
					
					if($this->MTS->authenticate($vToken))
					{
						
						/* if(empty($aUserList))
							{
							$this->status = Ws_Controller::HTTP_BAD_REQUEST;
							//$this->responseData = array();                
							$this->message = "Please Select Employee";
							}
							else
							{
						*/
						if($aUserList)
						{
					        $EmpId= explode(",",$aUserList);
					        $this->MTS->updateInWorkStatus($EmpId, 1,$dModifiedDate);
					        $this->MTS->updatePrevTeamStatus($EmpId,$currentDate);
						}
						else{
							$EmpId = array();
						}

						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nUserId=$uid;
						$nFranchiseeId =  $getData['nFranchiseeId'];
						
						array_push($EmpId,$uid);
						
						$TeamhdrId= $this->MTS->insert_mts("teamhdr",array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid, "isLeader"=>$isLeader, "isActive"=>1, "dModifiedDate"=>$dModifiedDate, "dCreatedDate"=>$dModifiedDate),$nUserId);
						for($i=0;$i<count($EmpId);$i++)
						{
						    // New Changes
							$Teamdtlid = $this->MTS->insert_mts("teamdtl",array("nFranchiseeId"=>$nFranchiseeId,"nTeamhdrId"=>$TeamhdrId,"nUserId"=>$EmpId[$i],"isActive"=> 1,"isLeader"=>$EmpId[$i] == $uid ? 1 : 0, "dModifiedDate"=>$dModifiedDate, "dCreatedDate"=>$dModifiedDate),$nUserId);
						}
						
						if ($Teamdtlid)
						{ 
							$data1['nTeamId'] = $TeamhdrId;
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $data1;
							
							$this->message = "TeamDetails Successfully Added";
						}
						else
						{
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							//$this->responseData = array();                
							$this->message = "Fail";
						}
						//}
						
					}
					else
					{
						
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "Wrong Token Sent";
						
						
					}
				}
				else
				{
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					//$this->responseData = "";
					$this->message = "No Token Send";
				}
				
			}
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		/*
			*  getTeamDetail 
			*
		*/
		function getTeamDetail()
		{
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$nTeamId=$PostData['nTeamId'];
					$vToken = $this->getAuthToken();
					
					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
							
							//$data = $this->MTS->select_mts('teamdtl',array('nTeamhdrId'=>$nTeamId,"isActive"=>1));
							$data = $this->MTS->select_mts('teamdtl',array('nTeamhdrId'=>$nTeamId));
								
							if(empty($data))
							{
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->responseData = array();                
								$this->message = "No Result Found!";
								
							}
							else
							{
								
								$array3 = array();
								$arrayDemo = array();
								
								for($i=0 ;$i<count($data);$i++)
								{
									//$data1 = array();
									$userdata = $this->MTS->getUserDetail(array('id'=>$data[$i]["nUserId"]));
									$data1[$i]['id'] = $userdata['id']==""?"":$userdata['id'];
									$data1[$i]['vName'] = $userdata ['vName']==""?"":$userdata['vName'];
									//$data1[$i]['vImagePath'] = $data[$i]['vImagePath']==""?"":BASE_PATH.$data[$i]['vImagePath'];
									$data1[$i]['vImagePath'] = BASE_PATH."upload/images/dprofile.png";
									$data1[$i]['isActive'] = $data[$i]['isActive']==""?"":$data[$i]['isActive'];
									$array3 = $data1;
									
								}
								
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $array3;
								//$this->extraData = $data2;
								$this->message = "Team Details Frank";
							}
						}
						else
						{
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "Enter nTeamId value";
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		

	function getWorkStatusNew()
		{
			//if ($this->isGET())
			//{
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				$validation = \Config\Services::validation();
				$validation->setRule('timestamp', 'timestamp', 'trim|required');
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$timestamp=$_SERVER['REQUEST_TIME'];
					
					$vToken = $this->getAuthToken();

					if(empty($vToken))
					{
						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
					else
					{
						
						if($this->MTS->authenticate($vToken))
						{
							
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							
								// $myFile = "testLogFile_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".".txt";
        //                         $fh = fopen($myFile, 'a');
        //                         $stringData = json_encode($getData). " - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
        //                         fwrite($fh, $stringData);
        //                         fclose($fh);
							
							$uid = $getData['id'];
							$dlat = $getData['dLat'];
							$dlng = $getData['dLng'];
							$dTripDistance = $getData['dTripDistance'];
							$nFranchiseeId =  $getData['nFranchiseeId'];

							$dCurrentDate = date("Y-m-d", $timestamp);
							$data = $this->MTS->checkworkstatus($uid,$dCurrentDate,$nFranchiseeId);

							
							if(empty($data))
							{
							    // frank
                                $hasTeam = $this->MTS->checkHasTeam($uid,$dCurrentDate,$nFranchiseeId);
                                if(count($hasTeam) > 0){
                                    $data1['teamID'] = (int)$hasTeam['nTeamhdrId'];
                                }else{
                                    $data1['teamID'] = null;
                                }
                                // $data1['uid'] = $uid;
                                // $data1['dCurrentDate'] = $dCurrentDate;
                                // $data1['nFranchiseeId'] = $nFranchiseeId;
                                // $data1['hasTeam'] = $hasTeam;
								$data1['status'] = 0;
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $data1;                
								$this->message = "No Result Found!";
								
								
							}
							else 
							{
								if($data['isReachedOffice'] == 0)
								{
								    $isLeader = $this->MTS->isLeader($uid,$dCurrentDate,$nFranchiseeId);
								    $data1['isLeader'] = $isLeader;
									$data1['status'] = 1;
									$data1['nWorkHistoryId'] = $data['id'];
								// 	$data1['nTeamId'] = $data['nTeamId'];
								// New Changes
								    $data1['nTeamId'] = $this->MTS->getCurrentTeamId($uid,$dCurrentDate,$nFranchiseeId);
									$data1['dLat'] = empty($dlat)?'0.00':$dlat;
									$data1['dLng'] = empty($dlng)?'0.00':$dlng;
									$data1['dTripDistance'] = empty($dTripDistance)?0:$dTripDistance;
									$this->status = Ws_Controller::HTTP_OK;
									$this->responseData = $data1;
									$this->message = "Workstatus Detail";
								}
								else if($data['isReachedOffice'] == 1)
							    {

									$data1['status'] = 2;
									$this->status = Ws_Controller::HTTP_OK;
									$this->responseData = $data1;
									$this->message = "Workstatus Detail";
									

								}
								else
							    {

									$data1['status'] = 2;
									$this->status = Ws_Controller::HTTP_OK;
									$this->responseData = $data1;
									$this->message = "Workstatus Detail";
									

							    }



							}
							
						}
						else
						{
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->responseData = array();            
							$this->message = "Wrong Token Sent";
							
							
						}			
						
					}
					
				} 
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "Enter timestamp value";
				}
				
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}



		/*
			*  getOfficelist 
			*
		*/
		function getOfficelist()
		{
			$request = \Config\Services::request();
			if ($request->is('get'))
			{
				
				$vToken = $this->getAuthToken();
				
				if(empty($vToken))
				{
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					//$this->responseData = "";
					$this->message = "No Token Send";
				}
				else
				{
					
					if($this->MTS->authenticate($vToken))
					{
				
					$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
					$uid = $getData['id'];
					$nFranchiseeId =  $getData['nFranchiseeId'];
						
						$data = $this->MTS->select_mts('officemst',array('isActive'=>1,"nFranchiseeId"=>$nFranchiseeId));

						if(empty($data))
						{
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();                
							$this->message = "No Result Found!";
						}
						else
						{
							$array3 = array();
							$arrayDemo = array();
							
							for($i=0 ;$i<count($data);$i++)
							{
								$data1['id'] = $data[$i]['id']==""?"":$data[$i]['id'];
								$data1['vName'] = $data[$i]['vName']==""?"":$data[$i]['vName'];
								$data1['dLat'] = $data[$i]['dLat']==""?"":$data[$i]['dLat'];
								$data1['dLng'] = $data[$i]['dLng']==""?"":$data[$i]['dLng'];
								//$array3 = $data1;
								array_push($array3,$data1);
							}

							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							//  $this->extraData = $data2;
							$this->message = "Office List";
						}
					}
					else
					{	
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();            
						$this->message = "Wrong Token Sent";
					}
				}
			} 
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		
		function cancelWork()
		{
		    
		   
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				
               	$validation = \Config\Services::validation();
				$validation->setRule('nWorkId', 'nWorkId', 'trim|required'); 
				$validation->setRule('nCancleReason', 'nCancleReason', 'trim|required');
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
				
					$nWorkId=$PostData['nWorkId'];
					
					$nCancleReason=$PostData['nCancleReason'];
				
					$dCurrentDate = $this->MTS->getserverdate();
					
					$vToken = $this->getAuthToken();
					if (!empty($vToken))
				    {
						
						if($this->MTS->authenticate($vToken))
						{
						    $employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$employeeId = $employeeData['id'];
							$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
						    
						    $this->MTS->updateInWorkStatus([$employeeId], 0,$dCurrentDate);
							
							$Workdata= $this->MTS->update_mts("workhdr",array("nStatus"=>2 , "nCancleReason"=>$nCancleReason, "dModifiedDate"=>$dCurrentDate),array("id"=>$nWorkId));
							
								if ($Workdata)
								{ 
								//   $this->MTS->updateInWorkStatus([$employeeId], 0, $currentDate);
								   $this->MTS->update_mts("employeeinoutmst",array("dOutTime"=>$dCurrentDate, "dModifiedDate"=>$dCurrentDate),array("nWorkhdrId"=>$nWorkId));
								   
    							    $this->status = Ws_Controller::HTTP_OK;
    							    //$this->responseData = $data1;
    							    $this->message = "Work details successfully canceled";
								   
								
								}
								else
								{
									$this->status = Ws_Controller::HTTP_NOT_FOUND;
									//$this->responseData = array();                
									$this->message = "Fail";
								}
							
							
						}
						else
				        {
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							//$this->responseData = "";
							$this->message = "Wrong Token Sent";
							
							
						}
					}
					else
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
				}
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
			}
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		
		
		/*New Change for Employee Distance*/
		
		
		function updateEmployeeDistance()
		{
		    
		   
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				
               	$validation = \Config\Services::validation();
				$validation->setRule('nWorkhdrId', 'nWorkhdrId', 'trim|required'); 
				$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
				$validation->setRule('nEmpId', 'nEmpId', 'trim|required');
				$validation->setRule('dDistance', 'dDistance', 'trim|required');
				
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
				
					
					$vToken = $this->getAuthToken();
					if (!empty($vToken))
				    {
						
						if($this->MTS->authenticate($vToken))
						{
						    
						    
						    	//$PostData = $this->input->post();
				
					            $nWorkhdrId=$PostData['nWorkhdrId'];
					
					            $nTeamId=$PostData['nTeamId'];
					            
					            $nEmpId=$PostData['nEmpId'];
					            
					            $dDistance=$PostData['dDistance'];
				
					            $dCurrentDate = $this->MTS->getserverdate();
						    
							
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
					         $uid = $getData['id'];
					         
					         
					         $workdistancedata = $this->MTS->selectone("employeedistancemst",array("nEmpId"=>$nEmpId , "nTeamId"=>$nTeamId, "nWorkhdrId"=>$nWorkhdrId, "isActive"=>1));
					         
					        
							if($workdistancedata)
							{
							    
							    $dTotalDistance = $workdistancedata['dTotalDistance'] + $dDistance;
							    
							    $Distancedata= $this->MTS->update_mts("employeedistancemst",array("dTotalDistance"=>$dTotalDistance, "dModifiedDate"=>$dCurrentDate),array("id"=>$workdistancedata['id']));
							
								if ($Distancedata)
								{ 
								    
								   
    							    $this->status = Ws_Controller::HTTP_OK;
    							    //$this->responseData = $data1;
    							    $this->message = "Employee Distance successfully updated";
								   
								
								}
								else
								{
									$this->status = Ws_Controller::HTTP_NOT_FOUND;
									//$this->responseData = array();                
									$this->message = "Fail to update";
								}
							
							}
							else
							{
							    	$this->status = Ws_Controller::HTTP_NOT_FOUND;
									//$this->responseData = array();                
									$this->message = "Result Not Found";
							}
							
						
							
						}
						else
				        {
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							//$this->responseData = "";
							$this->message = "Wrong Token Sent";
							
							
						}
					}
					else
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
				}
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
			}
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		
		function addWorkNew_cr()
		{
		    
		   
			$request = \Config\Services::request();
			if ($request->is('post'))
			{
				
				
                //$validation->setRule('nCustId', 'nCustId', 'trim|required');
				//$validation->setRule('tInTime', 'tInTime', 'trim|required'); 
				//$validation->setRule('tOutTime', 'tOutTime', 'trim|required');
				//$validation->setRule('dWorkDate', 'dWorkDate', 'trim|required'); 
				//$validation->setRule('dAmount', 'dAmount', 'trim|required');
				//$validation->setRule('vPaymentMethod', 'vPaymentMethod', 'trim|required'); 
				$validation = \Config\Services::validation();
				$validation->setRule('dLat', 'dLat', 'trim|required'); 
				$validation->setRule('dLng', 'dLng', 'trim|required');
				$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
				//$validation->setRule('nSId', 'nSId', 'trim|required'); 
				$PostData = $request->getPost();
				if ($validation->run($PostData))
				{
					//$PostData = $this->input->post();
					
					$isDifferentDay = 0;
					
					$dWorkDateToCompare=$PostData['dWorkDate'];
							
					$nCustId=$PostData['nCustId'];
					
					$nWorkId=$PostData['nWorkId'];
					
					$dAmount=$PostData['dAmount'];
					
					$nTeamId=$PostData['nTeamId'];
					
					
					$isUpdateTeamForOngoingWork = $PostData['isUpdateTeamForOngoingWork'];
					
					$nWorkHistoryId = $PostData['nWorkHistoryId'];
					$tEndTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
					$dDate=date('Y-m-d', $_SERVER['REQUEST_TIME']);
					
					
					
				    $tInTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);//$PostData['tInTime'];
				    $tInTime = empty($tInTime)?NULL:$tInTime;
					
					$tOutTime=$PostData['tOutTime'];
				    $tOutTime = empty($tOutTime)?NULL:$tOutTime;
					
					$dWorkDate= date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);//$PostData['dWorkDate'];
					//echo $dWorkDate;
					//exit;
					//$a = explode('-',$dWorkDate);
					//$dWorkDate = $a[2].'-'.$a[1].'-'.$a[0];
					
					$vPaymentMethod=$PostData['vPaymentMethod'];
					$aWorkList=$PostData['aWorkList'];
					
					$vChequeNo      = $PostData['vChequeNo'];
					$vChequeNo = empty($vChequeNo)?NULL:$vChequeNo;
					$dLat=$PostData['dLat'];
					$dLng=$PostData['dLng'];
					$nDistPrevWork=empty($PostData['nDistPrevWork'])?0:$PostData['nDistPrevWork'];
					
					$TeamEmpStr = $PostData['TeamEmpStr'];
					
					$Distancestr = $PostData['Distancestr'];
					
				   $OutTimestr = $PostData['OutTimestr'];
					
					$dCurrentDate = $this->MTS->getserverdate();
					
					$vToken = $this->getAuthToken();
					if (!empty($vToken))
				    {
						
						if($this->MTS->authenticate($vToken))
						{
						    
						    //	if($nWorkId)
							//	{
								 //   if()
								//    {
						    	  // $this->status = Ws_Controller::HTTP_OK;
								//	$data1 = array();
								//	$data1["isWorkAdded"] = 0;
									
								//	$this->responseData = $data1;
									
								//	$this->message = "Can not add details for previous day work.";
								   // }
							//	}
						    
							$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$uid = $getData['id'];
							$nUserId = $uid;
							$nFranchiseeId =  $getData['nFranchiseeId'];
							
								// $myFile = "testFile_".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".$nUserId.".txt";
        //                         $fh = fopen($myFile, 'a');
        //                         $stringData = json_encode($PostData). " - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
        //                         fwrite($fh, $stringData);
        //                         fclose($fh);
							
							//$workdata = $this->MTS->daywork($uid,$dWorkDate);
							//$nCustId = $workdata['nCustId'];
							if(empty($nCustId))
							{
						     $workdata = $this->MTS->selectone('workhdr',array('id'=>$nWorkId));
							  $nCustId = $workdata['nCustId'];
							}
							else
							{
							   $nCustId=$PostData['nCustId'];
							}
							
							
							   $vDeleteEmpId=$PostData['vDeleteEmpId'];
								    $vAddEmpId=$PostData['vAddEmpId'];
							
							$custdata = $this->MTS->selectone('customermst',array('id'=>$nCustId));
							$custName = $custdata['vName'];
							$wdLat = $custdata['dLat'];
							$wdLng = $custdata['dLng'];
							
								if(date('Y-m-d', $_SERVER['REQUEST_TIME'])!=date('Y-m-d', strtotime($dWorkDateToCompare. " UTC")))
									{
									  
									    
									    $isDifferentDay=1;
									}
									
									//frank $this->MTS->distance($dLat,$dLng, $wdLat, $wdLng,"")
							
							if($this->MTS->distance($dLat,$dLng, $wdLat, $wdLng,"ME") < 100 && $isDifferentDay==0 && ($vAddEmpId == "" && $vDeleteEmpId == ""))
							{
								
								 
								$message = "Tried to ".(empty($nWorkId)?"start":"stop")." work away from customer home";
								
								
								if(!empty($nWorkId))
								{
									$responseData = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid,"nCustId"=>$nCustId,"nWorkhdrId"=>$nWorkId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
									
									}else{							
									
									$responseData = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid,"nCustId"=>$nCustId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
								}
								if($responseData)
								{
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									//$this->responseData = $array3;
									$this->message = "Can not update while away from customer's home.";
									}else{
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									//$this->responseData = $array3;
									$this->message = "Can not update while away from customer's home.";
								}
							}
							else
							{
								if($nWorkId && $isUpdateTeamForOngoingWork != 1)
								{
									if(($tOutTime == NULL) || ($tOutTime == ""))
									{
										$tOutTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
									}
									else{
										$tOutTime = $tOutTime;
									}
									
								
								     //$PostData['tInTime'];
				                    if($isDifferentDay==0)
				                    {
				                        
				                        /*
				                        
				                        $Workdetails =  $this->MTS->selectone('workhdr',array('id'=>$nWorkId,'isActive'=>1));
				                        
				                        $nTeamId = $Workdetails['nTeamId'];
									   
									    $Teamdetails =  $this->MTS->select_mts('teamdtl',array('nTeamhdrId'=>$nTeamId,'isActive'=>1));
									    
									    */
									   
									    $Workdata= $this->MTS->update_mts("workhdr",array("nUserId"=>$uid, "dAmount"=>$dAmount, "vPaymentMethod"=>$vPaymentMethod, "vChequeNo"=>$vChequeNo, "nStatus"=>1 , "tOutTime"=>$tOutTime, "dLat"=>$dLat, "dLng"=>$dLng, "dModifiedDate"=>$dCurrentDate),array("id"=>$nWorkId),$nUserId);
				                    
				                        $TeamEmpArray = explode(",",$TeamEmpStr);
				                        
				                        $OutTimeArray = explode(",",$OutTimestr);
				                        
				                        
				                        //$tOutTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
				                        
				                        
				                        	if(($tOutTime == NULL) || ($tOutTime == ""))
									     {
										    $tOutTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
									     }
									    else{
										    $tOutTime = $tOutTime;
									      }
				                        
				                        
				                    
				                        for($l=0;$l<count($OutTimeArray);$l++)
									    {
									        
									       $updateinout = $this->MTS->update_mts('employeeinoutmst',array("dOutTime"=>$tOutTime,"dModifiedDate"=>$dCurrentDate),array('nEmpId'=>$TeamEmpArray[$l],"nWorkhdrId"=>$nWorkId,"isActive"=>1));
								            
									    }
				                        
				                        
				                    }else
				                    {
									    $Workdata= $this->MTS->update_mts("workhdr",array("nUserId"=>$uid, "dAmount"=>$dAmount, "vPaymentMethod"=>$vPaymentMethod, "vChequeNo"=>$vChequeNo, "nStatus"=>1 , "dLat"=>$dLat, "dLng"=>$dLng, "dModifiedDate"=>$dCurrentDate),array("id"=>$nWorkId),$nUserId);
				                    }
									
									for($i=0;$i<count($aWorkList);$i++)
									{
										
										$Workdtlid = $this->MTS->insert_mts("workdtl",array("nFranchiseeId"=>$nFranchiseeId,"nWorkId"=>$nWorkId,"nSId"=>(explode(",",$aWorkList[$i])[0]),"nUserId"=>(explode(",",$aWorkList[$i])[1]),"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
									}
								}
								else
								{
								    
								    $vDeleteEmpId=$PostData['vDeleteEmpId'];
								    
								    $vDeleteEmpOutTimestr=$PostData['vDeleteEmpOutTimestr'];
								    
								    
								    $vAddEmpId=$PostData['vAddEmpId'];
								    
								    
								    $vAddEmpInTimestr=$PostData['vAddEmpInTimestr'];
								    
								    $vAddEmpDistancestr=$PostData['vAddEmpDistancestr'];
								    
								    if($vDeleteEmpId)
								    {
								       
								        
								        
								        $DeletedId = explode(",",$vDeleteEmpId);
								        
								        $vDeleteEmpOutTime = explode(",",$vDeleteEmpOutTimestr);
								        
								        for($j=0;$j<count($DeletedId);$j++)
								        {
								            
								            
								            
								            
								            $update = $this->MTS->update_mts('teamdtl',array('isActive'=>2),array('nUserId'=>$DeletedId[$j],'nTeamhdrId'=>$nTeamId));
								            
								            $this->MTS->insert_mts("empteammst",array("nUserId"=>$DeletedId[$j],"nTeamId"=>$nTeamId, "nType"=>2, "isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								            
								            
								            $dOutTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
								            
								            if(!empty($DeletedId))
								            {
								                $updateinout = $this->MTS->update_mts('employeeinoutmst',array("dOutTime"=>$dOutTime,"dModifiedDate"=>$dCurrentDate),array('nEmpId'=>$DeletedId[$j],"nWorkhdrId"=>$nWorkId,"isActive"=>1));
								            }
								            
								        }
								    }
								    
								    
								    if($vAddEmpId)
								    {
								        $AddEmpId = explode(",",$vAddEmpId);
								        
								        $vAddEmpInTime = explode(",",$vAddEmpInTimestr);
								        $vAddEmpDistance = explode(",",$vAddEmpDistancestr);
								        
								        for($j=0;$j<count($AddEmpId);$j++)
								        {
								            $Teamdata = $this->MTS->selectone('teamhdr',array('id'=>$nTeamId,'isActive'=>1));
								            
								            $tdetailData =$this->MTS->selectone('teamdtl',array('nUserId'=>$AddEmpId[$j],'nTeamhdrId'=>$nTeamId));
								            
								            if(empty($tdetailData))
								            {
								                $update = $this->MTS->insert_mts('teamdtl',array('nFranchiseeId'=>$Teamdata['nFranchiseeId'],'nTeamhdrId'=>$nTeamId,'nUserId'=>$AddEmpId[$j],"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								             
								            }
								            else
								            {
								                $update = $this->MTS->update_mts('teamdtl',array("isActive"=>1,"dModifiedDate"=>$dCurrentDate),array('nTeamhdrId'=>$nTeamId,'nUserId'=>$AddEmpId[$j]));
								             
								            }
								            
								           
								           if(!empty($vAddEmpDistance))
								            { 	
								                
								                $date = date('Y-m-d',strtotime($dCurrentDate));
								                $EmpDistance = $this->MTS->getEmployeeDistance($AddEmpId[$j],$date);
								                if($EmpDistance)
								                {
								                   $empTotalDistance = $EmpDistance['EmpTotalDistance'] + $vAddEmpDistance[$j];
								                }
								                else
								                {
								                     $empTotalDistance = $vAddEmpDistance[$j];
								                }
								                
								            	
								              $updatedistance = $this->MTS->insert_mts('employeedistancemst',array('nEmpId'=>$AddEmpId[$j],'nTeamId'=>$nTeamId,'nWorkhdrId'=>$nWorkId,"dTotalDistance"=>$empTotalDistance,"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								          
								          $dInTime=date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
								          
								              $updateinout = $this->MTS->insert_mts('employeeinoutmst',array('nEmpId'=>$AddEmpId[$j],"dInTime"=>$dInTime,'nWorkhdrId'=>$nWorkId,"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								            
								            }	
								            	
								            	
								            	$userdistance  = $this->MTS->sumdistancedata($AddEmpId[$j],$dDate);
							                $nUserTotalDistance = $userdistance['TotalDistance'];
								            
								            $this->MTS->insert_mts("empteammst",array("nUserId"=>$AddEmpId[$j],"nTeamId"=>$nTeamId,"dTotalDistance"=>$nUserTotalDistance, "nType"=>1, "isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								            
								        }
								        
								              $wdata = $this->MTS->selectone('workhdr',array('id'=>$nWorkId,'isActive'=>1));
								              
								              $nNumberOfEmployee = $wdata['nNumberOfEmployee'] + count($AddEmpId);
								              
								              $this->MTS->update_mts("workhdr",array("nNumberOfEmployee"=>$nNumberOfEmployee,"dModifiedDate"=>$dCurrentDate),array('id'=>$nWorkId),$nUserId);
								    }
								    
								    
								    
									if($isUpdateTeamForOngoingWork != 1)
									{
					                 
					                 $TeamEmpArray = explode(",",$TeamEmpStr);
					                 
					                  $DistanceArray = explode(",",$Distancestr);
					                 
					                  $nNumberOfEmployee = count($TeamEmpArray);
									    
									  $nWorkId = $this->MTS->insert_mts("workhdr",array("nFranchiseeId"=>$nFranchiseeId,"nUserId"=>$uid, "nCustId"=>$nCustId, "nTeamId"=>$nTeamId, "nNumberOfEmployee"=>$nNumberOfEmployee, "dWorkDate"=>$dWorkDate, "tInTime"=>$tInTime, "dLat"=>$dLat, "dLng"=>$dLng, "nDistPrevWork"=>$nDistPrevWork, "isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate),$nUserId);
									  
									 
									 for($k=0;$k<count($TeamEmpArray);$k++)
									 {
									     
									          $date = date('Y-m-d',strtotime($dCurrentDate));
								                $EmpDistance = $this->MTS->getEmployeeDistance($TeamEmpArray[$k],$date);
								                if($EmpDistance)
								                {
								                    $empTotalDistance = $EmpDistance['EmpTotalDistance'] + $DistanceArray[$k];
								                }
								                else
								                {
								                     $empTotalDistance = $DistanceArray[$k];
								                }
								                
									     
									     $updatedistance = $this->MTS->insert_mts('employeedistancemst',array('nEmpId'=>$TeamEmpArray[$k],'nTeamId'=>$nTeamId,'nWorkhdrId'=>$nWorkId,"dTotalDistance"=>$empTotalDistance,"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								          
								          $updateinout = $this->MTS->insert_mts('employeeinoutmst',array('nEmpId'=>$TeamEmpArray[$k],"dInTime"=>$tInTime,'nWorkhdrId'=>$nWorkId,"isActive"=>1,"dModifiedDate"=>$dCurrentDate,"dCreatedDate"=>$dCurrentDate));
								            
									 }
									  
									  
									  $update = $this->MTS->update_mts('usermst',array('dTripDistance'=>0),array('id'=>$uid),$nUserId);
									}
									
									
									if(!empty($nWorkHistoryId))
									{
									    	$distance  = $this->MTS->sumdistancedata($uid,$dDate);
							                $nTotalDistance = $distance['TotalDistance'];
							                $WorkHistoryId = $this->MTS->update_mts("workhistory",array("tEndTime"=>$tEndTime, "nTotalDistance"=>$nTotalDistance,"isReachedOffice"=>0),array('id'=>$nWorkHistoryId),$nUserId);
									}
								
								}
								
							
								if ($nWorkId)
								{ 
								    
								    if($isDifferentDay==0){
    									$this->status = Ws_Controller::HTTP_OK;
    										$data1 = array();
    									$data1["isWorkAdded"] = 1;
    									
    									$this->responseData = $data1;
    									$this->message = "Work details successfully added";
								    }else{
								        
    								    $this->status = Ws_Controller::HTTP_OK;
    									$data1 = array();
    									$data1["isWorkAdded"] = 0;
    									
    									$this->responseData = $data1;
    									
    									$this->message = "Can not add details for previous day work.";
								    }
								
								}
								else
								{
									$this->status = Ws_Controller::HTTP_NOT_FOUND;
									//$this->responseData = array();                
									$this->message = "Fail";
								}
							}
							
						}
						else
				        {
							
							$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							//$this->responseData = "";
							$this->message = "Wrong Token Sent";
							
							
						}
					}
					else
					{
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						//$this->responseData = "";
						$this->message = "No Token Send";
					}
				}
				else
				{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
				}
			}
			else
			{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		
		function startWork(){
			$request = \Config\Services::request();
			if ($request->is('post')){
			    $validation = \Config\Services::validation();
                $validation->setRule('dLat', 'dLat', 'trim|required'); 
                $validation->setRule('dLng', 'dLng', 'trim|required');
                $validation->setRule('nTeamId', 'nTeamId', 'trim|required');
                $PostData = $request->getPost();
                if ($validation->run($PostData)){
                    
                    //Request Data
                    
                    $customerId = $PostData['nCustId'];
                    $newTeamMembers = $PostData['newlyAddedTeamMembers'] == "" ? [] : explode(",",$PostData['newlyAddedTeamMembers']);
                    $deletedTeamMembers = $PostData['deletedTeamMembers'] == "" ? [] : explode(",",$PostData['deletedTeamMembers']);
                    $currentTeamMembers = $PostData['currentTeamMembers'] == "" ? [] : explode(",",$PostData['currentTeamMembers']);
                    $teamId = $PostData['nTeamId'];
                    $employeeLatitude = $PostData['dLat'];
                    $employeeLongitude = $PostData['dLng'];
                    $distanceTravelled = $PostData['nDistPrevWork'];
                    $workHistoryId = $PostData['nWorkHistoryId'];
                    
                    $vToken = $this->getAuthToken();
                    $currentDate = $this->MTS->getserverdate();
                    
                    if($vToken){
                        
                        if($this->MTS->authenticate($vToken)){
                            
                                $userDetail = $this->MTS->getUserDetail(array("vToken" => $vToken));
                                $distanceTravelled = empty($userDetail['dTripDistance'])?NULL:$userDetail['dTripDistance'] ;
                             
                            //Getting Customer details
                            
                            $customerData = $this->MTS->selectone('customermst',array('id'=>$customerId));
					        $customerName = $customerData['vName'];
					        $customerLatitude = $customerData['dLat'];
					        $customerLongitude = $customerData['dLng'];
					        
					        //Getting Employee details
					        
					        $employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$employeeId = $employeeData['id'];
							$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
					        
                            //To check whether the employee has arrived near the customers place
   
                            $distance_difference = $this->MTS->distance($employeeLatitude,$employeeLongitude, $customerLatitude, $customerLongitude,"ME");
                            
                            if($distance_difference > 100){
                                if($this->MTS->determineLocation($customerLatitude,$customerLongitude) == "premise" && $distance_difference < 500){
                                    
                                    if(count($newTeamMembers) > 0){
							            $this->addTeamMembers($newTeamMembers, $employeeId, $teamId, $teamHdrData['nFranchiseeId'],$currentDate);
							            
							        }else{
							            $this->MTS->updateInWorkStatus([$employeeId], 1,$currentDate);
							        }
							    
							        if(count($deletedTeamMembers) > 0){
							            $this->removeTeamMembers($deletedTeamMembers, $teamId, $currentDate);
							        }
							    
							        $message = "Tried to start work in a condo complex";
							    	$sendNotification = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$employeeFranchiseeId,"nUserId"=>$employeeId,"nCustId"=>$customerId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate),$employeeId);
								    $duplicate = $currentTeamMembers;
								    unset($duplicate[array_search($employeeId, $duplicate)]);
								    $team_members_list = array_merge([$employeeId], array_values($duplicate)); 
								    $team_details = $this->MTS->team_details_start_form(implode(',',$team_members_list), $teamId);
								    $data = array(
								        'customer_name' => $customerName,
								        'employee_list' => $team_details
								    );
								    $this->responseData = $data;
								    $this->status = Ws_Controller::HTTP_OK;
								    $this->message = "Update manually while in a condo complex.";
                                }else{
                                    $message = "Tried to start work away from customer home";
								    $sendNotification = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$employeeFranchiseeId,"nUserId"=>$employeeId,"nCustId"=>$customerId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate),$employeeId);
								    $this->status = Ws_Controller::HTTP_BAD_REQUEST;
								    $this->message = "Can not update while away from customer's home.";
                                }
						        
								
							}else{
							    
							    // Adding new members to my team(teamdtl table)
							    
							    if(count($newTeamMembers) > 0){
							        $this->addTeamMembers($newTeamMembers, $employeeId, $teamId, $teamHdrData['nFranchiseeId'],$currentDate);
							    }else{
							        $this->MTS->updateInWorkStatus([$employeeId], 1,$currentDate);
							    }
							    
							    // Deleting existing members in my team(teamdl table) isActive 1 => 0
							    
							    if(count($deletedTeamMembers) > 0){
							        $this->removeTeamMembers($deletedTeamMembers, $teamId, $currentDate);
							    }
							    // construyc
							    $teammates = $this->MTS->getTeamMates($teamId); 
							    
							 //   if(count($newTeamMembers) > 0){
								//     $teammates = array_merge($newTeamMembers, [$employeeId]);
								// }else{
								//     $teammates = [$employeeId];
								// }
							    
							    // Adding entry in the workhdr table
							    
							    $workHdrId = $this->MTS->insert_mts("workhdr",array("nFranchiseeId"=>$employeeFranchiseeId,"team_mates"=>$teammates,"nUserId"=>$employeeId, "nCustId"=>$customerId, "nTeamId"=>$teamId, "nNumberOfEmployee"=>count($currentTeamMembers), "dWorkDate"=>$currentDate, "tInTime"=>$currentDate, "dLat"=>$employeeLatitude, "dLng"=>$employeeLongitude, "nDistPrevWork"=>$distanceTravelled, "isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate),$employeeId);
							    
							    // Adding the distance in employeedistancemst table
							    
							    $date = date('Y-m-d',strtotime($currentDate));
							    $employeeDistance = $this->MTS->getEmployeeDistance($employeeId,$date);
							    
								if($employeeDistance){
								    $employeeTotalDistance = $employeeDistance['EmpTotalDistance'] + $distanceTravelled;
								}
								else{
								    $employeeTotalDistance = $distanceTravelled;
								}
								
								// Updating distance in employeedistancemst table
							    
							    $updatedistance = $this->MTS->insert_mts('employeedistancemst',array('nEmpId'=>$employeeId,'nTeamId'=>$teamId,'nWorkhdrId'=>$workHdrId,"dTotalDistance"=>$employeeTotalDistance,"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
							    
							    // Adding start time in employeeinoutmst table
							    
								$updateinout = $this->MTS->insert_mts('employeeinoutmst',array('nEmpId'=>$employeeId,"dInTime"=>$currentDate,'nWorkhdrId'=>$workHdrId,"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
							    
							    // Reseting trip distance in usermst table
							    
							    $updateuser = $this->MTS->update_mts('usermst',array('dTripDistance'=>0),array('id'=>$employeeId),$employeeId);
							    
							     // $fh = fopen($myFile, 'a');
            //                     $stringData = json_encode($updateuser). " - " .date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME'])."\n";
            //                     fwrite($fh, $stringData);
            //                     fclose($fh);
                                
							    // Updating my trip distance in workhistory table
							    
							    $distance  = $this->MTS->sumdistancedata($employeeId,$date);
							    $workHistoryDistance = $distance['TotalDistance'];
							    $this->MTS->update_mts("workhistory",array("nTotalDistance"=>$workHistoryDistance,"isReachedOffice"=>0),array('id'=>$workHistoryId),$employeeId);
							    
							    // Updating teamdtl status to active for team leader
							 //   $updateuser = $this->MTS->update_mts('teamdtl',array('isActive'=>1),array('nUserId'=>$employeeId,'nTeamhdrId'=>$teamId,'isLeader'=>1),$employeeId);
							    
							    
							    $this->status = Ws_Controller::HTTP_OK;
    							$data1 = array();
    							$data1["isWorkAdded"] = 1;
    							$data1["customerLat"] = $customerLatitude;
    							$data1["customerLng"] = $customerLongitude;

    							$this->responseData = $data1;
    							$this->message = "Work details successfully added";
							}
							
                        }else{
                            $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->message = "Wrong Token Sent";
                        }
                    }else{
                        $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "No Token Send";
                    }
                }else{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
                }
			}else{
			    $this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		private function addTeamMembers($team_members, $leader_id, $team_id, $franchisee_id, $current_date){
		    $newArr = array_merge($team_members, [$leader_id]);
			$this->MTS->updateInWorkStatus($newArr, 1, $current_date);
			$this->MTS->updatePrevTeamStatus($team_members,$current_date);
			for($index = 0; $index < count($team_members); $index++){
				// Getting the teamhdr table entry
				$teamHdrData = $this->MTS->selectone('teamhdr',array('id'=>$team_id,'isActive'=>1));
				// Checking whether the team member has already in team before(teamdtl table)
				$tdetailData =$this->MTS->selectone('teamdtl',array('nUserId'=>$team_members[$index],'nTeamhdrId'=>$team_id));
				if(empty($tdetailData)){
					$update = $this->MTS->insert_mts('teamdtl',array('nFranchiseeId'=>$franchisee_id,'nTeamhdrId'=>$team_id,'nUserId'=>$team_members[$index],"isActive"=>1,"dModifiedDate"=>$current_date,"dCreatedDate"=>$current_date));
				}else{
					$update = $this->MTS->update_mts('teamdtl',array("isActive"=>1,"dModifiedDate"=>$current_date),array('nTeamhdrId'=>$team_id,'nUserId'=>$team_members[$index]));
				}
			}
		}
		
		
		private function removeTeamMembers($team_members, $team_id, $current_date){
		    // Modifying inWork table to make the employee inWork status inactive
			$this->MTS->updateInWorkStatus($team_members, 0,$current_date);
			// New Changes
			for($index = 0; $index < count($team_members); $index++){
				$update = $this->MTS->update_mts('teamdtl',array('isActive'=>0),array('nUserId'=>$team_members[$index],'nTeamhdrId'=>$team_id));
				$insert = $this->MTS->insert_mts("empteammst",array("nUserId"=>$team_members[$index],"nTeamId"=>$team_id, "nType"=>2, "isActive"=>1,"dModifiedDate"=>$current_date,"dCreatedDate"=>$current_date));
			}
		}
		
		
		function mannualFormSubmit(){
			$request = \Config\Services::request();
			if ($request->is('post')){
			    $validation = \Config\Services::validation();
			    $validation->setRule('nCustId', 'nCustId', 'trim|required'); 
                $validation->setRule('formType', 'formType', 'trim|required'); 
                $validation->setRule('teamId', 'teamId', 'trim|required');
                $postData = $request->getPost();
                if ($validation->run($postData)){
                    // Request Data
                    $customerId = $postData['nCustId'];
                    $form_type = $postData['formType'];
                    $teamId = $postData['teamId'];
                    $formData = json_decode(stripslashes($postData['employeeForms']));
                    
                    $vToken = $this->getAuthToken();
                    $currentDate = $this->MTS->getserverdate();
                    $date = date('Y-m-d',strtotime($currentDate));
                    
                    // $file = "Franklin_manual_work_update.txt";
                    // $file_open = fopen($file, 'a');
                    // $file_text = json_encode($postData) ."\n";
                    // fwrite($file_open, $file_text);
                    // fclose($file_open);
							
        //             $this->status = Ws_Controller::HTTP_OK;
        //             $data = array();
        //             $this->responseData = $data;
    				// $this->message = "Work details successfully added";
    				// exit;
                    
                    if($vToken){
                        if($this->MTS->authenticate($vToken)){
                            
                            //Getting Customer details
                            $customerData = $this->MTS->selectone('customermst',array('id'=>$customerId));
					        $customerName = $customerData['vName'];
					        $customerLatitude = $customerData['dLat'];
					        $customerLongitude = $customerData['dLng'];
					        
                            //Getting Employee details
                            $employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
					        $employeeId = $employeeData['id'];
					        $employeeFranchiseeId =  $employeeData['nFranchiseeId'];
					        
					        $teammatesForm = array();
					        $teamLeadersData;
					        $teammates = array();
					        
					       // $file = "Franklin_manual_work_update.txt";
            //                 $file_open = fopen($file, 'a');
            //                 $file_text = json_encode($postData) ."\n";
            //                 fwrite($file_open, $file_text);
            //                 fclose($file_open);
                    
					        foreach($formData as $data){
					            $data->nDistanceTravelled = $data->nDistanceTravelled;
					            $data->InTime = $this->MTS->timeToTimestamp($data->InTime);
					            array_push($teammates, $data->id);
					            if($data->id == $employeeId){
					                $teamLeadersData = $data;
					            }
					        }
					        
					        
                            
                            if($form_type == 0){
                                
                                $workHdrId = $this->MTS->insert_mts("workhdr",array("nFranchiseeId"=>$employeeFranchiseeId,"team_mates"=>implode(',',$teammates),"nUserId"=>$employeeId, "nCustId"=>$customerId, "nTeamId"=>$teamId, "nNumberOfEmployee"=>count($teammates), "dWorkDate"=>$teamLeadersData->InTime, "tInTime"=>$teamLeadersData->InTime, "dLat"=>$customerLatitude, "dLng"=>$customerLongitude, "nDistPrevWork"=>$teamLeadersData->nDistanceTravelled, "isActive"=>1,"is_mannual_update"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate),$employeeId);
                              
                                foreach($formData as $data){
                                    $file = "Franklin_manual_work_update.txt";
                                    $file_open = fopen($file, 'a');
                                    $file_text = json_encode($data) ."\n";
                                    $file_text .= !empty($data->nDistanceTravelled) ."\n";
                                    fwrite($file_open, $file_text);
                                    fclose($file_open);
                                    if(!empty($data->nDistanceTravelled)){
                                       $updatedistance = $this->MTS->insert_mts('employeedistancemst',array('nEmpId'=>$data->id,'nTeamId'=>$data->nTeamId,'nWorkhdrId'=>$workHdrId,"dTotalDistance"=>$data->nDistanceTravelled * 1609.34, "manual_distance" => $data->nDistanceTravelled,"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate)); 
                                    }
                                    
                                         
                                    
                                    $updateinout = $this->MTS->insert_mts('employeeinoutmst',array('nEmpId'=>$data->id,"dInTime"=>$currentDate,'nWorkhdrId'=>$workHdrId,"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
                                    $updateuser = $this->MTS->update_mts('usermst',array('dTripDistance'=>0),array('id'=>$data->id),$data->id);
                                    
                                    if(property_exists($data, 'workHistoryId')) {
                                        $distance  = $this->MTS->sumdistancedata($data->id,$date);
							            $workHistoryDistance = $distance->TotalDistance;
                                        $this->MTS->update_mts("workhistory",array("nTotalDistance"=>$workHistoryDistance,"isReachedOffice"=>0),array('id'=>$data->workHistoryId),$data->id);
                                    }
                                    
                                }
                            //       $file = "Franklin_manual_work_update.txt";
                            // $file_open = fopen($file, 'a');
                            // $file_text = "success" ."\n";
                            // fwrite($file_open, $file_text);
                            // fclose($file_open);
                                
                                $this->status = Ws_Controller::HTTP_OK;
    							$response = array();
    							$response["isWorkAdded"] = 1;
    							$response["customerLat"] = $customerLatitude;
    							$response["customerLng"] = $customerLongitude;
    							$this->responseData = $response;
    							$this->message = "Work details successfully added";
    							exit;
                            }else if($form_type == 1){
                                
                                
                                
                                
                            }else{
                                $this->status = Ws_Controller::HTTP_BAD_REQUEST;
					            $this->message = "Invalid Form";
                            }
                            
                        }else{
                            $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->message = "Wrong Token Sent";
                        }
                    }else{
                        $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "No Token Send";
                    }
                }else{
                    $this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
                }
			}else{
			    $this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		function completeWork(){
		    $request = \Config\Services::request();
			if ($request->is('post')){
			    $validation = \Config\Services::validation();
                $validation->setRule('dLat', 'dLat', 'trim|required'); 
                $validation->setRule('dLng', 'dLng', 'trim|required');
                $validation->setRule('nTeamId', 'nTeamId', 'trim|required');
                $PostData = $request->getPost();

                if ($validation->run($PostData)){
                    
                    //Request Data
                    
                    $workHdrId = $PostData['nWorkId'];
                    $currentTeamMembers = explode(",",$PostData['currentTeamMembers']);
                    $teamId = $PostData['nTeamId'];
                    $employeeLatitude = $PostData['dLat'];
                    $employeeLongitude = $PostData['dLng'];
                    $priceCharged = $PostData['dAmount'];
                    $workList=$PostData['aWorkList'];
                    $paymentMethod = $PostData['vPaymentMethod'];
                    $chequeNumber = $PostData['vChequeNo'];
                    $workHistoryId = $PostData['nWorkHistoryId'];
                    $vToken = $this->getAuthToken();
                    
                    if($vToken){
                        
                        if($this->MTS->authenticate($vToken)){
                            
                            // Getting Customer details
                            
                            $workData = $this->MTS->selectone('workhdr',array('id'=>$workHdrId));
							$customerId = $workData['nCustId'];
                            $customerData = $this->MTS->selectone('customermst',array('id'=>$customerId));
					        $customerName = $customerData['vName'];
					        $customerLatitude = $customerData['dLat'];
					        $customerLongitude = $customerData['dLng'];
								  
							if(is_null($workData['tNotificationTime'])){
							    $currentDate = $this->MTS->getserverdate();
							}else{
							    $currentDate = $workData['tNotificationTime'];
							}
							
							
				// 			$this->responseData = $response;
				// 			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				// 		    $this->message = "Manual Update: '".$workData['is_manual_update'] ."'";
				// 			exit;
					        
					        // Getting Employee details
                            
                            $employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$employeeId = $employeeData['id'];
							$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
							
				            // For the work started in condominimum complex by manual data update
							if($workData['is_manual_update'] == "1"){
							    $team_details = $this->MTS->team_details_complete_form($workData['team_mates'], $teamId, $workHdrId);
							    
							    $response = array(
							        'customer_id' => $customerId,
							        'customer_name' => $customerName,
							        'employee_list' => $team_details
							    );
							    
							    $this->responseData = $response;
							    $this->status = Ws_Controller::HTTP_OK;
								$this->message = "Update manually while in a condo complex.";
								exit;
							}
							
							// Checking whether the employee completes the work nearby the customer's home
							
							if($this->MTS->distance($employeeLatitude,$employeeLongitude, $customerLatitude, $customerLongitude,"ME") > 100 && is_null($workData['tNotificationTime'])){
						        $message = "Tried to stop work away from customer home";
								$sendNotification = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$employeeFranchiseeId,"nUserId"=>$employeeId,"nCustId"=>$customerId,"nWorkhdrId"=>$workHdrId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate),$employeeId);
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
								
							}else{
							    // New changes
							    $this->MTS->updateInWorkStatus([$employeeId], 0, $currentDate);
							 //   $updateteamdtl = $this->MTS->update_mts("teamdtl",array("isActive" => 0),array("nTeamhdrId" => $teamId,"nUserId" => $employeeId));
							    $Workdata= $this->MTS->update_mts("workhdr",array("nUserId"=>$employeeId, "dAmount"=>$priceCharged, "vPaymentMethod"=>$paymentMethod, "vChequeNo"=>$chequeNumber, "nStatus"=>1 , "tOutTime"=>$currentDate, "dLat"=>$employeeLatitude, "dLng"=>$employeeLongitude, "dModifiedDate"=>$currentDate),array("id"=>$workHdrId),$employeeId);
							    for($index = 0; $index < count($workList); $index++){
							        
							    	$Workdtlid = $this->MTS->insert_mts("workdtl",array("nFranchiseeId"=>$employeeFranchiseeId,"nWorkId"=>$workHdrId,"nSId"=>(explode(",",$workList[$index])[0]),"nUserId"=>(explode(",",$workList[$index])[1]),"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate),$employeeId);
							    	
							    }
							    $updateouttime = $this->MTS->updatAllOutTime($currentDate,$workHdrId);
							    
							    //    ==================   //
							    
							    $addinouttime = $this->MTS->addInOutTime($currentDate,$workHdrId);
							    
							    //    ==================   //
							    
							 //   $Workdata= $this->MTS->update_mts("employeeinoutmst",array("dOutTime"=>$currentDate, "dModifiedDate"=>$currentDate),array("nWorkhdrId"=>$workHdrId),$employeeId);
							    $this->status = Ws_Controller::HTTP_OK;
    							$data1 = array();
    							$data1["isWorkAdded"] = 1;
    							$this->responseData = $data1;
    							$this->message = "Work completed successfully!";
							}
                        }else{
                            $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->message = "Wrong Token Sent";
                        }
                    }else{
                        $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "No Token Send";
                    }
                    
                }else{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
                }
			}else{
				$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		
		function accrueMiles(){
		    $request = \Config\Services::request();
			if ($request->is('post')){
			    $validation = \Config\Services::validation();
                $validation->setRule('dLat', 'dLat', 'trim|required'); 
                $validation->setRule('dLng', 'dLng', 'trim|required');
                $validation->setRule('nTeamId', 'nTeamId', 'trim|required');
                $PostData = $request->getPost();
                if ($validation->run($PostData)){
                
                    // Request Data
                    
                    $workHdrId = $PostData['nWorkId'];
                    $teamId = $PostData['nTeamId'];
                    $employeeLatitude = $PostData['dLat'];
                    $employeeLongitude = $PostData['dLng'];
                    $distanceTravelled = $PostData['nDistPrevWork'];
                    $workHistoryId = $PostData['nWorkHistoryId'];
                    
                    
                    $vToken = $this->getAuthToken();
                    $currentDate = $this->MTS->getserverdate();
                    
                    if($vToken){
                        
                        if($this->MTS->authenticate($vToken)){
                            
                            // Getting Employee details
                            
                            $employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$employeeId = $employeeData['id'];
							$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
							
							// Getting Customer details
							
							$wordhdrData = $this->MTS->selectone('workhdr',array('id'=>$workHdrId));
							$customerData = $this->MTS->selectone('customermst',array('id'=>$wordhdrData['nCustId']));
							$customerId = $customerData['id'];
							$customerLatitude = $customerData['dLat'];
					        $customerLongitude = $customerData['dLng'];
					        
					        if($this->MTS->distance($employeeLatitude,$employeeLongitude, $customerLatitude, $customerLongitude,"ME") > 100){
							    
						        $message = "Tried to start work away from customer home";
								$sendNotification = $this->MTS->insert_mts('alertmst',array("nFranchiseeId"=>$employeeFranchiseeId,"nUserId"=>$employeeId,"nCustId"=>$customerId,"nWorkhdrId"=>$workHdrId,"vMessage"=> $message,"isActive"=>1,"isNotified"=>0,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate),$employeeId);
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
								
							}else{
							    
							    // Adding the distance in employeedistancemst table
							    
							    $date = date('Y-m-d',strtotime($currentDate));
							    $employeeDistance = $this->MTS->getEmployeeDistance($employeeId,$date);
							    
								if($employeeDistance){
								    $employeeTotalDistance = $employeeDistance['EmpTotalDistance'] + $distanceTravelled;
								}
								else{
								    $employeeTotalDistance = $distanceTravelled;
								}
								
								$employee_distance = $this->MTS->getUserDistance($employeeId);
								
								// Updating distance in employeedistancemst table
							    
							    $updatedistance = $this->MTS->insert_mts('employeedistancemst',array('nEmpId'=>$employeeId,'nTeamId'=>$teamId,'nWorkhdrId'=>$workHdrId,"dTotalDistance"=>$employee_distance,"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
							    
							    // Adding start time in employeeinoutmst table
							    
								$updateinout = $this->MTS->insert_mts('employeeinoutmst',array('nEmpId'=>$employeeId,"dInTime"=>$currentDate,'nWorkhdrId'=>$workHdrId,"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
							    
							    // Reseting trip distance in usermst table
							    
							    $updateuser = $this->MTS->update_mts('usermst',array('dTripDistance'=>0),array('id'=>$employeeId),$employeeId);
							    
							    // Updating my trip distance in workhistory table
							    
							    $workHistoryData = $this->MTS->selectone('workhistory',array('id'=>$workHistoryId));
							    $workHistoryDistance = $workHistoryData['nTotalDistance'] + $distanceTravelled;
							    $this->MTS->update_mts("workhistory",array("nTotalDistance"=>$workHistoryDistance,"isReachedOffice"=>0),array('id'=>$workHistoryId),$employeeId);
							    $this->status = Ws_Controller::HTTP_OK;
    							$data1 = array();
    							$data1["isWorkAdded"] = 1;
    							$this->responseData = $data1;
    							$this->message = "Miles accrued successfully!";
    							
							}
                            
                        }else{
                            $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
							$this->message = "Wrong Token Sent";
                        }
                        
                    }else{
                        $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "No Token Send";
                    }
                }else{
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = strip_tags($validation->listErrors());
                }
			}else{
			    $this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		function leaveTeam(){
		    $request = \Config\Services::request();
			if ($request->is('post')){
                $PostData = $request->getPost();
                $teamId = $PostData['teamId'];
                $workId = $PostData['workId'];
                $vToken = $this->getAuthToken();
                $currentDate = $this->MTS->getserverdate();
                if($vToken){
                    if($this->MTS->authenticate($vToken)){
                        // Getting Employee details
                        $employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$employeeId = $employeeData['id'];
						$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
					    $this->MTS->updateInWorkStatus([$employeeId], 0,$currentDate);
						$updateteamdtl = $this->MTS->update_mts('teamdtl',array('isActive'=>0),array('nTeamhdrId'=>$teamId,'nUserId'=>$employeeId,'nFranchiseeId'=>$employeeFranchiseeId),$employeeId);
				// 		$updateouttime = $this->MTS->update_mts('employeeinoutmst',array('dOutTime'=>$currentDate,'dModifiedDate'=>$currentDate),array('nWorkhdrId'=>$workId,'nEmpId'=>$employeeId,'dOutTime'=>NULL),$employeeId);
				        if($workId){
				            $updateouttime = $this->MTS->updatOutTime($currentDate,$workId,$employeeId);
				        }
                        $this->status = Ws_Controller::HTTP_OK;
    				// 	$data = array();
    				    // $data['workId'] = $workId;
    				    // $data['employeeId'] = $employeeId;
    				    // $data['currentDate'] = $currentDate;
    				    $data['sql'] = $updateouttime;
    					$this->responseData = $data;
    					$this->message = "You have successfully left the team!";
                    }else{
                        $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
                    }
                }
                else{
                   $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				   $this->message = "No Token Send"; 
                }
            
			}else{
			    $this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
				$this->message = lang('err_invalid_method');
			}
		}
		
		function updateTeam(){

	        $request = \Config\Services::request();
	        if ($request->is('post')){
		        $validation = \Config\Services::validation();
		        $validation->setRule('dLat', 'dLat', 'trim|required'); 
		        $validation->setRule('dLng', 'dLng', 'trim|required');
		        $validation->setRule('nTeamId', 'nTeamId', 'trim|required');
		        $PostData = $request->getPost();
	
		        if ($validation->run($PostData)){
		            
		            $workId = $PostData['nWorkId'];
		            $teamId = $PostData['nTeamId'];
		            $newTeamMembers = $PostData['vAddEmpId'] == "" ? [] : explode(",",$PostData['vAddEmpId']);
                    $deletedTeamMembers = $PostData['vDeleteEmpId'] == "" ? [] : explode(",",$PostData['vDeleteEmpId']);
		            
			        $vToken = $this->getAuthToken();
                    $currentDate = $this->MTS->getserverdate();
                    if($vToken){
				        if($this->MTS->authenticate($vToken)){
				            
				            // Getting Employee details
                            
                            $employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
							$employeeId = $employeeData['id'];
							$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
							
							if(count($newTeamMembers)  > 0){
							    $this->MTS->updateInWorkStatus($newTeamMembers, 1,$currentDate);
							    $this->MTS->updatePrevTeamStatus($newTeamMembers,$currentDate);
							    for($index = 0; $index < count($newTeamMembers); $index++){
							        // Getting the teamhdr table entry
							        $teamHdrData = $this->MTS->selectone('teamhdr',array('id'=>$teamId,'isActive'=>1));
							        // Checking whether the team member has already in team before(teamdtl table)
							        $tdetailData =$this->MTS->selectone('teamdtl',array('nUserId'=>$newTeamMembers[$index],'nTeamhdrId'=>$teamId));
							        if(empty($tdetailData)){
							            $update = $this->MTS->insert_mts('teamdtl',array('nFranchiseeId'=>$teamHdrData['nFranchiseeId'],'nTeamhdrId'=>$teamId,'nUserId'=>$newTeamMembers[$index],"isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
							        }else{
							            $update = $this->MTS->update_mts('teamdtl',array("isActive"=>1,"dModifiedDate"=>$currentDate),array('nTeamhdrId'=>$teamId,'nUserId'=>$newTeamMembers[$index]));
							        }
							    }
							    $getwork = $this->MTS->selectone('workhdr',array('id'=>$workId));
							
							    $teammates = array_merge(explode(",",$getwork['team_mates']),$newTeamMembers);
							    
							    $updatework = $this->MTS->update_mts('workhdr',array("team_mates"=> implode(",",$teammates),"dModifiedDate"=>$currentDate),array('id'=>$workId));
							}
							
							if(count($deletedTeamMembers) > 0){
							    // Modifying inWork table to make the employee inWork status inactive
							    $this->MTS->updateInWorkStatus($deletedTeamMembers, 0,$currentDate);
							    // New Changes
							    for($index = 0; $index < count($deletedTeamMembers); $index++){
							       $get_in_out = $this->MTS->get_in_out_mts($deletedTeamMembers[$index], $workId);
							       if(empty($get_in_out)){
							        
							        $get_teame_leader_inout = $this->MTS->get_team_leader_inout($workId);
							        
							        $update = $this->MTS->update_mts('teamdtl',array('isActive'=>0),array('nUserId'=>$deletedTeamMembers[$index],'nTeamhdrId'=>$teamId));
								    $insert = $this->MTS->insert_mts("empteammst",array("nUserId"=>$deletedTeamMembers[$index],"nTeamId"=>$teamId, "nType"=>2, "isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
							        $insert_inoutmst = $this->MTS->insert_mts("employeeinoutmst", array("nEmpId"=>$deletedTeamMembers[$index], "dInTime"=>$get_teame_leader_inout['dInTime'], "dOutTime"=>$currentDate, "nWorkhdrId"=>$workId, "dModifiedDate"=>$currentDate, "dCreatedDate"=>$currentDate));
							       
							           
							       }else{
	
							       $update = $this->MTS->update_mts('teamdtl',array('isActive'=>0),array('nUserId'=>$deletedTeamMembers[$index],'nTeamhdrId'=>$teamId));
								   $insert = $this->MTS->insert_mts("empteammst",array("nUserId"=>$deletedTeamMembers[$index],"nTeamId"=>$teamId, "nType"=>2, "isActive"=>1,"dModifiedDate"=>$currentDate,"dCreatedDate"=>$currentDate));
								   $updateouttime = $this->MTS->updatOutTime($currentDate,$workId,$deletedTeamMembers[$index]);
							       }
							    }
						    }
						    $this->status = Ws_Controller::HTTP_OK;
						    $this->responseData = array();
    					    $this->message = "Your team has been updated successfully!";
							
				            
				        }else{
                            $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					        $this->message = "Wrong Token Sent";
                        }
			        }else{
                        $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				        $this->message = "No Token Send";
                    }
		        }else{
			        $this->status = Ws_Controller::HTTP_BAD_REQUEST;
			        $this->message = strip_tags($validation->listErrors());
                }	
	        }else{
		        $this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
		        $this->message = lang('err_invalid_method');
	        }
        }
		
		
		function test(){
		  //  $get = $this->MTS->timeToTimestamp("04:12 PM");
		  //  print_r($get);
		  //  exit;
		    $currentDate = $this->MTS->determineLocation(37.5222843,-77.6255899);
		  //  $get = $this->MTS->team_details_complete_form("264,262,470","9323","16488");
			print_r($currentDate);
			
		    exit;
		}
		
		function del(){
		    $del = $this->MTS->del();
		    print_r($del);
		    exit;
		}
		
		function updateNotificationTime(){
		    
		    $request = \Config\Services::request();
		    if ($request->is('post')){
		        $PostData = $request->getPost();
		        $timestamp = $this->MTS->getserverdate();
		        $nWorkId = $PostData['nWorkId'];
		      //  $myFile = "james".date('Y_m_d', $_SERVER['REQUEST_TIME'])."_".".txt";
		      //  $fh = fopen($myFile, 'a');
        //         $stringData = json_encode($timestamp)."\n" ;
        //         fwrite($fh, $stringData);
        //         fclose($fh);
        //         exit;
		        $update = $this->MTS->update_mts('workhdr',array("tNotificationTime"=>$timestamp),array('id'=>$nWorkId));
		        if($update){
		             $this->status = Ws_Controller::HTTP_OK;
		              $this->responseData = $data1;
    				  $this->message = "Work details successfully added";
		        }else{
		              $this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					  $this->message = "Wrong Token Sent";
		        }
		    }else{
		        $this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
		        $this->message = lang('err_invalid_method');
	        }
		}
		
		
		
		
		
	}
