<?php

// Import PHPMailer classes into the global namespace
// These must be at the top of your script, not inside a function
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Load Composer's autoloader
require 'vendor/autoload.php';

include('db.php');

$date = new DateTime("now", new DateTimeZone('America/New_York') );
$date = $date->format('Y-m-d');
$sql ="

SELECT 
    work.id as work_id,work.nUserId , work.nCustId , work.nTeamId team_id ,work.tOutTime as outTime,work.tInTime as inTime, work.dCreatedDate work_date ,
    usermst.vName user_name, usermst.vEmail user_email,
    customermst.vName customer_name , customermst.vAddress customer_address,
    wh.isReachedOffice reached_office

FROM workhdr as work

LEFT JOIN usermst ON work.nUserId = usermst.id
LEFT JOIN customermst ON work.nCustId = customermst.id
LEFT JOIN workhistory as wh ON wh.nUserId = usermst.id

WHERE (work.tOutTime is NULL OR work.tOutTime='') AND DATE_FORMAT(work.dCreatedDate, '%Y-%m-%d')='$date'

GROUP BY usermst.id
ORDER BY wh.id DESC

";

// ( (work.tOutTime is NULL OR work.tOutTime='') OR wh.isReachedOffice = '0') AND
// (work.tOutTime is NULL OR work.tOutTime='') AND
//  LEFT JOIN wh ON wh.nUserId = usermst.id


$result = mysqli_query($con,$sql) or die(mysqli_error($con));

$rows="";
$sn=0;
while ($row = mysqli_fetch_assoc($result)) {

    $sn++;
    
    $user_name              = $row['user_name'];
    $user_email             = $row['user_email'];
    $customer_name          = $row['customer_name'];
    $work_date              = $row['work_date']; 
    $work_id                = $row['work_id'];
    // $plus_an_hour           = strtotime($row['inTime'])+60*60;
    // $plus_an_hour           = date('Y-m-d h:i:s',$plus_an_hour);
    $work_completed         = !empty($row['outTime'])? 'YES' : 'no';
    $reached_office         = $row['reached_office']=='0'?'YES':'no';
    
    $rows .= "
        <tr>
        
            <td>    $sn             </td>
            <td>    $user_name      </td>
            <td>    $user_email     </td>
            <td>    $customer_name  </td>
            <td>    $work_completed </td>
            <td>    $reached_office </td>
            <td>    $work_date      </td>
            
        </tr>
    ";
}

$EmailData="
<table border='1' cellpadding='2'>
    <caption>
        Hi Jonathan! <br>
        <br>
        Some of the employees just forget to Logout from customer home. Please check they are listed below.<br>
    </caption>
    <thead>

        <tr>
        
            <th>    S no.           </th>
            <th>    Employee Name   </th>
            <th>    Employee Email  </th>
            <th>    Customer Name   </th>
            <th>    Work Completed  </th>
            <th>    Reached Off.    </th>
            <th>    Work Date       </th>
            
        </tr>

    </thead>
    <tbody>
        
        $rows
    
    </tbody>
</table>
";

// echo $EmailData;

$mail = new PHPMailer(true);

try {
    //Server settings
    $mail->SMTPDebug  = SMTP::DEBUG_SERVER;
    $mail->isSMTP();
    $mail->Host       = 'a2plcpnl0933.prod.iad2.secureserver.net';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'info@gpsscheduler.com';
    $mail->Password   = 'I}#^9y4XGLWI';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    //Recipients
    $mail->setFrom('info@gpsscheduler.com', 'Maid To Sparklel Ceaning');
    $mail->addAddress('info@maidtosparklecleaning.com', 'Jonathan');     // Add a recipient
   // $mail->addReplyTo('noreply@maidtosparklecleaning.com', 'Email Reply');

    // Content
    $mail->isHTML(true);                                  // Set email format to HTML
    $mail->Subject = 'Employees Still Logged in the App';
    $mail->Body    = $EmailData;

    $mail->send();
    echo 'Message has been sent';
} catch (Exception $e) {
    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
}





exit('page exit');



