<?php
// Include db first
require_once 'db.php';
// Turn on error reporting
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
// Check login
//session_start();
if (!isset($_SESSION['SESS_MEMBER_ID'])) {
    header('Location: index.php');
    exit;
}

// Include necessary files
require_once 'gusto_api.php';
$config = require __DIR__ . '/gusto_config.php';

// Store flash messages
$success_message = $_SESSION['success'] ?? '';
$error_message = $_SESSION['error'] ?? '';
$warning_message = $_SESSION['warning'] ?? '';
unset($_SESSION['success'], $_SESSION['error'], $_SESSION['warning']);


if(isset($_GET["submit_employee"])) {
    $employee_id = $_GET["submit_employee"];
    $result = mysqli_query($con, "
            SELECT * FROM usermst 
            WHERE id = '$employee_id'
        ");
    $employee_data = mysqli_fetch_assoc($result);
    $vName = $employee_data["vName"];
    $vEmail = $employee_data["vEmail"];
    $state = $employee_data["state"];
    $ssn = $employee_data["ssn"];
    $dob = $employee_data["dob"];
    $street_address = $employee_data["street_address"];
    $city = $employee_data["city"];
    $zip = $employee_data["zip"];
    $vName_split = explode(" ", $vName);
    $first_name = $vName_split[0];
    $last_name = $vName_split[1];
    $payload = [
        "first_name" => $first_name,
        "last_name"  => $last_name,
        "email"      => $vEmail,
        "ssn"        => $ssn,
        "date_of_birth" => $dob,
        "home_address" => [
            "street_1" => $street_address,
            "street_2" => "",
            "city"     => $city,
            "state"    => $state,
            "zip"      => $zip,
            "country"  => "USA"
        ]
    ];
    $gusto_employee_request = get_or_create_gusto_employee($payload, $config);
    if($gusto_employee_request["gusto_employee_uuid"]) {
        $query =  "UPDATE `usermst` SET gusto_employee_uuid='$gusto_employee_uuid' 
        WHERE nFranchiseeId = ".$_SESSION['SESS_MEMBER_ID']." AND id = '$employee_id'"; 
        mysqli_query($con, $query);
       $success_message = "Employee $first_name was successfully import to Gusto.<br />The employee data is as follows:<br />".json_encode($payload);
    } else {
      $error_message = "Employee $first_name could not be imported to Gusto.<br />
            Got the following error from Gusto:<br />".$gusto_employee_request["errors"]."<br />
            The employee data is as follows:<br />".json_encode($payload)."
            <p>Correct the employee data from HR dashboard and then check again here:
              <br /><a href=\"https://mtstexting.com/sch-upgraded/edit-employee/$employee_id\" target=\"blank\"><b>https://mtstexting.com/sch-upgraded/edit-employee/$employee_id</b></a>
                </p>";
    }
}
if(isset($_GET["delete_report"])) {
   $sql = "DELETE FROM weekly_reports where id = '".$_GET["delete_report"]."'";
    mysqli_query($con,$sql);
    $_SESSION['success'] = "Report data was deleted successfully";
}
// Handle form submissions
//if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle payroll submission
    if ($_REQUEST['weekly_report_main_id']) {
        
        
        $weekly_report_main_id = $_REQUEST['weekly_report_main_id'];
        $reports_result = mysqli_query($con, "
            SELECT wr.*, u.vName as employee_name, u.gusto_employee_uuid, m.week_start,m.week_end
            FROM weekly_reports wr 
            JOIN usermst u ON u.id = wr.employee_id
            JOIN weekly_reports_main m ON wr.weekly_report_main_id = m.id
            WHERE u.is_active = 1 AND wr.gusto_submitted = 0 
            AND wr.weekly_report_main_id = '$weekly_report_main_id'
            AND u.gusto_employee_uuid
            ORDER BY wr.id DESC 
            LIMIT 50
        ");
        $reports_exists = mysqli_num_rows($reports_result);
        
        $reports_result_invalid = mysqli_query($con, "
            SELECT wr.*, u.vName as employee_name, u.gusto_employee_uuid, m.week_start,m.week_end
            FROM weekly_reports wr 
            JOIN usermst u ON u.id = wr.employee_id
            JOIN weekly_reports_main m ON wr.weekly_report_main_id = m.id
            WHERE u.is_active = 1 AND wr.gusto_submitted = 0 
            AND wr.weekly_report_main_id = '$weekly_report_main_id'
            AND (u.gusto_employee_uuid = '' || u.gusto_employee_uuid IS NULL)
            ORDER BY wr.id DESC 
            LIMIT 50
        ");
        $reports_exists_invalid = mysqli_num_rows($reports_result_invalid);
    }
//}
if(isset($_POST["process_report_id"])) {
    $process_report_id = $_POST["process_report_id"];
    $pay_date = $_POST["pay_date"];
    $sql = "UPDATE weekly_reports_main SET pay_date='$pay_date' WHERE id='$process_report_id'";
    mysqli_query($con, $sql);

    $result = submitToGustoEnhanced($con, $config, $process_report_id);
    if (strpos($result, 'success') !== false) {
        $_SESSION['success'] = $result;
    } else {
        $_SESSION['error'] = $result;
    }
    //header('Location: index2.php');
    header("Location: gusto_ready_to_submit.php");
    exit;
}
// Get total reports count
// $total_reports_result = mysqli_query($con, "SELECT COUNT(*) as total FROM weekly_reports");
// $total_reports_data = mysqli_fetch_assoc($total_reports_result);
// $total_reports = $total_reports_data['total'];

// Get weeks with unsubmitted reports
$weeks_result = mysqli_query($con, "
    SELECT * FROM weekly_reports_main WHERE submitted_to_gutso = 0");
$total_pending = mysqli_num_rows($weeks_result);

// Get recent reports
?>

<?php include('includes/head.php'); ?>
<!--
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="mb-1">Enhanced Weekly Reports</h3>
        <p class="text-muted mb-0">Add reports with complete pay calculations</p>
    </div>
    <div>
        <a href="gusto_employees.php" class="btn btn-outline-primary">
            <i class="fa fa-users"></i> Employee Management
        </a>
    </div>
</div>
-->
<link href="css/gutso.css" rel='stylesheet' type='text/css' />
<div class="content-container">
    <h1>Pending Payrolls</h1>
    <?php if($success_message): ?>
        <div class="alert alert-success alert-dismissible show">
            <?= $success_message ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <?php if($error_message): ?>
        <div class="alert alert-danger alert-dismissible show">
            <?= $error_message ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <!-- Reports Table -->
    <div class="card">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Pending Reports (<?= $total_pending ?> total)</h5>
            <?php if (mysqli_num_rows($weeks_result) > 0): ?>
            <div>
                <form method="post" class="form-inline" action="gusto_ready_to_submit.php">
                    <select name="weekly_report_main_id" class="form-control mr-2">
                        <option value="">Select week to submit...</option>
                        <?php while ($week = mysqli_fetch_assoc($weeks_result)): ?>
                            <option value="<?= $week['id'] ?>" <?php if($week['id'] == $weekly_report_main_id) { ?> selected <?php } ?>>
                                <?= $week['week_start']."-".$week['week_end'] ?> (Unsubmitted)
                            </option>
                        <?php endwhile; ?>
                    </select>
                    <button type="submit" name="submit_week" class="btn btn-primary">
                        <i class="fa fa-paper-plane"></i> View Report
                    </button>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="card-body">
            <?php if ($reports_exists > 0) { ?>
                <div class="table-responsive">
                    <div class="pull-right">
                    <form method="POST" action="gusto_ready_to_submit.php" class="form-inline" onSubmit="return confirm('Are you sure, you want to submit to Gusto?')">
                        <label>Pay Date:</label><input type="date" class="form-control" name="pay_date" required/>
                        <input type="hidden" name="process_report_id" value="<?= $weekly_report_main_id ?>">
                        <button class="btn btn-success" type="submit">Submit Report to Gutso</button></form></div>
                        <h1>Valid Reports</h1>
                    <table class="table table-sm table-striped" id="reportsTable">
                        <thead>
                            <tr>
                                <th>Week</th>
                                <th>Employee</th>
                                <th>Hours</th>
                                <th>Solo</th>
                                <th>Miles</th>
                                <th>Misc</th>
                                <th>Regular Pay</th>
                                <th>Solo Bonus</th>
                                <th>Mileage</th>
                                <th>Misc Pay</th>
                                <th>Gross Pay</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($r = mysqli_fetch_assoc($reports_result)): 
                                // echo "<pre>";
                                // print_r($r);
                                // echo "</pre>";
                                $row_class = $r['gusto_submitted'] ? 'table-success' : '';
                                if(!$r['gusto_employee_uuid']) {
                                    $row_class .= " has-error";
                                }
                            ?>
                                <tr class="<?= trim($row_class) ?>">
                                    <td><?= $r['week_start']." - ".$r['week_end'] ?></td>
                                    <td>
                                        <?= $r['employee_name'] ?>
                                        <small class="d-block text-muted">ID: <?= $r['employee_id']." ".$r['gusto_employee_uuid'] ?></small>
                                    </td>
                                    <td><?= number_format($r['hours_total'], 2)." (".$r["hourly_rate"].")" ?></td>
                                    <td><?= number_format($r['solo_hours'], 2)." (".$r["solo_bonus_rate"].")" ?></td>
                                    <td><?= number_format($r['miles'], 2)." (".$r["mileage_rate"].")" ?></td>
                                    <td><?= number_format($r['miscellaneous'], 2) ?></td>
                                    <td>$<?= number_format($r['regular_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['solo_bonus_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['mileage_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['miscellaneous_pay'], 2) ?></td>
                                    <td>
                                        <strong>$<?= number_format($r['gross_pay'], 2) ?></strong>
                                    </td>
                                    <td><?php if(!$r['gusto_employee_uuid']) { ?>
                                            <a href="?submit_employee=<?= $r['employee_id'] ?>&weekly_report_main_id=<?= $r["weekly_report_main_id"]?>">Submit Employee</i></a>
                                        <?php } ?>
                                        <a href="gutso_edit_report.php?id=<?= $r['id'] ?>"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                                        <a href="?delete_report=<?= $r['id'] ?>&weekly_report_main_id=<?= $r["weekly_report_main_id"]?>" onclick="return confirm('Are you sure you want to delete?')"><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                <br><hr><br />
                 <?php if ($reports_exists_invalid > 0) { ?>
                <div class="table-responsive">
                        <h1>Invalid Reports(Missing Employees)</h1>
                        <p>These records will be ignored automatically. If you want to import these reports to gusto, plz click on "Submit Employee" option.</p>
                    <table class="table table-sm table-striped" id="reportsTable">
                        <thead>
                            <tr>
                                <th>Week</th>
                                <th>Employee</th>
                                <th>Hours</th>
                                <th>Solo</th>
                                <th>Miles</th>
                                <th>Misc</th>
                                <th>Regular Pay</th>
                                <th>Solo Bonus</th>
                                <th>Mileage</th>
                                <th>Misc Pay</th>
                                <th>Gross Pay</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($r = mysqli_fetch_assoc($reports_result_invalid)): 
                                // echo "<pre>";
                                // print_r($r);
                                // echo "</pre>";
                                $row_class = $r['gusto_submitted'] ? 'table-success' : '';
                                if(!$r['gusto_employee_uuid']) {
                                    $row_class .= " has-error";
                                }
                            ?>
                                <tr class="<?= trim($row_class) ?>">
                                    <td><?= $r['week_start']." - ".$r['week_end'] ?></td>
                                    <td>
                                        <?= $r['employee_name'] ?>
                                        <small class="d-block text-muted">ID: <?= $r['employee_id']." ".$r['gusto_employee_uuid'] ?></small>
                                    </td>
                                    <td><?= number_format($r['hours_total'], 2)." (".$r["hourly_rate"].")" ?></td>
                                    <td><?= number_format($r['solo_hours'], 2)." (".$r["solo_bonus_rate"].")" ?></td>
                                    <td><?= number_format($r['miles'], 2)." (".$r["mileage_rate"].")" ?></td>
                                    <td><?= number_format($r['miscellaneous'], 2) ?></td>
                                    <td>$<?= number_format($r['regular_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['solo_bonus_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['mileage_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['miscellaneous_pay'], 2) ?></td>
                                    <td>
                                        <strong>$<?= number_format($r['gross_pay'], 2) ?></strong>
                                    </td>
                                    <td><?php if(!$r['gusto_employee_uuid']) { ?>
                                            <a href="?submit_employee=<?= $r['employee_id'] ?>&weekly_report_main_id=<?= $r["weekly_report_main_id"]?>">Submit Employee</i></a>
                                        <?php } ?>
                                        <a href="gutso_edit_report.php?id=<?= $r['id'] ?>"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                                        <a href="?delete_report=<?= $r['id'] ?>&weekly_report_main_id=<?= $r["weekly_report_main_id"]?>" onclick="return confirm('Are you sure you want to delete?')"><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                
            <?php } 
                } else { ?>
                <div class="alert alert-info text-center">
                    <h5>No Reports Selected</h5>
                    <p class="mb-0">Select a pending report from the dropdown to view the list.</p>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php include('footer.php'); ?>
<script>
// Employee data cache
let employeeRates = {
    hourly: 16.00,
    solo: 3.00,
    miles: 0.25,
    misc: 1.00,
    name: ''
};

// Initialize
$(document).ready(function() {
    // Set up employee selection
    $('.set-employee').click(function(e) {
        e.preventDefault();
        const employeeId = $(this).data('id');
        const employeeName = $(this).data('name');
        const hourlyRate = $(this).data('hourly');
        const soloRate = $(this).data('solo');
        const milesRate = $(this).data('miles');
        const miscRate = $(this).data('misc');
        
        $('#employee_id').val(employeeId);
        $('#employeeInfo').html(`<i class="fa fa-user"></i> ${employeeName} | $${hourlyRate}/hr`);
        
        // Set employee rates
        employeeRates = {
            hourly: parseFloat(hourlyRate),
            solo: parseFloat(soloRate),
            miles: parseFloat(milesRate),
            misc: parseFloat(miscRate),
            name: employeeName
        };
        
        // Update rates display
        updateRatesDisplay();
        calculatePreview();
    });
    
    // Calculate preview when inputs change
    $('#hours_total, #solo_hours, #miles, #miscellaneous').on('input', calculatePreview);
    
    // Initialize preview
    calculatePreview();
});

function loadEmployeeRates() {
    const employeeId = $('#employee_id').val();
    if (!employeeId) {
        alert('Please enter an Employee ID first');
        return;
    }
    
    $.ajax({
        url: 'get_employee_rates.php',
        type: 'GET',
        data: { employee_id: employeeId },
        success: function(response) {
            if (response.success) {
                employeeRates = response.rates;
                employeeRates.name = response.name;
                $('#employeeInfo').html(`
                    <i class="fa fa-check text-success"></i> 
                    ${response.name} | 
                    Hourly: $${response.rates.hourly} | 
                    Solo: $${response.rates.solo} | 
                    Miles: $${response.rates.miles} | 
                    Misc: $${response.rates.misc}
                `);
                
                updateRatesDisplay();
                calculatePreview();
            } else {
                alert('Employee not found or error loading rates');
                $('#employeeInfo').html('<span class="text-danger">Employee not found</span>');
            }
        },
        error: function() {
            alert('Error loading employee rates');
        }
    });
}

function updateRatesDisplay() {
    $('#hourlyRate').text('$' + employeeRates.hourly.toFixed(2) + '/hr');
    $('#soloRate').text('$' + employeeRates.solo.toFixed(2) + '/hr');
    $('#milesRate').text('$' + employeeRates.miles.toFixed(2) + '/mile');
    $('#miscRate').text('$' + employeeRates.misc.toFixed(2) + '/unit');
}

function calculatePreview() {
    // Get standard values
    const hours = parseFloat($('#hours_total').val()) || 0;
    const solo = parseFloat($('#solo_hours').val()) || 0;
    const miles = parseFloat($('#miles').val()) || 0;
    const misc = parseFloat($('#miscellaneous').val()) || 0;
    
    // Calculate standard pay
    const regularPay = hours * employeeRates.hourly;
    const soloPay = solo * employeeRates.solo;
    const mileagePay = miles * employeeRates.miles;
    const miscPay = misc * employeeRates.misc;
    
    // Calculate final total
    const totalGross = regularPay + soloPay + mileagePay + miscPay;
    
    // Update display
    $('#regularPay').html(`$${regularPay.toFixed(2)}`);
    $('#soloPay').html(`$${soloPay.toFixed(2)}`);
    $('#mileagePay').html(`$${mileagePay.toFixed(2)}`);
    $('#miscPay').html(`$${miscPay.toFixed(2)}`);
    $('#totalGrossPay').html(`$${totalGross.toFixed(2)}`);
}
</script>
	<script src="js/jquery.nicescroll.js"></script>        
	<script src="js/scripts.js"></script>        <!-- Bootstrap Core JavaScript -->       
	<script src="js/bootstrap.min.js"></script>	