<?php
include 'db.php';

$message = '';
$token_data = null;

// Fetch current token data for display
$query = "SELECT * FROM gusto_tokens LIMIT 1";
$result = mysqli_query($con, $query);
if ($result && mysqli_num_rows($result) > 0) {
    $token_data = mysqli_fetch_assoc($result);
} else {
    $message = "No token data found in the database. Please check if the gusto_tokens table has records.";
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = mysqli_real_escape_string($con, $_POST['id']);
    $access_token = mysqli_real_escape_string($con, $_POST['access_token']);
    $refresh_token = mysqli_real_escape_string($con, $_POST['refresh_token']);
    $expires_at = mysqli_real_escape_string($con, $_POST['expires_at']);
    $created_at = mysqli_real_escape_string($con, $_POST['created_at']);
    
    // Build the SQL query
    $sql = "UPDATE gusto_tokens SET 
            access_token = '$access_token', 
            refresh_token = '$refresh_token', 
            expires_at = '$expires_at', 
            created_at = '$created_at' 
            WHERE id = '$id'";
    
    // Execute the query
    if (mysqli_query($con, $sql)) {
        if (mysqli_affected_rows($con) > 0) {
            $message = "Token updated successfully!";
            
            // Refresh the token data after update
            $query = "SELECT * FROM gusto_tokens WHERE id = '$id'";
            $result = mysqli_query($con, $query);
            if ($result && mysqli_num_rows($result) > 0) {
                $token_data = mysqli_fetch_assoc($result);
            }
        } else {
            $message = "No changes made. The data might be the same as before.";
        }
    } else {
        $message = "Error updating token: " . mysqli_error($con);
    }
}

// Function to format datetime for input field
function formatDateTimeForInput($datetime) {
    if (empty($datetime)) return '';
    return date('Y-m-d\TH:i', strtotime($datetime));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Gusto Tokens</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            background-color: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .message {
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 4px;
            font-weight: bold;
        }
        .success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .info {
            background-color: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #333;
        }
        input[type="text"],
        input[type="datetime-local"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }
        input[type="text"]:focus,
        input[type="datetime-local"]:focus {
            outline: none;
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0,123,255,0.3);
        }
        button {
            background-color: #007bff;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
        }
        button:hover {
            background-color: #0056b3;
        }
        .token-display {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 4px;
            margin-bottom: 30px;
            border-left: 4px solid #007bff;
        }
        .token-display h3 {
            margin-top: 0;
            color: #333;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .token-info {
            margin-bottom: 8px;
        }
        .token-info strong {
            display: inline-block;
            width: 120px;
        }
        .readonly-field {
            background-color: #f8f9fa;
            cursor: not-allowed;
        }
        small {
            color: #666;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 style="color: #333; border-bottom: 2px solid #007bff; padding-bottom: 10px;">Update Gusto Tokens</h1>
        
        <?php if ($message): ?>
            <div class="message <?php 
                if (strpos($message, 'successfully') !== false) echo 'success';
                elseif (strpos($message, 'Error') !== false) echo 'error';
                else echo 'info';
            ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <?php if ($token_data): ?>
            <div class="token-display">
                <h3>Current Token Data</h3>
                <div class="token-info">
                    <strong>ID:</strong> <?php echo htmlspecialchars($token_data['id']); ?>
                </div>
                <div class="token-info">
                    <strong>Access Token:</strong> 
                    <span title="<?php echo htmlspecialchars($token_data['access_token']); ?>">
                        <?php echo htmlspecialchars(substr($token_data['access_token'], 0, 50)); ?>...
                    </span>
                </div>
                <div class="token-info">
                    <strong>Refresh Token:</strong> 
                    <span title="<?php echo htmlspecialchars($token_data['refresh_token']); ?>">
                        <?php echo htmlspecialchars(substr($token_data['refresh_token'], 0, 50)); ?>...
                    </span>
                </div>
                <div class="token-info">
                    <strong>Expires At:</strong> <?php echo htmlspecialchars($token_data['expires_at']); ?>
                </div>
                <div class="token-info">
                    <strong>Created At:</strong> <?php echo htmlspecialchars($token_data['created_at']); ?>
                </div>
            </div>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="id">ID:</label>
                    <input type="text" id="id" name="id" 
                           value="<?php echo htmlspecialchars($token_data['id'] ?? ''); ?>" 
                           required readonly
                           class="readonly-field">
                    <small>ID is read-only (primary key)</small>
                </div>

                <div class="form-group">
                    <label for="access_token">Access Token:</label>
                    <input type="text" id="access_token" name="access_token" 
                           value="<?php echo htmlspecialchars($token_data['access_token'] ?? ''); ?>" 
                           required
                           placeholder="Enter access token">
                </div>

                <div class="form-group">
                    <label for="refresh_token">Refresh Token:</label>
                    <input type="text" id="refresh_token" name="refresh_token" 
                           value="<?php echo htmlspecialchars($token_data['refresh_token'] ?? ''); ?>" 
                           required
                           placeholder="Enter refresh token">
                </div>

                <div class="form-group">
                    <label for="expires_at">Expires At:</label>
                    <input type="datetime-local" id="expires_at" name="expires_at" 
                           value="<?php echo formatDateTimeForInput($token_data['expires_at'] ?? ''); ?>" 
                           required>
                    <small>Format: YYYY-MM-DD HH:MM:SS</small>
                </div>

                <div class="form-group">
                    <label for="created_at">Created At:</label>
                    <input type="datetime-local" id="created_at" name="created_at" 
                           value="<?php echo formatDateTimeForInput($token_data['created_at'] ?? ''); ?>" 
                           required>
                    <small>Format: YYYY-MM-DD HH:MM:SS</small>
                </div>

                <button type="submit">Update Tokens</button>
            </form>

        <?php else: ?>
            <div class="message error">
                <strong>No token data found!</strong><br>
                Please check if:
                <ul>
                    <li>The gusto_tokens table exists in the database</li>
                    <li>The table has records</li>
                    <li>You have proper database permissions</li>
                </ul>
            </div>
            
            <!-- Show form for manual entry if no data exists -->
            <div class="token-display">
                <h3>Manual Entry (No existing data found)</h3>
                <form method="POST" action="">
                    <div class="form-group">
                        <label for="id">ID:</label>
                        <input type="text" id="id" name="id" required placeholder="Enter ID">
                    </div>

                    <div class="form-group">
                        <label for="access_token">Access Token:</label>
                        <input type="text" id="access_token" name="access_token" required placeholder="Enter access token">
                    </div>

                    <div class="form-group">
                        <label for="refresh_token">Refresh Token:</label>
                        <input type="text" id="refresh_token" name="refresh_token" required placeholder="Enter refresh token">
                    </div>

                    <div class="form-group">
                        <label for="expires_at">Expires At:</label>
                        <input type="datetime-local" id="expires_at" name="expires_at" required>
                    </div>

                    <div class="form-group">
                        <label for="created_at">Created At:</label>
                        <input type="datetime-local" id="created_at" name="created_at" required>
                    </div>

                    <button type="submit">Create/Update Tokens</button>
                    
                </form>
            </div>
        <?php endif; ?>
        
         <a href="https://gpsscheduler.com/app/admin/gusto_employees.php" class="btn btn-secondary">
                ← Back to Dashboard
            </a>
    </div>
   

    <script>
        // JavaScript to help with datetime formatting
        document.addEventListener('DOMContentLoaded', function() {
            // Format datetime inputs on page load
            function formatDateTimeInput(inputId) {
                const input = document.getElementById(inputId);
                if (input && input.value) {
                    // Convert to datetime-local format (YYYY-MM-DDTHH:MM)
                    const date = new Date(input.value);
                    if (!isNaN(date.getTime())) {
                        input.value = date.toISOString().slice(0, 16);
                    }
                }
            }
            
            // Format both datetime fields
            formatDateTimeInput('expires_at');
            formatDateTimeInput('created_at');
            
            // Add input validation
            const form = document.querySelector('form');
            if (form) {
                form.addEventListener('submit', function(e) {
                    const id = document.getElementById('id');
                    const accessToken = document.getElementById('access_token');
                    const refreshToken = document.getElementById('refresh_token');
                    
                    if (!id.value.trim()) {
                        alert('Please enter an ID');
                        id.focus();
                        e.preventDefault();
                        return;
                    }
                    
                    if (!accessToken.value.trim()) {
                        alert('Please enter an access token');
                        accessToken.focus();
                        e.preventDefault();
                        return;
                    }
                    
                    if (!refreshToken.value.trim()) {
                        alert('Please enter a refresh token');
                        refreshToken.focus();
                        e.preventDefault();
                        return;
                    }
                });
            }
        });
    </script>
</body>
</html>