<?php
// Include db first
require_once 'db.php';
// Turn on error reporting
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
// Check login
//session_start();
if (!isset($_SESSION['SESS_MEMBER_ID'])) {
    header('Location: index.php');
    exit;
}

// Include necessary files
require_once 'gusto_api.php';
$config = require __DIR__ . '/gusto_config.php';

// Store flash messages
$success_message = $_SESSION['success'] ?? '';
$error_message = $_SESSION['error'] ?? '';
$warning_message = $_SESSION['warning'] ?? '';
unset($_SESSION['success'], $_SESSION['error'], $_SESSION['warning']);


if(isset($_POST["update_record"])) {
    //if (strpos($result, 'success') !== false) {
        $_SESSION['success'] = "Record updated successfully";
   // } else {
    //    $_SESSION['error'] = $result;
   // }
    //header('Location: index2.php');
    header("Location: gutso_edit_report.php");
    exit;
}

// Handle form submissions
//if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle payroll submission
    if ($_REQUEST['id']) {
        
        
        $report_id = $_REQUEST['id'];
        $reports_result = mysqli_query($con, "
            SELECT wr.*, u.vName as employee_name, u.gusto_employee_uuid, m.week_start,m.week_end
            FROM weekly_reports wr 
            JOIN usermst u ON u.id = wr.employee_id
            JOIN weekly_reports_main m ON wr.weekly_report_main_id = m.id
            WHERE u.is_active = 1 AND wr.gusto_submitted = 0 
            AND wr.id = '$report_id'
            ORDER BY wr.id DESC 
            LIMIT 50
        ");
        $reports_exists = mysqli_num_rows($reports_result);
    }

?>

<?php include('includes/head.php'); ?>
<!--
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="mb-1">Enhanced Weekly Reports</h3>
        <p class="text-muted mb-0">Add reports with complete pay calculations</p>
    </div>
    <div>
        <a href="gusto_employees.php" class="btn btn-outline-primary">
            <i class="fa fa-users"></i> Employee Management
        </a>
    </div>
</div>
-->
<link href="css/gutso.css" rel='stylesheet' type='text/css' />
<div class="content-container">
    <h1>Update Report</h1>
    <?php if($success_message): ?>
        <div class="alert alert-success alert-dismissible show">
            <?= $success_message ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <?php if($error_message): ?>
        <div class="alert alert-danger alert-dismissible show">
            <?= $error_message ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <!-- Reports Table -->
    <div class="card">
        <div class="card-body">
            <?php if ($reports_exists > 0): ?>
                <div class="table-responsive">
                    <form action="gutso_edit_report.php" method="POST">
                        <?php $r = mysqli_fetch_assoc($reports_result); ?>
                        <input type="hidden" class="form-control" id="id" name="id" readonly disabled value="<?= $report_id ?>">
                    <div class="mb-3 mt-3">
                      <label for="week">Week:</label>
                      <input type="text" class="form-control" id="week" name="week" readonly disabled value="<?= $r['week_start']." - ".$r['week_end'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Employee:</label>
                      <input type="text" class="form-control" id="emp" name="employee" readonly disabled value="<?= $r['employee_name']." (".$r['employee_id'].") (".$r['gusto_employee_uuid'] ?>)">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Hours:</label>
                      <input type="text" class="form-control" id="emp" name="hours" readonly disabled value="<?= $r['hours_total'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Solo Hours:</label>
                      <input type="text" class="form-control" id="emp" name="solo_hours" readonly disabled value="<?= $r['solo_hours'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Miles:</label>
                      <input type="text" class="form-control" id="emp" name="miles" readonly disabled value="<?= $r['miles'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Miscellaneous:</label>
                      <input type="text" class="form-control" id="emp" name="miscellaneous" readonly disabled value="<?= $r['miscellaneous'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Regular Pay:</label>
                      <input type="text" class="form-control" id="emp" name="Regular Pay" readonly disabled value="<?= $r['regular_pay'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Solo bonus Pay:</label>
                      <input type="text" class="form-control" id="emp" name="solo_bonus_pay" readonly disabled value="<?= $r['solo_bonus_pay'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Mileage Pay:</label>
                      <input type="text" class="form-control" id="emp" name="mileage_pay" readonly disabled value="<?= $r['mileage_pay'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Hours:</label>
                      <input type="text" class="form-control" id="emp" name="Miscellaneous Pay" readonly disabled value="<?= $r['miscellaneous_pay'] ?>">
                    </div>
                    <div class="mb-3">
                      <label for="emp">Gross Pay:</label>
                      <input type="text" class="form-control" id="emp" name="gross_pay" readonly disabled value="<?= $r['gross_pay'] ?>">
                    </div>
                    <button type="submit" class="btn btn-primary" name="update_record">Submit</button>
                  </form>

                </div>
            <?php else: ?>
                <div class="alert alert-info text-center">
                    <h5>Something went wrong</h5>
                    <p class="mb-0">Report does not exist.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php include('footer.php'); ?>
<script>
/*
// Employee data cache
let employeeRates = {
    hourly: 16.00,
    solo: 3.00,
    miles: 0.25,
    misc: 1.00,
    name: ''
};

// Initialize
$(document).ready(function() {
    // Set up employee selection
    $('.set-employee').click(function(e) {
        e.preventDefault();
        const employeeId = $(this).data('id');
        const employeeName = $(this).data('name');
        const hourlyRate = $(this).data('hourly');
        const soloRate = $(this).data('solo');
        const milesRate = $(this).data('miles');
        const miscRate = $(this).data('misc');
        
        $('#employee_id').val(employeeId);
        $('#employeeInfo').html(`<i class="fa fa-user"></i> ${employeeName} | $${hourlyRate}/hr`);
        
        // Set employee rates
        employeeRates = {
            hourly: parseFloat(hourlyRate),
            solo: parseFloat(soloRate),
            miles: parseFloat(milesRate),
            misc: parseFloat(miscRate),
            name: employeeName
        };
        
        // Update rates display
        updateRatesDisplay();
        calculatePreview();
    });
    
    // Calculate preview when inputs change
    $('#hours_total, #solo_hours, #miles, #miscellaneous').on('input', calculatePreview);
    
    // Initialize preview
    calculatePreview();
});

function loadEmployeeRates() {
    const employeeId = $('#employee_id').val();
    if (!employeeId) {
        alert('Please enter an Employee ID first');
        return;
    }
    
    $.ajax({
        url: 'get_employee_rates.php',
        type: 'GET',
        data: { employee_id: employeeId },
        success: function(response) {
            if (response.success) {
                employeeRates = response.rates;
                employeeRates.name = response.name;
                $('#employeeInfo').html(`
                    <i class="fa fa-check text-success"></i> 
                    ${response.name} | 
                    Hourly: $${response.rates.hourly} | 
                    Solo: $${response.rates.solo} | 
                    Miles: $${response.rates.miles} | 
                    Misc: $${response.rates.misc}
                `);
                
                updateRatesDisplay();
                calculatePreview();
            } else {
                alert('Employee not found or error loading rates');
                $('#employeeInfo').html('<span class="text-danger">Employee not found</span>');
            }
        },
        error: function() {
            alert('Error loading employee rates');
        }
    });
}

function updateRatesDisplay() {
    $('#hourlyRate').text('$' + employeeRates.hourly.toFixed(2) + '/hr');
    $('#soloRate').text('$' + employeeRates.solo.toFixed(2) + '/hr');
    $('#milesRate').text('$' + employeeRates.miles.toFixed(2) + '/mile');
    $('#miscRate').text('$' + employeeRates.misc.toFixed(2) + '/unit');
}

function calculatePreview() {
    // Get standard values
    const hours = parseFloat($('#hours_total').val()) || 0;
    const solo = parseFloat($('#solo_hours').val()) || 0;
    const miles = parseFloat($('#miles').val()) || 0;
    const misc = parseFloat($('#miscellaneous').val()) || 0;
    
    // Calculate standard pay
    const regularPay = hours * employeeRates.hourly;
    const soloPay = solo * employeeRates.solo;
    const mileagePay = miles * employeeRates.miles;
    const miscPay = misc * employeeRates.misc;
    
    // Calculate final total
    const totalGross = regularPay + soloPay + mileagePay + miscPay;
    
    // Update display
    $('#regularPay').html(`$${regularPay.toFixed(2)}`);
    $('#soloPay').html(`$${soloPay.toFixed(2)}`);
    $('#mileagePay').html(`$${mileagePay.toFixed(2)}`);
    $('#miscPay').html(`$${miscPay.toFixed(2)}`);
    $('#totalGrossPay').html(`$${totalGross.toFixed(2)}`);
}
*/
</script>
	<script src="js/jquery.nicescroll.js"></script>        
	<script src="js/scripts.js"></script>        <!-- Bootstrap Core JavaScript -->       
	<script src="js/bootstrap.min.js"></script>	