<?php
session_start();
if (!isset($_SESSION['SESS_MEMBER_ID'])) { 
    header('Location: index.php'); 
    exit; 
}
require_once 'db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'update_field_order') {
        $order = json_decode($_POST['order'], true);
        
        if (is_array($order)) {
            mysqli_begin_transaction($con);
            
            try {
                foreach ($order as $item) {
                    $id = intval($item['id']);
                    $position = intval($item['position']);
                    
                    $stmt = mysqli_prepare($con, "UPDATE custom_payroll_fields SET display_order = ? WHERE id = ?");
                    mysqli_stmt_bind_param($stmt, "ii", $position, $id);
                    mysqli_stmt_execute($stmt);
                    mysqli_stmt_close($stmt);
                }
                
                mysqli_commit($con);
                echo json_encode(['success' => true, 'message' => 'Field order updated']);
            } catch (Exception $e) {
                mysqli_rollback($con);
                echo json_encode(['success' => false, 'error' => $e->getMessage()]);
            }
        } else {
            echo json_encode(['success' => false, 'error' => 'Invalid order data']);
        }
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid action']);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
}