<?php
session_start();
require_once 'db.php';

$id = 0;

if (isset($_REQUEST['id'])) {
    $id = intval($_REQUEST['id']);
}

// Optimized query using JOIN (much better performance)
$sql = "
SELECT 
    workdtl.*,
    usermst.vName AS username,
    servicemst.vName AS servicename
FROM workdtl
LEFT JOIN usermst ON usermst.id = workdtl.nUserId
LEFT JOIN servicemst ON servicemst.id = workdtl.nSId
WHERE workdtl.nWorkId = '$id'
";

$result = mysqli_query($con, $sql);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Work Details</title>

    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
</head>

<body>

<table id="example1" class="display responsive nowrap" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th>Sr. No.</th>
            <th>Worker Name</th>
            <th>Work Done</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $srCnt = 1;

        if ($result && mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
        ?>
                <tr>
                    <td><?php echo $srCnt++; ?></td>
                    <td><?php echo htmlspecialchars($row['username']); ?></td>
                    <td><?php echo htmlspecialchars($row['servicename']); ?></td>
                </tr>
        <?php
            }
        }
        ?>
    </tbody>
</table>

<script>
$(document).ready(function() {
    $('#example1').DataTable();
});
</script>

</body>
</html>
