<?php

/*
 | --------------------------------------------------------------------
 | App Namespace
 | --------------------------------------------------------------------
 |
 | This defines the default Namespace that is used throughout
 | CodeIgniter to refer to the Application directory. Change
 | this constant to change the namespace that all application
 | classes should use.
 |
 | NOTE: changing this will require manually modifying the
 | existing namespaces of App\* namespaced-classes.
 */
defined('APP_NAMESPACE') || define('APP_NAMESPACE', 'App');

/*
 | --------------------------------------------------------------------------
 | Composer Path
 | --------------------------------------------------------------------------
 |
 | The path that Composer's autoload file is expected to live. By default,
 | the vendor folder is in the Root directory, but you can customize that here.
 */
defined('COMPOSER_PATH') || define('COMPOSER_PATH', ROOTPATH . 'vendor/autoload.php');

/*
 |--------------------------------------------------------------------------
 | Timing Constants
 |--------------------------------------------------------------------------
 |
 | Provide simple ways to work with the myriad of PHP functions that
 | require information to be in seconds.
 */
defined('SECOND') || define('SECOND', 1);
defined('MINUTE') || define('MINUTE', 60);
defined('HOUR')   || define('HOUR', 3600);
defined('DAY')    || define('DAY', 86400);
defined('WEEK')   || define('WEEK', 604800);
defined('MONTH')  || define('MONTH', 2_592_000);
defined('YEAR')   || define('YEAR', 31_536_000);
defined('DECADE') || define('DECADE', 315_360_000);

/*
 | --------------------------------------------------------------------------
 | Exit Status Codes
 | --------------------------------------------------------------------------
 |
 | Used to indicate the conditions under which the script is exit()ing.
 | While there is no universal standard for error codes, there are some
 | broad conventions.  Three such conventions are mentioned below, for
 | those who wish to make use of them.  The CodeIgniter defaults were
 | chosen for the least overlap with these conventions, while still
 | leaving room for others to be defined in future versions and user
 | applications.
 |
 | The three main conventions used for determining exit status codes
 | are as follows:
 |
 |    Standard C/C++ Library (stdlibc):
 |       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
 |       (This link also contains other GNU-specific conventions)
 |    BSD sysexits.h:
 |       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
 |    Bash scripting:
 |       http://tldp.org/LDP/abs/html/exitcodes.html
 |
 */
defined('EXIT_SUCCESS')        || define('EXIT_SUCCESS', 0);        // no errors
defined('EXIT_ERROR')          || define('EXIT_ERROR', 1);          // generic error
defined('EXIT_CONFIG')         || define('EXIT_CONFIG', 3);         // configuration error
defined('EXIT_UNKNOWN_FILE')   || define('EXIT_UNKNOWN_FILE', 4);   // file not found
defined('EXIT_UNKNOWN_CLASS')  || define('EXIT_UNKNOWN_CLASS', 5);  // unknown class
defined('EXIT_UNKNOWN_METHOD') || define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     || define('EXIT_USER_INPUT', 7);     // invalid user input
defined('EXIT_DATABASE')       || define('EXIT_DATABASE', 8);       // database error
defined('EXIT__AUTO_MIN')      || define('EXIT__AUTO_MIN', 9);      // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      || define('EXIT__AUTO_MAX', 125);    // highest automatically-assigned error code

/**
 * @deprecated Use \CodeIgniter\Events\Events::PRIORITY_LOW instead.
 */
define('EVENT_PRIORITY_LOW', 200);

/**
 * @deprecated Use \CodeIgniter\Events\Events::PRIORITY_NORMAL instead.
 */
define('EVENT_PRIORITY_NORMAL', 100);

/**
 * @deprecated Use \CodeIgniter\Events\Events::PRIORITY_HIGH instead.
 */
define('EVENT_PRIORITY_HIGH', 10);

/********************** From old code**************************/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0755);

/*
  |--------------------------------------------------------------------------
  | File Stream Modes
  |--------------------------------------------------------------------------
  |
  | These modes are used when working with fopen()/popen()
  |
 */

define('FOPEN_READ', 'rb');
define('FOPEN_READ_WRITE', 'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE', 'ab');
define('FOPEN_READ_WRITE_CREATE', 'a+b');
define('FOPEN_WRITE_CREATE_STRICT', 'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
  |--------------------------------------------------------------------------
  | Display Debug backtrace
  |--------------------------------------------------------------------------
  |
  | If set to TRUE, a backtrace will be displayed along with php errors. If
  | error_reporting is disabled, the backtrace will not display, regardless
  | of this setting
  |
 */
define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
  |--------------------------------------------------------------------------
  | Exit Status Codes
  |--------------------------------------------------------------------------
  |
  | Used to indicate the conditions under which the script is exit()ing.
  | While there is no universal standard for error codes, there are some
  | broad conventions.  Three such conventions are mentioned below, for
  | those who wish to make use of them.  The CodeIgniter defaults were
  | chosen for the least overlap with these conventions, while still
  | leaving room for others to be defined in future versions and user
  | applications.
  |
  | The three main conventions used for determining exit status codes
  | are as follows:
  |
  |    Standard C/C++ Library (stdlibc):
  |       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
  |       (This link also contains other GNU-specific conventions)
  |    BSD sysexits.h:
  |       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
  |    Bash scripting:
  |       http://tldp.org/LDP/abs/html/exitcodes.html
  |
 */
// define('EXIT_SUCCESS', 0); // no errors
// define('EXIT_ERROR', 1); // generic error
// define('EXIT_CONFIG', 3); // configuration error
// define('EXIT_UNKNOWN_FILE', 4); // file not found
// define('EXIT_UNKNOWN_CLASS', 5); // unknown class
// define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
// define('EXIT_USER_INPUT', 7); // invalid user input
// define('EXIT_DATABASE', 8); // database error
// define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
// define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code

define('_PATH', substr(dirname(__FILE__), 0, -19));
define('_URL', substr($_SERVER['PHP_SELF'], 0, -(strlen($_SERVER['SCRIPT_FILENAME']) - strlen(_PATH))));

define('SITE_PATH', _PATH . "/");
define('SITE_URL', _URL . "/");

define('DOMAIN_URL', 'http://' . $_SERVER['HTTP_HOST'] . SITE_DIR);
define('FRONT_URL', DOMAIN_URL . '/front/');
define('ADMIN_URL', DOMAIN_URL . 'admin/');

define('ASSETS_PATH', SITE_PATH . "assets/");
define('ASSETS_URL', DOMAIN_URL . "/assets/");

define('ADMIN_CSS_URL', ASSETS_URL . "admin/css/");
define('ADMIN_PLUGIN_URL', ASSETS_URL . "admin/plugins/");
define('ADMIN_JS_URL', ASSETS_URL . "admin/js/");
define('ADMIN_IMAGE_URL', ASSETS_URL . "admin/img/");

define("FRONT_ASSETS", ASSETS_URL . "front/");
define("FRONT_ASSETS_PATH", ASSETS_PATH . "front/");
define('FRONT_IMAGE_URL', FRONT_ASSETS . "images/");
define('FRONT_IMAGE_PATH', FRONT_ASSETS_PATH . "images/");
define("FRONT_CSS_URL", FRONT_ASSETS . "css/");
define("FRONT_JS_URL", FRONT_ASSETS . "js/");
define("FRONT_PLUGIN_URL", FRONT_ASSETS . "plugins/");

/*
 *  TABLE CONSTANTS
 *  */
define('MST_SETTING', "mst_site_settings");
define('TBL_ADMIN', "tbl_admin");
define("TBL_USER", "tbl_users");
define("TBL_USER_ALLERGY", "tbl_user_allergy");
define("TBL_EMERGENCY_CATEGORY", "tbl_emergency_category");
define("TBL_USER_DEVICE", "tbl_user_devices");
define("TBL_ALLERGY", "tbl_allergy");
define("TBL_MEDICAL_CONDITION", "tbl_medical_condition");
define("TBL_MEDICAL_MEASUREMENT", "tbl_medical_measurement");
define('MST_EMAIL_TEMPLATE', "mst_emailtemplate");
define('TBL_EMAIL_TEMPLATE', "tbl_email_template");
define("TBL_NOTIFICATION", "tbl_notification");
define("TBL_COMMAND_SERVICE", "tbl_command_services");
define("MST_ADMIN_SECTION", "mst_adminsection");
define("MST_ADMIN_ROLE", "mst_adminrole");
define("MST_PERMISSIONS", "mst_permissions");
define("MST_USERTYPE", "mst_usertype");
define("MST_USER_PERMISSIONS", "mst_user_permission");
define("TBL_ADMIN_PERMISSION", "tbl_admin_permissions");
define("TBL_COMMAND_CENTER_AREA", "tbl_command_center_areas");
define('TBL_USER_CONDITION', 'tbl_user_condition');
define('TBL_USER_MEASUREMENT', 'tbl_user_medical_measurement');
define('TBL_USER_PROPERTY', 'tbl_user_property');
define('TBL_USER_INSURANCE', 'tbl_user_insurance');
define('TBL_INSURANCE_TYPE', 'tbl_insurance_type');
define('TBL_CITIZEN_PATROL', 'tbl_user_citizen_patrol');
define('TBL_USER_EMERGENCY_SUBSCRIBE', 'tbl_user_emergecny_subscribe');
define('TBL_CASE', 'tbl_case');
define('TBL_CASE_MEDIA', 'tbl_case_media');
define('TBL_CASE_DESCRIPTION', 'tbl_case_description');
define('TBL_CASE_REGISTER', 'tbl_case_registered_log');
define('TBL_SR_AREA_SERVE', 'tbl_service_responder_area_serve');
define('TBL_CASE_STATUS', 'tbl_case_status_log');
define('TBL_CASE_COMMENT', 'tbl_case_comment');
define('TBL_CASE_RATE_REVIEW', 'tbl_case_rating_review');
define("TBL_CURRENT_LOCATION", "tbl_service_responder_current_location");

define("FLAG_SUCCESS", "success");
define("FLAG_ERROR", "error");
define("FLAG_PENDING", "Pending");
define("FLAG_ACCEPT", "Accepted");
define("FLAG_CANCEL", "Cancelled");
define("FLAG_REJECT", "Rejected");
define("FLAG_RESOLVE", "Resolved");
define("FLAG_RATED", "Rated");
define('DEFAULT_RADIUS_IN_KM', '10');


define('LIMIT', '12');

define('UPLOAD_PATH', SITE_PATH . "upload/");
define('UPLOAD_URL', DOMAIN_URL . "/upload/");




define('UPLOAD_IMAGE_PATH', "upload/images/profile/");

define("CUSTOMER_NOREPLY_EMAIL_NAME", "MaidToSparkle");
define("CUSTOMER_NOREPLY_EMAIL", "noreply@maidtosparkle.com");
define("EMAIL_HOST", "sg2plcpnl0236.prod.sin2.secureserver.net");
define("EMAIL_PORT", '465');
define("EMAIL_USERNAME", "arti@codexalters.com");
define("EMAIL_PASSWORD", "arti@123");

define("DEMO_EMAIL", "kktogadia@gmail.com");

define('PROFILE_PIC_PATH', UPLOAD_PATH . "images/profile/");
define('PROFILE_PIC_URL', UPLOAD_URL . "images/profile/");

define("VOICE_CLIP_PATH", UPLOAD_PATH . "case_voice_clip/");
define("VOICE_CLIP_URL", UPLOAD_URL . "case_voice_clip/");
define("EMAIL_TEMPL_URL", UPLOAD_URL . "email-template/");

define('CERTIFICATE_FILE_SANDBOX', SITE_PATH . '');
define('CERTIFICATE_FILE', SITE_PATH . '');


define("USER_TYPE_SUBADMIN", "sub_admin"); //System Admin
define("USER_TYPE_COMMAND_CENTER", "command_center"); //System Admin
define("USER_TYPE_SERVICE_RESPONDER", "service_responder"); //Site User
define("USER_TYPE_USER", "user");
define("USER_TYPE_CITIZEN", "citizen_patrol");
define("CT_USERNAME_KEY", "ct0%autoID%%fcharoftype%%lcharoftype%");


define("SERIAL_NUMBER", "Serial Number");
define("PREFIX_SERVICE_RESPONDER", "SR - ");
define("PREFIX_USER", "LS");
define("NEARBY_RADIUS_METER", "200");

define("API_SECURITY_KEY", "LiFe$@veR");
define("ENC_PRIVATE_KEY", "L!Fe$@veR#7102");
define("CID", "2");
define("SITE_NAME", "LifeSaver");
define("OTP_EXPIRE_MIN", "60");

/* AWS Keys */
define("SNS_KEY_SANDBOX", "AKIAIIZO7BNOMMBN7R4Q");
define("SNS_KEY_PRODUCTION", "AKIAIPB5CDSNH7X3VR6A");
define("SNS_SECRET_SANDBOX", "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");
define("SNS_SECRET_PRODUCTION", "ySUdyPXypu58BY/RwebRia79eQVTP5ubZCwW1UZp");

/* Google Map Keys */
define("GMAP_KEY", "AIzaSyC4wkiYMjTf9k2HYgBSeU4SzS7UHD9Ft2c");
define("FCM_KEY", "AIzaSyAyla_AorNCAykl5wFgwLD1WouapNHA5Xo");
define("ANDROID_APP_LINK", "https://www.dropbox.com/s/l21ztztoqbl2ij5/LifeSaverCitizenPatrol-13%20Apr%2C17.apk?dl=0");
define("IOS_APP_LINK", "");

if (defined('ENVIRONMENT'))
{
    switch (ENVIRONMENT)
    {
        case 'development':
            define("EMAIL_CONFIG", serialize(array(
                'protocol' => 'smtp',
                'smtp_host' => 'ssl://smtp.googlemail.com',
                'smtp_port' => '465',
                'smtp_user' => 'femina@yudiz.com',
                'smtp_pass' => 'Ican@112',
                'charset' => 'utf-8',
                'wordwrap' => TRUE,
                'mailtype' => 'html',
                            )
                    )
            );
            break;

        case 'production':
            define("EMAIL_CONFIG", serialize(array(
                'protocol' => 'sendmail',
                'charset' => 'utf-8',
                'wordwrap' => TRUE,
                'mailtype' => 'html'
                            )
                    )
            );
            break;
    }
}

define("IMAGE_ACCEPT", serialize(array(IMAGETYPE_JPEG, IMAGETYPE_JPC, IMAGETYPE_JP2, IMAGETYPE_JPX, IMAGETYPE_JB2)));
define("ADMIN_USER_TYPE", serialize(array('Super', 'Admin')));

require_once APPPATH . 'Config/site_settings.php';
define("NEAR_DIST_UNIT", "miles");
