<?php

namespace App\Controllers\Ws;

use App\Libraries\Ws_Controller;
use App\Models\Maidtosparkle_model;

class Maidtosparkle extends Ws_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->MTS = new Maidtosparkle_model();
	}

	function login()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('vEmail', 'vEmail', 'trim|required');
			$validation->setRule('vPassword', 'vPassword', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$vEmail = $PostData['vEmail'];
				$vPassword = $PostData['vPassword'];
				// SANDBOX PATCH: Accept device_id on login for multi-device conflict prevention
				$deviceId = isset($PostData['device_id']) ? $PostData['device_id'] : null;
				$CheckData = $this->MTS->CheckUser($vEmail, $vPassword);
				if (!empty($CheckData)) {
					$authToken = $this->MTS->hashSSHAuthToken($CheckData["vPassword"]);
					$responseData = $this->MTS->addtoken($authToken, $CheckData["id"]);
					$data = $this->MTS->getUserDetail(array('id' => $CheckData["id"]));
					// SANDBOX PATCH: Register active device on login
					if (!empty($deviceId)) {
						$this->MTS->setActiveDeviceId($CheckData["id"], $deviceId);
					}
					$data1['id'] = $data['id'] == "" ? "" : $data['id'];
					$data1['vName'] = $data['vName'] == "" ? "" : $data['vName'];
					$data1['vEmail'] = $data['vEmail'] == "" ? "" : $data['vEmail'];
					$data1['vImagePath'] = $data['vImagePath'] == "" ? "" : BASE_PATH . "upload/images/dprofile.png";
					$data1['nHContactNo'] = $data['nHContactNo'] == "" ? "" : $data['nHContactNo'];
					$data1['nWContactNo'] = $data['nWContactNo'] == "" ? "" : $data['nWContactNo'];
					$data1['nCContactNo'] = $data['nCContactNo'] == "" ? "" : $data['nCContactNo'];
					$data1['dAmount'] = $data['dAmount'] == "" ? "" : $data['dAmount'];
					$data1['vToken'] = $data['vToken'] == "" ? "" : $data['vToken'];
					$data1['isActive'] = $data['isActive'] == "" ? "" : $data['isActive'];
					$data1['dModifiedDate'] = $data['dModifiedDate'] == "" ? "" : $data['dModifiedDate'];
					$data1['dCreatedDate'] = $data['dCreatedDate'] == "" ? "" : $data['dCreatedDate'];
					$this->status = Ws_Controller::HTTP_OK;
					$this->responseData = $data1;
					$this->message = "Logged in successfully.";
				} else {
					$this->status = Ws_Controller::HTTP_NOT_FOUND;
					$this->message = "Registration not found, Please Sign-up!";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function logout()
	{
		$request = \Config\Services::request();
		if ($request->is('get')) {
			$param = $this->getRequest();
			$vToken = $this->getAuthToken();
			$data = $this->MTS->getUserDetail(array("vToken" => $vToken));
			if (empty($vToken)) {
				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				$this->message = "No Token Send";
			} else {
				if (isset($data['vToken']) && $data['vToken'] == $vToken) {
					$responseData = $this->MTS->removetoken($vToken);
					$edit = $this->MTS->clearLatLng($data['id']);
					$this->status = Ws_Controller::HTTP_OK;
					$this->message = lang('succ_logout');
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "Send Wrong Token";
				}
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function changePassword()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('vOldPassword', 'vOldPassword', 'trim|required');
			$validation->setRule('vNewPassword', 'vNewPassword', 'trim|required');
			$vToken = $this->getAuthToken();
			if (empty($vToken)) {
				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				$this->message = "No Token Send";
			} else {
				if ($this->MTS->authenticate($vToken)) {
					$PostData = $request->getPost();
					if ($validation->run($PostData)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken, "isActive" => 1));
						if (!empty($getData)) {
							if (!empty($vToken)) {
								if ($PostData["vOldPassword"] != $getData["vPassword"]) {
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									$this->message = "Wrong Old Password";
									exit;
								}
								if ($getData["vPassword"] == $PostData["vNewPassword"]) {
									$this->status = Ws_Controller::HTTP_BAD_REQUEST;
									$this->message = "old password and new password same";
									exit;
								}
							}
							$edit = $this->MTS->Update_mts('usermst', array('vPassword' => $PostData["vNewPassword"]), array('id' => $getData["id"]));
							if ($edit) {
								$this->status = Ws_Controller::HTTP_OK;
								$this->message = lang('scc_pass_changed');
							} else {
								$this->status = Ws_Controller::HTTP_INTERNAL_SERVER_ERROR;
								$this->message = lang('err_failed_password');
							}
						} else {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->message = "Result Not Found";
						}
					} else {
						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
						$this->message = "Required Data are  missing";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "Wrong Token Sent";
				}
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function forgotPassword()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('vEmail', 'Email', 'trim|required|valid_email');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$whereArray["vEmail"] = $PostData["vEmail"];
				$db = \Config\Database::connect();
				$checkUserExsist = $db->table('usermst')->select('*')
					->where($whereArray)->where("isActive", 1)->get()->getRowArray();
				if (!empty($checkUserExsist)) {
					$pswd = $this->MTS->random_numbers();
					$responseData = $this->MTS->Update_mts('usermst', array("vPassword" => $pswd), array("id" => $checkUserExsist['id']));
					$mailBodyArr = array(
						"[NAME]" => $checkUserExsist['vName'],
						"[PASSWORD]" => $pswd
					);
					if ($this->MTS->sendMailForgotpswd($checkUserExsist['vEmail'], $mailBodyArr)) {
						$this->message = "Mail sent with new password.";
					} else {
						$this->message = "Unable to send mail, Please try again.";
					}
					$this->status = Ws_Controller::HTTP_OK;
				} else {
					$this->status = Ws_Controller::HTTP_NOT_FOUND;
					$this->message = "No account associated with provided email.";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function getUserlist()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('offset', 'offset', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$vOffset = $PostData['offset'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nFranchiseeId =  $getData['nFranchiseeId'];
						$data = $this->MTS->selectuser('usermst', array("!id" => $uid, "nFranchiseeId" => $nFranchiseeId));
						$totalrow = "" . count($data) . "";
						$datalimit = LIMIT;
						$data = $this->MTS->selectuser('usermst', array("!id" => $uid, "nFranchiseeId" => $nFranchiseeId), $vOffset, LIMIT);
						$continue = ($vOffset + LIMIT) < $totalrow ? "True" : "False";
						$limit = array('TotalRecord' => $totalrow, 'limit' => $datalimit, 'continue' => $continue);
						if (empty($data)) {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();
							$this->message = "No Result Found!";
						} else {
							$array3 = array();
							$arrayDemo = array();
							for ($i = 0; $i < count($data); $i++) {
								$data1[$i]['id'] = $data[$i]['id'] == "" ? "" : $data[$i]['id'];
								$data1[$i]['vName'] = $data[$i]['vName'] == "" ? "" : $data[$i]['vName'];
								$data1[$i]['vImagePath'] = BASE_PATH . "upload/images/dprofile.png";
								$array3 = $data1;
							}
							$data2['limit'] = $limit;
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							$this->extraData = $data2;
							$this->message = "User List";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = "Enter offset value";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function getServicelist()
	{
		$request = \Config\Services::request();
		if ($request->is('get')) {
			$vToken = $this->getAuthToken();
			if (empty($vToken)) {
				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				$this->message = "No Token Send";
			} else {
				if ($this->MTS->authenticate($vToken)) {
					$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
					$uid = $getData['id'];
					$nFranchiseeId =  $getData['nFranchiseeId'];
					$data = $this->MTS->select_mts('servicemst', array('isActive' => 1, "nFranchiseeId" => $nFranchiseeId));
					if (empty($data)) {
						$this->status = Ws_Controller::HTTP_NOT_FOUND;
						$this->responseData = array();
						$this->message = "No Result Found!";
					} else {
						$array3 = array();
						$arrayDemo = array();
						for ($i = 0; $i < count($data); $i++) {
							$data1[$i]['id'] = $data[$i]['id'] == "" ? "" : $data[$i]['id'];
							$data1[$i]['vName'] = $data[$i]['vName'] == "" ? "" : $data[$i]['vName'];
							$array3 = $data1;
						}
						$this->status = Ws_Controller::HTTP_OK;
						$this->responseData = $array3;
						$this->message = "Service List";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->responseData = array();
					$this->message = "Wrong Token Sent";
				}
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function searchUserlist()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('offset', 'offset', 'trim|required');
			$validation->setRule('vSearchQuery', 'vSearchQuery', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$vOffset = $PostData['offset'];
				$searchQuery = $PostData['vSearchQuery'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nFranchiseeId =  $getData['nFranchiseeId'];
						$data = $this->MTS->select_mts('usermst', array('!id' => $uid, 'isActive' => 1, "nFranchiseeId" => $nFranchiseeId), 0, 0, 'DESC', 'vName', $searchQuery);
						$totalrow = "" . count($data) . "";
						$datalimit = LIMIT;
						$data = $this->MTS->select_mts('usermst', array('!id' => $uid, 'isActive' => 1, "nFranchiseeId" => $nFranchiseeId), $vOffset, LIMIT, 'DESC', 'vName', $searchQuery);
						$continue = ($vOffset + LIMIT) < $totalrow ? "True" : "False";
						$limit = array('TotalRecord' => $totalrow, 'limit' => $datalimit, 'continue' => $continue);
						if (empty($data)) {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();
							$this->message = "No Result Found!";
						} else {
							$array3 = array();
							$arrayDemo = array();
							for ($i = 0; $i < count($data); $i++) {
								$data1[$i]['id'] = $data[$i]['id'] == "" ? "" : $data[$i]['id'];
								$data1[$i]['vName'] = $data[$i]['vName'] == "" ? "" : $data[$i]['vName'];
								$data1[$i]['vImagePath'] = BASE_PATH . "upload/images/dprofile.png";
								$array3 = $data1;
							}
							$data2['limit'] = $limit;
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							$this->extraData = $data2;
							$this->message = "Search User List";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function addWorkNew()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('dLat', 'dLat', 'trim|required');
			$validation->setRule('dLng', 'dLng', 'trim|required');
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$isDifferentDay = 0;
				$dWorkDateToCompare = $PostData['dWorkDate'];
				$nCustId = $PostData['nCustId'];
				$nWorkId = $PostData['nWorkId'];
				$dAmount = $PostData['dAmount'];
				$nTeamId = $PostData['nTeamId'];
				$isUpdateTeamForOngoingWork = $PostData['isUpdateTeamForOngoingWork'];
				$nWorkHistoryId = $PostData['nWorkHistoryId'];
				$tEndTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
				$dDate = date('Y-m-d', $_SERVER['REQUEST_TIME']);
				$tInTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
				$tInTime = empty($tInTime) ? NULL : $tInTime;
				$tOutTime = $PostData['tOutTime'];
				$tOutTime = empty($tOutTime) ? NULL : $tOutTime;
				$dWorkDate = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
				$vPaymentMethod = $PostData['vPaymentMethod'];
				$aWorkList = $PostData['aWorkList'];
				$vChequeNo = $PostData['vChequeNo'];
				$vChequeNo = empty($vChequeNo) ? NULL : $vChequeNo;
				$dLat = $PostData['dLat'];
				$dLng = $PostData['dLng'];
				$nDistPrevWork = empty($PostData['nDistPrevWork']) ? 0 : $PostData['nDistPrevWork'];
				$dCurrentDate = $this->MTS->getserverdate();
				$vToken = $this->getAuthToken();
				if (!empty($vToken)) {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nUserId = $uid;
						$nFranchiseeId =  $getData['nFranchiseeId'];
						if (empty($nCustId)) {
							$workdata = $this->MTS->selectone('workhdr', array('id' => $nWorkId));
							$nCustId = $workdata['nCustId'];
						} else {
							$nCustId = $PostData['nCustId'];
						}
						$vDeleteEmpId = $PostData['vDeleteEmpId'];
						$vAddEmpId = $PostData['vAddEmpId'];
						$custdata = $this->MTS->selectone('customermst', array('id' => $nCustId));
						$custName = $custdata['vName'];
						$wdLat = $custdata['dLat'];
						$wdLng = $custdata['dLng'];
						if (date('Y-m-d', $_SERVER['REQUEST_TIME']) != date('Y-m-d', strtotime($dWorkDateToCompare . " UTC"))) {
							$isDifferentDay = 1;
						}
						if ($this->MTS->distance($dLat, $dLng, $wdLat, $wdLng, "ME") > 100 && $isDifferentDay == 0 && ($vAddEmpId == "" && $vDeleteEmpId == "")) {
							$message = "Tried to " . (empty($nWorkId) ? "start" : "stop") . " work away from customer home";
							if (!empty($nWorkId)) {
								$responseData = $this->MTS->insert_mts('alertmst', array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nCustId" => $nCustId, "nWorkhdrId" => $nWorkId, "vMessage" => $message, "isActive" => 1, "isNotified" => 0, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
							} else {
								$responseData = $this->MTS->insert_mts('alertmst', array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nCustId" => $nCustId, "vMessage" => $message, "isActive" => 1, "isNotified" => 0, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
							}
							if ($responseData) {
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
							} else {
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
							}
						} else {
							if ($nWorkId && $isUpdateTeamForOngoingWork != 1) {
								if (($tOutTime == NULL) || ($tOutTime == "")) {
									$tOutTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
								} else {
									$tOutTime = $tOutTime;
								}
								if ($isDifferentDay == 0) {
									$Workdata = $this->MTS->update_mts("workhdr", array("nUserId" => $uid, "dAmount" => $dAmount, "vPaymentMethod" => $vPaymentMethod, "vChequeNo" => $vChequeNo, "nStatus" => 1, "tOutTime" => $tOutTime, "dLat" => $dLat, "dLng" => $dLng, "dModifiedDate" => $dCurrentDate), array("id" => $nWorkId), $nUserId);
								} else {
									$Workdata = $this->MTS->update_mts("workhdr", array("nUserId" => $uid, "dAmount" => $dAmount, "vPaymentMethod" => $vPaymentMethod, "vChequeNo" => $vChequeNo, "nStatus" => 1, "dLat" => $dLat, "dLng" => $dLng, "dModifiedDate" => $dCurrentDate), array("id" => $nWorkId), $nUserId);
								}
								for ($i = 0; $i < count($aWorkList); $i++) {

									$Workdtlid = $this->MTS->insert_mts("workdtl", array("nFranchiseeId" => $nFranchiseeId, "nWorkId" => $nWorkId, "nSId" => (explode(",", $aWorkList[$i])[0]), "nUserId" => (explode(",", $aWorkList[$i])[1]), "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
								}
							} else {
								$vDeleteEmpId = $PostData['vDeleteEmpId'];
								$vAddEmpId = $PostData['vAddEmpId'];
								if ($vDeleteEmpId) {
									$DeletedId = explode(",", $vDeleteEmpId);
									for ($j = 0; $j < count($DeletedId); $j++) {
										$update = $this->MTS->update_mts('teamdtl', array('isActive' => 2), array('nUserId' => $DeletedId[$j], 'nTeamhdrId' => $nTeamId));

										$this->MTS->insert_mts("empteammst", array("nUserId" => $DeletedId[$j], "nTeamId" => $nTeamId, "nType" => 2, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
									}
								}
								if ($vAddEmpId) {
									$AddEmpId = explode(",", $vAddEmpId);
									for ($j = 0; $j < count($AddEmpId); $j++) {
										$Teamdata = $this->MTS->selectone('teamhdr', array('id' => $nTeamId, 'isActive' => 1));
										$update = $this->MTS->insert_mts('teamdtl', array('nFranchiseeId' => $Teamdata['nFranchiseeId'], 'nTeamhdrId' => $nTeamId, 'nUserId' => $AddEmpId[$j], "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
										$userdistance  = $this->MTS->sumdistancedata($AddEmpId[$j], $dDate);
										$nUserTotalDistance = $userdistance['TotalDistance'];
										$this->MTS->insert_mts("empteammst", array("nUserId" => $AddEmpId[$j], "nTeamId" => $nTeamId, "dTotalDistance" => $nUserTotalDistance, "nType" => 1, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
									}
								}
								if ($isUpdateTeamForOngoingWork != 1) {
									$nWorkId = $this->MTS->insert_mts("workhdr", array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nCustId" => $nCustId, "nTeamId" => $nTeamId, "dWorkDate" => $dWorkDate, "tInTime" => $tInTime, "dLat" => $dLat, "dLng" => $dLng, "nDistPrevWork" => $nDistPrevWork, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
									// FIX: Do NOT reset dTripDistance between works — Android overwrites it immediately.
									// Delta computation in startWork/accrueMiles handles per-work distance correctly.
								}
								if (!empty($nWorkHistoryId)) {
									$distance  = $this->MTS->sumdistancedata($uid, $dDate);
									$nTotalDistance = $distance['TotalDistance'];
									$WorkHistoryId = $this->MTS->update_mts("workhistory", array("tEndTime" => $tEndTime, "nTotalDistance" => $nTotalDistance, "isReachedOffice" => 0), array('id' => $nWorkHistoryId), $nUserId);
								}
							}
							if ($nWorkId) {
								if ($isDifferentDay == 0) {
									$this->status = Ws_Controller::HTTP_OK;
									$data1 = array();
									$data1["isWorkAdded"] = 1;
									$this->responseData = $data1;
									$this->message = "Work details successfully added";
								} else {
									$this->status = Ws_Controller::HTTP_OK;
									$data1 = array();
									$data1["isWorkAdded"] = 0;
									$this->responseData = $data1;
									$this->message = "Can not add details for previous day work.";
								}
							} else {
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->message = "Fail";
							}
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function getCustomerlist()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('offset', 'offset', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$vOffset = $PostData['offset'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nFranchiseeId =  $getData['nFranchiseeId'];
						$data = $this->MTS->select_mts('customermst', array('isActive' => 1, "nFranchiseeId" => $nFranchiseeId));
						$totalrow = "" . count($data) . "";
						$datalimit = LIMIT;
						$data = $this->MTS->select_mts('customermst', array('isActive' => 1, "nFranchiseeId" => $nFranchiseeId), $vOffset, LIMIT);
						$continue = ($vOffset + LIMIT) < $totalrow ? "True" : "False";
						$limit = array('TotalRecord' => $totalrow, 'limit' => $datalimit, 'continue' => $continue);
						if (empty($data)) {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();
							$this->message = "No Result Found!";
						} else {
							$array3 = array();
							$arrayDemo = array();
							for ($i = 0; $i < count($data); $i++) {
								$data1[$i]['id'] = $data[$i]['id'] == "" ? "" : $data[$i]['id'];
								$data1[$i]['vName'] = $data[$i]['vName'] == "" ? "" : $data[$i]['vName'];
								$data1[$i]['vImagePath'] = $data[$i]['vImagePath'] == "" ? BASE_PATH . "upload/images/dprofile.png" : BASE_PATH . $data[$i]['vImagePath'];
								$data1[$i]['dLat'] = $data[$i]['dLat'] == "" ? "" : $data[$i]['dLat'];
								$data1[$i]['dLng'] = $data[$i]['dLng'] == "" ? "" : $data[$i]['dLng'];
								$array3 = $data1;
							}
							$data2['limit'] = $limit;
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							$this->extraData = $data2;
							$this->message = "Customer List";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = "Enter offset value";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function getWorklist()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('offset', 'offset', 'trim|required');
			$validation->setRule('timestamp', 'timestamp', 'trim|required');
			$PostData = $request->getPost();
			$teamId = $PostData['nTeamId'];
			if ($validation->run($PostData)) {
				$vOffset = $PostData['offset'];
				$timestamp = $PostData['timestamp'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nFranchiseeId =  $getData['nFranchiseeId'];
						$dCurrentDate = date("Y-m-d", $timestamp);
						//franklin getting workhdr table based on teamID instead of uid
						$data = $this->MTS->getWorklistNew($uid, $dCurrentDate, $nFranchiseeId);
						$totalrow = "" . count($data) . "";
						$datalimit = LIMIT;
						$data = $this->MTS->getWorklistNew($uid, $dCurrentDate, $nFranchiseeId, $vOffset, LIMIT);
						$continue = ($vOffset + LIMIT) < $totalrow ? "True" : "False";
						$limit = array('TotalRecord' => $totalrow, 'limit' => $datalimit, 'continue' => $continue);
						if (empty($data)) {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();
							$this->message = "No Result Found!";
						} else {
							$array3 = array();
							$arrayDemo = array();
							for ($i = 0; $i < count($data); $i++) {
								$data1[$i]['workId'] = $data[$i]['workId'] == "" ? "" : $data[$i]['workId'];
								$data1[$i]['nTeamId'] = $data[$i]['nTeamId'] == "" ? "" : $data[$i]['nTeamId'];
								$data1[$i]['CustomerName'] = $data[$i]['CustomerName'] == "" ? "" : $data[$i]['CustomerName'];
								$data1[$i]['vImagePath'] = $data[$i]['vImagePath'] == "" ? BASE_PATH . "upload/images/dprofile.png" : BASE_PATH . $data[$i]['vImagePath'];
								$data1[$i]['dAmount'] = $data[$i]['dAmount'] == "" ? "" : $data[$i]['dAmount'];
								$data1[$i]['dWorkDate'] = $data[$i]['dWorkDate'] == "" ? "" : $data[$i]['dWorkDate'];
								$data1[$i]['InTime'] = $data[$i]['InTime'] == "" ? "" : $data[$i]['InTime'];
								$data1[$i]['OutTime'] = $data[$i]['OutTime'] == "" ? "" : $data[$i]['OutTime'];
								$data1[$i]['nStatus'] = $data[$i]['nStatus'] == "" ? "" : $data[$i]['nStatus'];
								$data1[$i]['CustomerId'] = $data[$i]['CustomerId'] == "" ? "" : $data[$i]['CustomerId'];
								$data1[$i]['team_mates'] = $data[$i]['team_mates'] == "" ? "" : $data[$i]['team_mates'];
								$isLeader = $this->MTS->teamLeader($uid, $data1[$i]['nTeamId'], $dCurrentDate, $nFranchiseeId);
								if ($isLeader) {
									$data1[$i]['nStatus'] = $data[$i]['nStatus'] == "" ? "" : $data[$i]['nStatus'];
								} else {
									$data1[$i]['nStatus'] = $this->MTS->workStatus($uid, $data[$i]['workId'], $dCurrentDate);
								}
								$array3 = $data1;
							}
							$data2['limit'] = $limit;
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							$this->extraData = $data2;
							$this->message = "WorkList";
						}
					} else {

						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = "Enter offset value";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function UpdateInOutTime()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('nWorkId', 'nWorkId', 'trim|required');
			$validation->setRule('nTimeType', 'nTimeType', 'trim|required');
			$validation->setRule('dTime', 'dTime', 'trim|required');
			$validation->setRule('dLat', 'dLat', 'trim|required');
			$validation->setRule('dLng', 'dLng', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$nWorkId = $PostData['nWorkId'];
				$nTimeType = $PostData['nTimeType'];
				$dTime = $PostData['dTime'];
				$dLat = $PostData['dLat'];
				$dLng = $PostData['dLng'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "No Token Send";
				} else {

					if ($this->MTS->authenticate($vToken)) {
						$data = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$nUserId = $data['id'];
						$nFranchiseeId =  $data['nFranchiseeId'];
						$vUserName = $data['vName'];
						$workdata = $this->MTS->selectone('workhdr', array('id' => $nWorkId));
						$update = $this->MTS->Update_mts('workhdr', array('dLat' => $dLat, 'dLng' => $dLng), array('id' => $nWorkId), $nUserId);
						$nCustId = $workdata['nCustId'];
						$custdata = $this->MTS->selectone('customermst', array('id' => $nCustId));
						$custName = $custdata['vName'];
						$wdLat = $custdata['dLat'];
						$wdLng = $custdata['dLng'];
						if ($this->MTS->distance($dLat, $dLng, $wdLat, $wdLng, "ME") > 100) {
							$message = "Tried to " . ($nTimeType == 1 ? "start" : "stop") . " work away from customer home";
							$responseData = $this->MTS->insert_mts('alertmst', array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $nUserId, "nWorkhdrId" => $nWorkId, "vMessage" => $message, "isActive" => 1, "isNotified" => 0), $nUserId);
							if ($responseData) {
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
							} else {
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
							}
						} else {
							if ($nTimeType == 1) {
								$update = $this->MTS->Update_mts('workhdr', array('tInTime' => $dTime), array('id' => $nWorkId), $nUserId);
							} else if ($nTimeType == 2) {
								$update = $this->MTS->Update_mts('workhdr', array('tOutTime' => $dTime), array('id' => $nWorkId), $nUserId);
							}
							if ($update > 0) {
								$this->status = Ws_Controller::HTTP_OK;
								$this->message = "Update Successfully Done";
							}
						}
					} else {

						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function searchCustomerlist()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('offset', 'offset', 'trim|required');
			$validation->setRule('vSearchQuery', 'vSearchQuery', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$vOffset = $PostData['offset'];
				$searchQuery = $PostData['vSearchQuery'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nFranchiseeId =  $getData['nFranchiseeId'];
						$data = $this->MTS->select_mts('customermst', array("isActive" => 1, "nFranchiseeId" => $nFranchiseeId), 0, 0, array(), 'vName', $searchQuery);
						$totalrow = "" . count($data) . "";
						$datalimit = LIMIT;
						$data = $this->MTS->select_mts('customermst', array("isActive" => 1, "nFranchiseeId" => $nFranchiseeId), $vOffset, LIMIT, array(), 'vName', $searchQuery);
						$continue = ($vOffset + LIMIT) < $totalrow ? "True" : "False";
						$limit = array('TotalRecord' => $totalrow, 'limit' => $datalimit, 'continue' => $continue);
						if (empty($data)) {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();
							$this->message = "No Result Found!";
						} else {
							$array3 = array();
							$arrayDemo = array();
							for ($i = 0; $i < count($data); $i++) {
								$data1[$i]['id'] = $data[$i]['id'] == "" ? "" : $data[$i]['id'];
								$data1[$i]['vName'] = $data[$i]['vName'] == "" ? "" : $data[$i]['vName'];
								$data1[$i]['vImagePath'] = $data[$i]['vImagePath'] == "" ? BASE_PATH . "upload/images/dprofile.png" : BASE_PATH . $data[$i]['vImagePath'];
								$data1[$i]['dLat'] = $data[$i]['dLat'] == "" ? "" : $data[$i]['dLat'];
								$data1[$i]['dLng'] = $data[$i]['dLng'] == "" ? "" : $data[$i]['dLng'];
								$array3 = $data1;
							}
							$data2['limit'] = $limit;
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							$this->extraData = $data2;
							$this->message = "Search Customer List";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function updateUserLatLng()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('dLat', 'dLat', 'trim|required');
			$validation->setRule('dLng', 'dLng', 'trim|required');
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$validation->setRule('dTripDistance', 'dTripDistance', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$dLat = $PostData['dLat'];
				$dLng = $PostData['dLng'];
				$nTeamId = $PostData['nTeamId'];
				$dTripDistance = $PostData['dTripDistance'];
				$trackId = $PostData['trackId'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$userdata = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$nUserId = $userdata['id'];
						$prevLat = $userdata['dLat'];
						$prevLng = $userdata['dLng'];
						$prevTripDistance = empty($userdata['dTripDistance']) ? 0 : (float)$userdata['dTripDistance'];

						// SANDBOX PATCH: Multi-device conflict prevention
						$deviceId = isset($PostData['device_id']) ? $PostData['device_id'] : null;
						if (!empty($deviceId)) {
							$activeDeviceId = $this->MTS->getActiveDeviceId($nUserId);
							if (!empty($activeDeviceId) && $activeDeviceId !== $deviceId) {
								$this->MTS->logGpsAnomaly($nUserId, $dTripDistance, 0, $prevLat, $prevLng, $dLat, $dLng, 'DEVICE_CONFLICT');
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "GPS update rejected: another device is active for this account.";
								$this->respond();
								return;
							}
						}

						// SANDBOX PATCH: Server-side distance validation (Haversine)
						if (!empty($prevLat) && !empty($prevLng) && $prevLat != 0 && $prevLng != 0) {
							$serverDelta = $this->MTS->haversineDistance((float)$prevLat, (float)$prevLng, (float)$dLat, (float)$dLng);
							$clientDelta = (float)$dTripDistance - $prevTripDistance;
							if ($serverDelta > 10 && $clientDelta > 10) {
								$deviationPct = abs($clientDelta - $serverDelta) / $serverDelta * 100;
								if ($deviationPct > 50) {
									$this->MTS->logGpsAnomaly($nUserId, $clientDelta, $serverDelta, $prevLat, $prevLng, $dLat, $dLng, 'DISTANCE_DEVIATION_MAJOR');
								} else if ($deviationPct > 10) {
									$this->MTS->logGpsAnomaly($nUserId, $clientDelta, $serverDelta, $prevLat, $prevLng, $dLat, $dLng, 'DISTANCE_DEVIATION_MINOR');
								}
							}
							// SANDBOX PATCH: Daily mileage cap
							$maxCap = $this->MTS->getMaxDailyMileageCap();
							if ((float)$dTripDistance > $maxCap) {
								$this->MTS->logGpsAnomaly($nUserId, $dTripDistance, $maxCap, $prevLat, $prevLng, $dLat, $dLng, 'DAILY_CAP_EXCEEDED');
								$dTripDistance = $maxCap;
							}
						}

						$myFile = "LatLng_with_dist_time_" . date('Y_m_d', $_SERVER['REQUEST_TIME']) . "" . $nUserId . ".txt";
						$fh = fopen($myFile, 'a');
						$stringData = $dLat . "," . $dLng . "," . $dTripDistance . " - " . date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']) . "\n";
						fwrite($fh, $stringData);
						fclose($fh);
						$update = $this->MTS->Update_mts('usermst', array('dLat' => $dLat, 'dLng' => $dLng, 'dTripDistance' => $dTripDistance), array('id' => $nUserId), $nUserId);
						// Work Tracking (Franklin)
						$track_record = $this->MTS->selectone('worktrackingmst', array('id' => $trackId));

						if ($track_record) {
							$current_point = array(
								'lat' => floatval($dLat),
								'lng' => floatval($dLng)
							);
							$tracking_data = json_decode($track_record['tracking_data']);
							if (count($tracking_data) > 0) {
								$last_point = end($tracking_data);
								$diff_in_meter = $this->MTS->distance($last_point->lat, $last_point->lng, $current_point['lat'], $current_point['lng'], "ME");
								if ($diff_in_meter > 10) {
									$tracking_data[] = $current_point;
									$this->MTS->Update_mts('worktrackingmst', array('tracking_data' => json_encode($tracking_data), 'updated_at' => date("Y-m-d H:i:s")), array('id' => $trackId), $nUserId);
								}
							} else {
								$tracking_data[] = $current_point;
								$this->MTS->Update_mts('worktrackingmst', array('tracking_data' => json_encode($tracking_data), 'updated_at' => date("Y-m-d H:i:s")), array('id' => $trackId), $nUserId);
							}
						}
						// Work Tracking (Franklin)
						$data =  $this->MTS->Workdata($nTeamId);
						if (empty($data)) {
							$data2['status'] = 0;
						} else {
							$nCustId = $data['nCustId'];
							$custdata = $this->MTS->selectone('customermst', array('id' => $nCustId));
							$custlat = $custdata['dLat'];
							$custlng = $custdata['dLng'];
							$employeeData_new = $this->MTS->selectone('employeeinoutmst', array('nEmpId' => $nUserId, 'nWorkhdrId' => $data['id']));
						}
						if (empty($data)) {
							// already set above
						} else if (empty($employeeData_new)) {
							$data2['status'] = 0;
						} else {
							$data2['status'] = 1;
							$data1['workId'] = $data['id'] == "" ? "" : $data['id'];
							$data1['nTeamId'] = $data['nTeamId'] == "" ? "" : $data['nTeamId'];
							$data1['CustomerName'] = $custdata['vName'] == "" ? "" : $custdata['vName'];
							$data1['CustomerLat'] = $custlat == "" ? "" : $custlat;
							$data1['CustomerLng'] = $custlng == "" ? "" : $custlng;
							$data1['dAmount'] = $data['dAmount'] == "" ? "" : $data['dAmount'];
							$data1['dWorkDate'] = $data['dWorkDate'] == "" ? "" : $data['dWorkDate'];
							$data1['InTime'] = $data['tInTime'] == "" ? "" : $data['tInTime'];
							$data1['OutTime'] = $tOutTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
							$data2['OngoingWork'] = $data1;
						}
						if ($update) {
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $data2;
							$this->message = "Update Successfully Done";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	// 	function addWorkHistoryNew()
	// 	{
	// 		$request = \Config\Services::request();
	// 		if ($request->is('post')) {
	// 			$PostData = $request->getPost();
	// 			$nWorkHistoryId = $PostData['nWorkHistoryId'];
	// 			$nOfficeId = $PostData['nOfficeId'];
	// 			$isReachedOffice = $PostData['isReachedOffice'];
	// 			if ($nWorkHistoryId == "") {
	// 				$tStartTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
	// 				$tStartTime = empty($tStartTime) ? NULL : $tStartTime;
	// 			} else {
	// 				$tEndTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
	// 				$tEndTime = empty($tEndTime) ? NULL : $tEndTime;
	// 			}
	// 			$nTeamId = $PostData['nTeamId'];
	// 			$nTeamId = empty($nTeamId) ? NULL : $nTeamId;
	// 			$dDate = date('Y-m-d', $_SERVER['REQUEST_TIME']);
	// 			$dCurrentDate = $this->MTS->getserverdate();
	// 			$nDistPrevWork = empty($PostData['nDistPrevWork']) ? NULL : $PostData['nDistPrevWork'];
	// 			$vToken = $this->getAuthToken();
	// 			if (!empty($vToken)) {
	// 				if ($this->MTS->authenticate($vToken)) {
	// 					$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
	// 					$uid = $getData['id'];
	// 					$nUserId = $uid;
	// 					$nFranchiseeId =  $getData['nFranchiseeId'];
	// 					$nDistPrevWork = empty($getData['dTripDistance']) ? NULL : $getData['dTripDistance'];
	// 					if (empty($nWorkHistoryId)) {
	// 						$trackId = $this->MTS->insert_mts("worktrackingmst", array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nTeamId" => $nTeamId, "tracking_data" => json_encode(array()), "created_at" => $dCurrentDate, "updated_at" => $dCurrentDate), $uid);
	// 						$WorkHistoryId = $this->MTS->insert_mts("workhistory", array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nTeamId" => $nTeamId, "tStartTime" => $tStartTime, "nTotalDistance" => 0, "nTrackId" => $trackId, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
	// 						$update = $this->MTS->Update_mts('usermst', array('dTripDistance' => 0), array('id' => $uid), $nUserId);
	// 						$getTlData = $this->MTS->selectone('teamhdr', array("id" => $nTeamId, "isLeader" => 1));
	// 						$tlId = $getTlData['nUserId'];
	// 						if ($WorkHistoryId) {
	// 							if ($uid == $tlId) {
	// 								$data1['isLeader'] = 1;
	// 							} else {
	// 								$data1['isLeader'] = 0;
	// 							}
	// 							$data1["nWorkHistoryId"] = $WorkHistoryId;
	// 							$data1['update'] = $uid;
	// 							$data1['trackId'] = $trackId;

	// 							$this->status = Ws_Controller::HTTP_OK;
	// 							$this->responseData = $data1;
	// 							$this->message = "Work details added Successfully.";
	// 						} else {
	// 							$this->status = Ws_Controller::HTTP_NOT_FOUND;
	// 							$this->message = "Fail";
	// 						}
	// 					} else if ($isReachedOffice == 0) {
	// 						$workHistoryData = $this->MTS->selectone('workhistory', array('id' => $nWorkHistoryId));
	// 						$nTotalDistance = $workHistoryData['nTotalDistance'] + ($nDistPrevWork ?? 0);
	// 						$WorkHistoryId = $this->MTS->update_mts("workhistory", array("tEndTime" => $tEndTime, "nTotalDistance" => $nTotalDistance, "isReachedOffice" => $isReachedOffice), array('id' => $nWorkHistoryId), $nUserId);
	// 						if ($WorkHistoryId) {
	// 							$data1["nWorkHistoryId"] = $nWorkHistoryId;
	// 							$this->status = Ws_Controller::HTTP_OK;
	// 							$this->responseData = $data1;
	// 							$this->message = "Work details successfully updated.";
	// 						} else {
	// 							$this->status = Ws_Controller::HTTP_NOT_FOUND;
	// 							$this->message = "Fail";
	// 						}
	// 					} else if ($isReachedOffice == 1) {
	// 					// FIX BUG 1: Validate no active workhdr exists before allowing "Reached Office"
	// 					// Employee must complete all ongoing work (nStatus=0) before ending the day
	// 					$activeWork = $this->MTS->selectone('workhdr', array(
	// 						'nUserId' => $nUserId,
	// 						'nTeamId' => $nTeamId,
	// 						'nStatus' => 0,
	// 						'isActive' => 1
	// 					));
	// 					if (!empty($activeWork)) {
	// 						$this->status = Ws_Controller::HTTP_BAD_REQUEST;
	// 						$this->message = "Cannot end day while work is still in progress. Please complete or cancel ongoing work first.";
	// 						return;
	// 					}

	// 					$myFile = "isReachedOffice" . date('Y_m_d', $_SERVER['REQUEST_TIME']) . "_" . ".txt";
	// 					$fh = fopen($myFile, 'a');
	// 					$stringData = $nUserId . " nUserId - " . date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']) . "\n";
	// 					fwrite($fh, $stringData);
	// 					fclose($fh);
	// 					$workHistoryData = $this->MTS->selectone('workhistory', array('id' => $nWorkHistoryId));
	// 						// ====== FIX: Compute INCREMENTAL distance to prevent double-counting ======
	// 						// Final leg: currentTripDistance - already recorded today = remaining unrecorded distance
	// 						$rawDistance = (float)$this->MTS->getUserDistance($uid);
	// 						$dateForDist = date('Y-m-d', strtotime($dCurrentDate));
	// 						$alreadyRec = $this->MTS->getEmployeeDistance($uid, $dateForDist);
	// 						$alreadyRecTotal = $alreadyRec ? (float)$alreadyRec['EmpTotalDistance'] : 0;
	// 						$nDistPrevWork = max(0, $rawDistance - $alreadyRecTotal);
	// 						// ========================================================================
	// 						$nTotalDistance = $workHistoryData['nTotalDistance'] + $nDistPrevWork;

	// 						// SANDBOX PATCH: Home geofence validation
	// 						$endDayLat = isset($getData['dLat']) ? $getData['dLat'] : null;
	// 						$endDayLng = isset($getData['dLng']) ? $getData['dLng'] : null;
	// 						if ($nOfficeId == '0' || $nOfficeId == 0) {
	// 							if (!empty($endDayLat) && !empty($endDayLng)) {
	// 								$homeLocation = $this->MTS->getEmployeeHomeLocation($uid);
	// 								if ($homeLocation) {
	// 									$homeDistance = $this->MTS->haversineDistance(
	// 										(float)$endDayLat, (float)$endDayLng,
	// 										(float)$homeLocation['dHomeLat'], (float)$homeLocation['dHomeLng']
	// 									);
	// 									if ($homeDistance > 8047) { // > 5 miles from registered home
	// 										$this->MTS->logGpsAnomaly($uid, $homeDistance, 8047, $endDayLat, $endDayLng, $homeLocation['dHomeLat'], $homeLocation['dHomeLng'], 'HOME_GEOFENCE_VIOLATION');
	// 									}
	// 								}
	// 							} else {
	// 								$this->MTS->logGpsAnomaly($uid, 0, 0, 0, 0, 0, 0, 'HOME_NO_GPS_COORDINATES');
	// 							}
	// 						}

	// 						$WorkHistoryId = $this->MTS->update_mts("workhistory", array("nOfficeId" => $nOfficeId, "tEndTime" => $tEndTime, "nTotalDistance" => $nTotalDistance, "isReachedOffice" => $isReachedOffice), array('id' => $nWorkHistoryId), $nUserId);
	// 						// FIX: Store proper nTeamId and nWorkhdrId so admin queries can link distance to specific work
	// 						// Get the last active workhdr for this user today to link the final-leg distance
	// 						$lastWorkHdr = $this->MTS->selectone('workhdr', array('nUserId' => $nUserId, 'nTeamId' => $nTeamId, 'isActive' => 1), 'id DESC');
	// 						$lastWorkhdrId = !empty($lastWorkHdr) ? $lastWorkHdr['id'] : 0;
	// 						$updatedistance = $this->MTS->insert_mts('employeedistancemst', array('nEmpId' => $nUserId, 'nTeamId' => ($nTeamId ?? 0), 'nWorkhdrId' => $lastWorkhdrId, "dTotalDistance" => $nDistPrevWork, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
	// 						$update = $this->MTS->Update_mts('usermst', array('dLat' => NULL, 'dLng' => NULL, 'dTripDistance' => 0), array('id' => $uid), $nUserId);
	// 						if ($WorkHistoryId) {
	// 							$data1["nWorkHistoryId"] = $nWorkHistoryId;
	// 							$this->status = Ws_Controller::HTTP_OK;
	// 							$this->responseData = $data1;
	// 							$this->message = "Work details successfully updated.";
	// 						} else {
	// 							$this->status = Ws_Controller::HTTP_NOT_FOUND;
	// 							$this->message = "Fail";
	// 						}
	// 					} else {
	// 						$this->status = Ws_Controller::HTTP_NOT_FOUND;
	// 						$this->message = "Failed.";
	// 					}
	// 				} else {
	// 					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
	// 					$this->message = "Wrong Token Sent";
	// 				}
	// 			} else {
	// 				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
	// 				$this->message = "No Token Send";
	// 			}
	// 		} else {
	// 			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
	// 			$this->message = lang('err_invalid_method');
	// 		}
	// 	}

	function addWorkHistoryNew()
	{
		$request = \Config\Services::request();

		if (!$request->is('post')) {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
			return;
		}

		$PostData = $request->getPost();

		$nWorkHistoryId = $PostData['nWorkHistoryId'] ?? null;
		$nOfficeId = $PostData['nOfficeId'] ?? null;
		$isReachedOffice = $PostData['isReachedOffice'] ?? null;

		if (empty($nWorkHistoryId)) {
			$tStartTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
			$tStartTime = empty($tStartTime) ? NULL : $tStartTime;
		} else {
			$tEndTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
			$tEndTime = empty($tEndTime) ? NULL : $tEndTime;
		}

		$nTeamId = $PostData['nTeamId'] ?? NULL;
		$nTeamId = empty($nTeamId) ? NULL : $nTeamId;

		$dDate = date('Y-m-d', $_SERVER['REQUEST_TIME']);
		$dCurrentDate = $this->MTS->getserverdate();

		$nDistPrevWork = $PostData['nDistPrevWork'] ?? NULL;

		$vToken = $this->getAuthToken();

		if (empty($vToken)) {
			$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
			$this->message = "No Token Send";
			return;
		}

		if (!$this->MTS->authenticate($vToken)) {
			$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
			$this->message = "Wrong Token Sent";
			return;
		}

		$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));

		if (!$getData) {
			$this->status = Ws_Controller::HTTP_NOT_FOUND;
			$this->message = "User not found";
			return;
		}

		$uid = $getData['id'];
		$nUserId = $uid;
		$nFranchiseeId = $getData['nFranchiseeId'];

		$nDistPrevWork = empty($getData['dTripDistance']) ? NULL : $getData['dTripDistance'];

		// ============================
		// START WORK
		// ============================
		if (empty($nWorkHistoryId)) {

			$trackId = $this->MTS->insert_mts(
				"worktrackingmst",
				array(
					"nFranchiseeId" => $nFranchiseeId,
					"nUserId" => $uid,
					"nTeamId" => $nTeamId,
					"tracking_data" => json_encode(array()),
					"created_at" => $dCurrentDate,
					"updated_at" => $dCurrentDate
				),
				$uid
			);

			if (!$trackId) {
				$this->status = Ws_Controller::HTTP_INTERNAL_ERROR;
				$this->message = "Failed to create tracking";
				return;
			}

			$WorkHistoryId = $this->MTS->insert_mts(
				"workhistory",
				array(
					"nFranchiseeId" => $nFranchiseeId,
					"nUserId" => $uid,
					"nTeamId" => $nTeamId,
					"tStartTime" => $tStartTime,
					"nTotalDistance" => 0,
					"nTrackId" => $trackId,
					"dModifiedDate" => $dCurrentDate,
					"dCreatedDate" => $dCurrentDate
				),
				$nUserId
			);

			if (!$WorkHistoryId) {
				$this->status = Ws_Controller::HTTP_INTERNAL_ERROR;
				$this->message = "Failed to create work history";
				return;
			}

			$this->MTS->Update_mts(
				'usermst',
				array('dTripDistance' => 0),
				array('id' => $uid),
				$nUserId
			);

			$getTlData = $this->MTS->selectone(
				'teamhdr',
				array("id" => $nTeamId, "isLeader" => 1)
			);

			$tlId = $getTlData['nUserId'] ?? 0;

			$data1 = array();
			$data1['isLeader'] = ($uid == $tlId) ? 1 : 0;
			$data1["nWorkHistoryId"] = $WorkHistoryId;
			$data1['update'] = $uid;
			$data1['trackId'] = $trackId;

			$this->status = Ws_Controller::HTTP_OK;
			$this->responseData = $data1;
			$this->message = "Work details added Successfully.";

			return;
		}

		// ============================
		// UPDATE WORK (NOT REACHED OFFICE)
		// ============================
		if ($isReachedOffice == 0) {

			$workHistoryData = $this->MTS->selectone(
				'workhistory',
				array('id' => $nWorkHistoryId)
			);

			if (!$workHistoryData) {
				$this->status = Ws_Controller::HTTP_NOT_FOUND;
				$this->message = "Work history not found";
				return;
			}

			$nTotalDistance = $workHistoryData['nTotalDistance'] + ($nDistPrevWork ?? 0);

			$updateResult = $this->MTS->update_mts(
				"workhistory",
				array(
					"tEndTime" => $tEndTime,
					"nTotalDistance" => $nTotalDistance,
					"isReachedOffice" => $isReachedOffice
				),
				array('id' => $nWorkHistoryId),
				$nUserId
			);

			if ($updateResult === false) {
				$this->status = Ws_Controller::HTTP_INTERNAL_ERROR;
				$this->message = "Failed to update work history";
				return;
			}

			$data1["nWorkHistoryId"] = $nWorkHistoryId;

			$this->status = Ws_Controller::HTTP_OK;
			$this->responseData = $data1;
			$this->message = "Work details successfully updated.";

			return;
		}

		// ============================
		// REACHED OFFICE
		// ============================
		if ($isReachedOffice == 1) {

			$workHistoryData = $this->MTS->selectone(
				'workhistory',
				array('id' => $nWorkHistoryId)
			);

			if (!$workHistoryData) {
				$this->status = Ws_Controller::HTTP_NOT_FOUND;
				$this->message = "Work history not found";
				return;
			}

			$rawDistance = (float)$this->MTS->getUserDistance($uid);

			$dateForDist = date('Y-m-d', strtotime($dCurrentDate));

			$alreadyRec = $this->MTS->getEmployeeDistance($uid, $dateForDist);

			$alreadyRecTotal = $alreadyRec ?
				(float)$alreadyRec['EmpTotalDistance'] : 0;

			$nDistPrevWork = max(0, $rawDistance - $alreadyRecTotal);

			$nTotalDistance =
				$workHistoryData['nTotalDistance'] + $nDistPrevWork;

			$updateResult = $this->MTS->update_mts(
				"workhistory",
				array(
					"nOfficeId" => $nOfficeId,
					"tEndTime" => $tEndTime,
					"nTotalDistance" => $nTotalDistance,
					"isReachedOffice" => $isReachedOffice
				),
				array('id' => $nWorkHistoryId),
				$nUserId
			);

			if ($updateResult === false) {
				$this->status = Ws_Controller::HTTP_INTERNAL_ERROR;
				$this->message = "Failed to complete work";
				return;
			}

			$this->MTS->Update_mts(
				'usermst',
				array(
					'dLat' => NULL,
					'dLng' => NULL,
					'dTripDistance' => 0
				),
				array('id' => $uid),
				$nUserId
			);

			$data1["nWorkHistoryId"] = $nWorkHistoryId;

			$this->status = Ws_Controller::HTTP_OK;
			$this->responseData = $data1;
			$this->message = "Work details successfully updated.";

			return;
		}

		$this->status = Ws_Controller::HTTP_BAD_REQUEST;
		$this->message = "Invalid request";
	}

	function checkAppVersion()
	{
		$request = \Config\Services::request();
		if ($request->is('get')) {
			$data = $this->MTS->checkversion();
			if (empty($data)) {
				$this->status = Ws_Controller::HTTP_NOT_FOUND;
			} else {
				$this->status = Ws_Controller::HTTP_OK;
				$this->responseData = $data;
				$this->message = "Version Detail";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function saveTeam()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$PostData = $request->getPost();
			$aUserList = $PostData['aUserList'];
			$isLeader = 1;
			$dModifiedDate = $this->MTS->getserverdate();
			$vToken = $this->getAuthToken();
			if (!empty($vToken)) {
				if ($this->MTS->authenticate($vToken)) {
					if ($aUserList) {
						$EmpId = explode(",", $aUserList);
						$this->MTS->updateInWorkStatus($EmpId, 1, $dModifiedDate);
						$this->MTS->updatePrevTeamStatus($EmpId, $currentDate);
					} else {
						$EmpId = array();
					}
					$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
					$uid = $getData['id'];
					$nUserId = $uid;
					$nFranchiseeId =  $getData['nFranchiseeId'];
					array_push($EmpId, $uid);
					$TeamhdrId = $this->MTS->insert_mts("teamhdr", array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "isLeader" => $isLeader, "isActive" => 1, "dModifiedDate" => $dModifiedDate, "dCreatedDate" => $dModifiedDate), $nUserId);
					for ($i = 0; $i < count($EmpId); $i++) {
						$Teamdtlid = $this->MTS->insert_mts("teamdtl", array("nFranchiseeId" => $nFranchiseeId, "nTeamhdrId" => $TeamhdrId, "nUserId" => $EmpId[$i], "isActive" => 1, "isLeader" => $EmpId[$i] == $uid ? 1 : 0, "dModifiedDate" => $dModifiedDate, "dCreatedDate" => $dModifiedDate), $nUserId);
					}
					if ($Teamdtlid) {
						$data1['nTeamId'] = $TeamhdrId;
						$this->status = Ws_Controller::HTTP_OK;
						$this->responseData = $data1;
						$this->message = "TeamDetails Successfully Added";
					} else {
						$this->status = Ws_Controller::HTTP_NOT_FOUND;
						$this->message = "Fail";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "Wrong Token Sent";
				}
			} else {
				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				$this->message = "No Token Send";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function getTeamDetail()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$nTeamId = $PostData['nTeamId'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$data = $this->MTS->select_mts('teamdtl', array('nTeamhdrId' => $nTeamId));
						if (empty($data)) {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->responseData = array();
							$this->message = "No Result Found!";
						} else {
							$array3 = array();
							$arrayDemo = array();
							for ($i = 0; $i < count($data); $i++) {
								$userdata = $this->MTS->getUserDetail(array('id' => $data[$i]["nUserId"]));
								$data1[$i]['id'] = $userdata['id'] == "" ? "" : $userdata['id'];
								$data1[$i]['vName'] = $userdata['vName'] == "" ? "" : $userdata['vName'];
								$data1[$i]['vImagePath'] = BASE_PATH . "upload/images/dprofile.png";
								$data1[$i]['isActive'] = $data[$i]['isActive'] == "" ? "" : $data[$i]['isActive'];
								$array3 = $data1;
							}
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $array3;
							$this->message = "Fetched team details successfully!";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = "Enter nTeamId value";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function getWorkStatusNew()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('timestamp', 'timestamp', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$timestamp = $_SERVER['REQUEST_TIME'];
				$vToken = $this->getAuthToken();
				if (empty($vToken)) {
					$this->status = Ws_Controller::HTTP_BAD_REQUEST;
					$this->message = "No Token Send";
				} else {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$dlat = $getData['dLat'];
						$dlng = $getData['dLng'];
						$dTripDistance = $getData['dTripDistance'];
						$nFranchiseeId =  $getData['nFranchiseeId'];
						$dCurrentDate = date("Y-m-d", $timestamp);
						$data = $this->MTS->checkworkstatus($uid, $dCurrentDate, $nFranchiseeId);
						if (empty($data)) {
							$hasTeam = $this->MTS->checkHasTeam($uid, $dCurrentDate, $nFranchiseeId);
							if (count($hasTeam) > 0) {
								$data1['teamID'] = (int)$hasTeam['nTeamhdrId'];
							} else {
								$data1['teamID'] = null;
							}
							$data1['status'] = 0;
							$this->status = Ws_Controller::HTTP_OK;
							$this->responseData = $data1;
							$this->message = "No Result Found!";
						} else {
							if ($data['isReachedOffice'] == 0) {
								$isLeader = $this->MTS->isLeader($uid, $dCurrentDate, $nFranchiseeId);
								$data1['isLeader'] = $isLeader;
								$data1['status'] = 1;
								$data1['nWorkHistoryId'] = $data['id'];
								$data1['nTeamId'] = $this->MTS->getCurrentTeamId($uid, $dCurrentDate, $nFranchiseeId);
								$data1['dLat'] = empty($dlat) ? '0.00' : $dlat;
								$data1['dLng'] = empty($dlng) ? '0.00' : $dlng;
								$data1['dTripDistance'] = empty($dTripDistance) ? 0 : $dTripDistance;
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $data1;
								$this->message = "Workstatus Detail";
							} else if ($data['isReachedOffice'] == 1) {
								$data1['status'] = 2;
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $data1;
								$this->message = "Workstatus Detail";
							} else {
								$data1['status'] = 2;
								$this->status = Ws_Controller::HTTP_OK;
								$this->responseData = $data1;
								$this->message = "Workstatus Detail";
							}
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->responseData = array();
						$this->message = "Wrong Token Sent";
					}
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = "Enter timestamp value";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function getOfficelist()
	{
		$request = \Config\Services::request();
		if ($request->is('get')) {
			$vToken = $this->getAuthToken();
			if (empty($vToken)) {
				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				$this->message = "No Token Send";
			} else {
				if ($this->MTS->authenticate($vToken)) {
					$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
					$uid = $getData['id'];
					$nFranchiseeId =  $getData['nFranchiseeId'];
					$data = $this->MTS->select_mts('officemst', array('isActive' => 1, "nFranchiseeId" => $nFranchiseeId));
					if (empty($data)) {
						$this->status = Ws_Controller::HTTP_NOT_FOUND;
						$this->responseData = array();
						$this->message = "No Result Found!";
					} else {
						$array3 = array();
						$arrayDemo = array();
						for ($i = 0; $i < count($data); $i++) {
							$data1['id'] = $data[$i]['id'] == "" ? "" : $data[$i]['id'];
							$data1['vName'] = $data[$i]['vName'] == "" ? "" : $data[$i]['vName'];
							$data1['dLat'] = $data[$i]['dLat'] == "" ? "" : $data[$i]['dLat'];
							$data1['dLng'] = $data[$i]['dLng'] == "" ? "" : $data[$i]['dLng'];
							array_push($array3, $data1);
						}
						$this->status = Ws_Controller::HTTP_OK;
						$this->responseData = $array3;
						$this->message = "Office List";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->responseData = array();
					$this->message = "Wrong Token Sent";
				}
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function cancelWork()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('nWorkId', 'nWorkId', 'trim|required');
			$validation->setRule('nCancleReason', 'nCancleReason', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$nWorkId = $PostData['nWorkId'];
				$nCancleReason = $PostData['nCancleReason'];
				$dCurrentDate = $this->MTS->getserverdate();
				$vToken = $this->getAuthToken();
				if (!empty($vToken)) {
					if ($this->MTS->authenticate($vToken)) {
						$employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$employeeId = $employeeData['id'];
						$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
						$this->MTS->updateInWorkStatus([$employeeId], 0, $dCurrentDate);
						$Workdata = $this->MTS->update_mts("workhdr", array("nStatus" => 2, "nCancleReason" => $nCancleReason, "dModifiedDate" => $dCurrentDate), array("id" => $nWorkId));
						if ($Workdata) {
							$this->MTS->update_mts("employeeinoutmst", array("dOutTime" => $dCurrentDate, "dModifiedDate" => $dCurrentDate), array("nWorkhdrId" => $nWorkId));
							$this->status = Ws_Controller::HTTP_OK;
							$this->message = "Work details successfully canceled";
						} else {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->message = "Fail";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function updateEmployeeDistance()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('nWorkhdrId', 'nWorkhdrId', 'trim|required');
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$validation->setRule('nEmpId', 'nEmpId', 'trim|required');
			$validation->setRule('dDistance', 'dDistance', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$vToken = $this->getAuthToken();
				if (!empty($vToken)) {
					if ($this->MTS->authenticate($vToken)) {
						$nWorkhdrId = $PostData['nWorkhdrId'];
						$nTeamId = $PostData['nTeamId'];
						$nEmpId = $PostData['nEmpId'];
						$dDistance = $PostData['dDistance'];
						$dCurrentDate = $this->MTS->getserverdate();
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$workdistancedata = $this->MTS->selectone("employeedistancemst", array("nEmpId" => $nEmpId, "nTeamId" => $nTeamId, "nWorkhdrId" => $nWorkhdrId, "isActive" => 1));
						if ($workdistancedata) {
							$dTotalDistance = $workdistancedata['dTotalDistance'] + $dDistance;
							$Distancedata = $this->MTS->update_mts("employeedistancemst", array("dTotalDistance" => $dTotalDistance, "dModifiedDate" => $dCurrentDate), array("id" => $workdistancedata['id']));
							if ($Distancedata) {
								$this->status = Ws_Controller::HTTP_OK;
								$this->message = "Employee Distance successfully updated";
							} else {
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->message = "Fail to update";
							}
						} else {
							$this->status = Ws_Controller::HTTP_NOT_FOUND;
							$this->message = "Result Not Found";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function addWorkNew_cr()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('dLat', 'dLat', 'trim|required');
			$validation->setRule('dLng', 'dLng', 'trim|required');
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$isDifferentDay = 0;
				$dWorkDateToCompare = $PostData['dWorkDate'];
				$nCustId = $PostData['nCustId'];
				$nWorkId = $PostData['nWorkId'];
				$dAmount = $PostData['dAmount'];
				$nTeamId = $PostData['nTeamId'];
				$isUpdateTeamForOngoingWork = $PostData['isUpdateTeamForOngoingWork'];
				$nWorkHistoryId = $PostData['nWorkHistoryId'];
				$tEndTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
				$dDate = date('Y-m-d', $_SERVER['REQUEST_TIME']);
				$tInTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
				$tInTime = empty($tInTime) ? NULL : $tInTime;
				$tOutTime = $PostData['tOutTime'];
				$tOutTime = empty($tOutTime) ? NULL : $tOutTime;
				$dWorkDate = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
				$vPaymentMethod = $PostData['vPaymentMethod'];
				$aWorkList = $PostData['aWorkList'];
				$vChequeNo = $PostData['vChequeNo'];
				$vChequeNo = empty($vChequeNo) ? NULL : $vChequeNo;
				$dLat = $PostData['dLat'];
				$dLng = $PostData['dLng'];
				$nDistPrevWork = empty($PostData['nDistPrevWork']) ? 0 : $PostData['nDistPrevWork'];
				$TeamEmpStr = $PostData['TeamEmpStr'];
				$Distancestr = $PostData['Distancestr'];
				$OutTimestr = $PostData['OutTimestr'];
				$dCurrentDate = $this->MTS->getserverdate();
				$vToken = $this->getAuthToken();
				if (!empty($vToken)) {
					if ($this->MTS->authenticate($vToken)) {
						$getData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$uid = $getData['id'];
						$nUserId = $uid;
						$nFranchiseeId =  $getData['nFranchiseeId'];
						if (empty($nCustId)) {
							$workdata = $this->MTS->selectone('workhdr', array('id' => $nWorkId));
							$nCustId = $workdata['nCustId'];
						} else {
							$nCustId = $PostData['nCustId'];
						}
						$vDeleteEmpId = $PostData['vDeleteEmpId'];
						$vAddEmpId = $PostData['vAddEmpId'];
						$custdata = $this->MTS->selectone('customermst', array('id' => $nCustId));
						$custName = $custdata['vName'];
						$wdLat = $custdata['dLat'];
						$wdLng = $custdata['dLng'];
						if (date('Y-m-d', $_SERVER['REQUEST_TIME']) != date('Y-m-d', strtotime($dWorkDateToCompare . " UTC"))) {
							$isDifferentDay = 1;
						}
						if ($this->MTS->distance($dLat, $dLng, $wdLat, $wdLng, "ME") > 100 && $isDifferentDay == 0 && ($vAddEmpId == "" && $vDeleteEmpId == "")) {
							$message = "Tried to " . (empty($nWorkId) ? "start" : "stop") . " work away from customer home";
							if (!empty($nWorkId)) {
								$responseData = $this->MTS->insert_mts('alertmst', array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nCustId" => $nCustId, "nWorkhdrId" => $nWorkId, "vMessage" => $message, "isActive" => 1, "isNotified" => 0, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
							} else {
								$responseData = $this->MTS->insert_mts('alertmst', array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nCustId" => $nCustId, "vMessage" => $message, "isActive" => 1, "isNotified" => 0, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
							}
							if ($responseData) {
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
							} else {
								$this->status = Ws_Controller::HTTP_BAD_REQUEST;
								$this->message = "Can not update while away from customer's home.";
							}
						} else {
							if ($nWorkId && $isUpdateTeamForOngoingWork != 1) {
								if (($tOutTime == NULL) || ($tOutTime == "")) {
									$tOutTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
								} else {
									$tOutTime = $tOutTime;
								}
								if ($isDifferentDay == 0) {
									$Workdata = $this->MTS->update_mts("workhdr", array("nUserId" => $uid, "dAmount" => $dAmount, "vPaymentMethod" => $vPaymentMethod, "vChequeNo" => $vChequeNo, "nStatus" => 1, "tOutTime" => $tOutTime, "dLat" => $dLat, "dLng" => $dLng, "dModifiedDate" => $dCurrentDate), array("id" => $nWorkId), $nUserId);
									$TeamEmpArray = explode(",", $TeamEmpStr);
									$OutTimeArray = explode(",", $OutTimestr);
									if (($tOutTime == NULL) || ($tOutTime == "")) {
										$tOutTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
									} else {
										$tOutTime = $tOutTime;
									}
									for ($l = 0; $l < count($OutTimeArray); $l++) {
										$updateinout = $this->MTS->update_mts('employeeinoutmst', array("dOutTime" => $tOutTime, "dModifiedDate" => $dCurrentDate), array('nEmpId' => $TeamEmpArray[$l], "nWorkhdrId" => $nWorkId, "isActive" => 1));
									}
								} else {
									$Workdata = $this->MTS->update_mts("workhdr", array("nUserId" => $uid, "dAmount" => $dAmount, "vPaymentMethod" => $vPaymentMethod, "vChequeNo" => $vChequeNo, "nStatus" => 1, "dLat" => $dLat, "dLng" => $dLng, "dModifiedDate" => $dCurrentDate), array("id" => $nWorkId), $nUserId);
								}
								for ($i = 0; $i < count($aWorkList); $i++) {
									$Workdtlid = $this->MTS->insert_mts("workdtl", array("nFranchiseeId" => $nFranchiseeId, "nWorkId" => $nWorkId, "nSId" => (explode(",", $aWorkList[$i])[0]), "nUserId" => (explode(",", $aWorkList[$i])[1]), "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
								}
							} else {
								$vDeleteEmpId = $PostData['vDeleteEmpId'];
								$vDeleteEmpOutTimestr = $PostData['vDeleteEmpOutTimestr'];
								$vAddEmpId = $PostData['vAddEmpId'];
								$vAddEmpInTimestr = $PostData['vAddEmpInTimestr'];
								$vAddEmpDistancestr = $PostData['vAddEmpDistancestr'];
								if ($vDeleteEmpId) {
									$DeletedId = explode(",", $vDeleteEmpId);
									$vDeleteEmpOutTime = explode(",", $vDeleteEmpOutTimestr);
									for ($j = 0; $j < count($DeletedId); $j++) {
										$update = $this->MTS->update_mts('teamdtl', array('isActive' => 2), array('nUserId' => $DeletedId[$j], 'nTeamhdrId' => $nTeamId));
										$this->MTS->insert_mts("empteammst", array("nUserId" => $DeletedId[$j], "nTeamId" => $nTeamId, "nType" => 2, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
										$dOutTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
										if (!empty($DeletedId)) {
											$updateinout = $this->MTS->update_mts('employeeinoutmst', array("dOutTime" => $dOutTime, "dModifiedDate" => $dCurrentDate), array('nEmpId' => $DeletedId[$j], "nWorkhdrId" => $nWorkId, "isActive" => 1));
										}
									}
								}
								if ($vAddEmpId) {
									$AddEmpId = explode(",", $vAddEmpId);
									$vAddEmpInTime = explode(",", $vAddEmpInTimestr);
									$vAddEmpDistance = explode(",", $vAddEmpDistancestr);
									for ($j = 0; $j < count($AddEmpId); $j++) {
										$Teamdata = $this->MTS->selectone('teamhdr', array('id' => $nTeamId, 'isActive' => 1));
										$tdetailData = $this->MTS->selectone('teamdtl', array('nUserId' => $AddEmpId[$j], 'nTeamhdrId' => $nTeamId));
										if (empty($tdetailData)) {
											$update = $this->MTS->insert_mts('teamdtl', array('nFranchiseeId' => $Teamdata['nFranchiseeId'], 'nTeamhdrId' => $nTeamId, 'nUserId' => $AddEmpId[$j], "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
										} else {
											$update = $this->MTS->update_mts('teamdtl', array("isActive" => 1, "dModifiedDate" => $dCurrentDate), array('nTeamhdrId' => $nTeamId, 'nUserId' => $AddEmpId[$j]));
										}
										if (!empty($vAddEmpDistance)) {
											$date = date('Y-m-d', strtotime($dCurrentDate));
											$EmpDistance = $this->MTS->getEmployeeDistance($AddEmpId[$j], $date);
											if ($EmpDistance) {
												$empTotalDistance = $EmpDistance['EmpTotalDistance'] + $vAddEmpDistance[$j];
											} else {
												$empTotalDistance = $vAddEmpDistance[$j];
											}
											$updatedistance = $this->MTS->insert_mts('employeedistancemst', array('nEmpId' => $AddEmpId[$j], 'nTeamId' => $nTeamId, 'nWorkhdrId' => $nWorkId, "dTotalDistance" => $empTotalDistance, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
											$dInTime = date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']);
											$updateinout = $this->MTS->insert_mts('employeeinoutmst', array('nEmpId' => $AddEmpId[$j], "dInTime" => $dInTime, 'nWorkhdrId' => $nWorkId, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
										}
										$userdistance  = $this->MTS->sumdistancedata($AddEmpId[$j], $dDate);
										$nUserTotalDistance = $userdistance['TotalDistance'];
										$this->MTS->insert_mts("empteammst", array("nUserId" => $AddEmpId[$j], "nTeamId" => $nTeamId, "dTotalDistance" => $nUserTotalDistance, "nType" => 1, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
									}
									$wdata = $this->MTS->selectone('workhdr', array('id' => $nWorkId, 'isActive' => 1));
									$nNumberOfEmployee = $wdata['nNumberOfEmployee'] + count($AddEmpId);
									$this->MTS->update_mts("workhdr", array("nNumberOfEmployee" => $nNumberOfEmployee, "dModifiedDate" => $dCurrentDate), array('id' => $nWorkId), $nUserId);
								}
								if ($isUpdateTeamForOngoingWork != 1) {
									$TeamEmpArray = explode(",", $TeamEmpStr);
									$DistanceArray = explode(",", $Distancestr);
									$nNumberOfEmployee = count($TeamEmpArray);
									$nWorkId = $this->MTS->insert_mts("workhdr", array("nFranchiseeId" => $nFranchiseeId, "nUserId" => $uid, "nCustId" => $nCustId, "nTeamId" => $nTeamId, "nNumberOfEmployee" => $nNumberOfEmployee, "dWorkDate" => $dWorkDate, "tInTime" => $tInTime, "dLat" => $dLat, "dLng" => $dLng, "nDistPrevWork" => $nDistPrevWork, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate), $nUserId);
									for ($k = 0; $k < count($TeamEmpArray); $k++) {
										$date = date('Y-m-d', strtotime($dCurrentDate));
										$EmpDistance = $this->MTS->getEmployeeDistance($TeamEmpArray[$k], $date);
										if ($EmpDistance) {
											$empTotalDistance = $EmpDistance['EmpTotalDistance'] + $DistanceArray[$k];
										} else {
											$empTotalDistance = $DistanceArray[$k];
										}
										$updatedistance = $this->MTS->insert_mts('employeedistancemst', array('nEmpId' => $TeamEmpArray[$k], 'nTeamId' => $nTeamId, 'nWorkhdrId' => $nWorkId, "dTotalDistance" => $empTotalDistance, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
										$updateinout = $this->MTS->insert_mts('employeeinoutmst', array('nEmpId' => $TeamEmpArray[$k], "dInTime" => $tInTime, 'nWorkhdrId' => $nWorkId, "isActive" => 1, "dModifiedDate" => $dCurrentDate, "dCreatedDate" => $dCurrentDate));
									}
									// FIX: Do NOT reset dTripDistance between works — Android overwrites it immediately.
									// Delta computation in startWork/accrueMiles handles per-work distance correctly.
								}
								if (!empty($nWorkHistoryId)) {
									$distance  = $this->MTS->sumdistancedata($uid, $dDate);
									$nTotalDistance = $distance['TotalDistance'];
									$WorkHistoryId = $this->MTS->update_mts("workhistory", array("tEndTime" => $tEndTime, "nTotalDistance" => $nTotalDistance, "isReachedOffice" => 0), array('id' => $nWorkHistoryId), $nUserId);
								}
							}
							if ($nWorkId) {
								if ($isDifferentDay == 0) {
									$this->status = Ws_Controller::HTTP_OK;
									$data1 = array();
									$data1["isWorkAdded"] = 1;
									$this->responseData = $data1;
									$this->message = "Work details successfully added";
								} else {
									$this->status = Ws_Controller::HTTP_OK;
									$data1 = array();
									$data1["isWorkAdded"] = 0;
									$this->responseData = $data1;
									$this->message = "Can not add details for previous day work.";
								}
							} else {
								$this->status = Ws_Controller::HTTP_NOT_FOUND;
								$this->message = "Fail";
							}
						}
					} else {

						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function selectWork()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('nCustId', 'nCustId', 'trim|required');
			$validation->setRule('dLat', 'dLat', 'trim|required');
			$validation->setRule('dLng', 'dLng', 'trim|required');
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$validation->setRule('nWorkHistoryId', 'nWorkHistoryId', 'trim|required');
			$validation->setRule('currentTeamMembers', 'currentTeamMembers', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$customerId = $PostData['nCustId'];
				$newTeamMembers = $PostData['newlyAddedTeamMembers'] == "" ? [] : explode(",", $PostData['newlyAddedTeamMembers']);
				$deletedTeamMembers = $PostData['deletedTeamMembers'] == "" ? [] : explode(",", $PostData['deletedTeamMembers']);
				$currentTeamMembers = $PostData['currentTeamMembers'] == "" ? [] : explode(",", $PostData['currentTeamMembers']);
				$teamId = $PostData['nTeamId'];
				$trackId = $PostData['trackId'];
				$employeeLatitude = $PostData['dLat'];
				$employeeLongitude = $PostData['dLng'];
				$workHistoryId = $PostData['nWorkHistoryId'];
				$vToken = $this->getAuthToken();
				$currentDate = $this->MTS->getserverdate();
				if ($vToken) {
					if ($this->MTS->authenticate($vToken)) {

						//Getting Employee details
						$employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$employeeId = $employeeData['id'];
						$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
						$distanceTravelled = empty($employeeData['dTripDistance']) ? NULL : $employeeData['dTripDistance'];

						//Getting Customer details
						$customerData = $this->MTS->selectone('customermst', array('id' => $customerId));
						$customerName = $customerData['vName'];
						$customerLatitude = $customerData['dLat'];
						$customerLongitude = $customerData['dLng'];

						// Adding new members to my team(teamdtl table)
						if (count($newTeamMembers) > 0) {
							$this->addTeamMembers($newTeamMembers, $employeeId, $teamId, $teamHdrData['nFranchiseeId'], $currentDate);
						} else {
							$this->MTS->updateInWorkStatus([$employeeId], 1, $currentDate);
						}

						// Deleting existing members in my team(teamdl table) isActive 1 => 0
						if (count($deletedTeamMembers) > 0) {
							$this->removeTeamMembers($deletedTeamMembers, $teamId, $currentDate);
						}

						$teammates = $this->MTS->getTeamMates($teamId);

						// Adding entry in the workhdr table
						$workHdrId = $this->MTS->insert_mts(
							"workhdr",
							array(
								"nFranchiseeId" => $employeeFranchiseeId,
								"team_mates" => $teammates,
								"nUserId" => $employeeId,
								"nCustId" => $customerId,
								"nTeamId" => $teamId,
								"nNumberOfEmployee" => count($currentTeamMembers),
								"dWorkDate" => $currentDate,
								"tInTime" => $currentDate,
								"dLat" => $employeeLatitude,
								"dLng" => $employeeLongitude,
								"isActive" => 1,
								"nStatus" => 10,
								"dModifiedDate" => $currentDate,
								"dCreatedDate" => $currentDate
							),
							$employeeId
						);

						// ================= SMS SECTION START =================

						// Always use fresh employee coordinates from POST
						$dataString = $employeeId . '|' . $customerId . '|' .
							$customerLatitude . '|' .  $customerLongitude . '|' .
							$employeeLatitude . '|' . $employeeLongitude . '|' .
							$workHdrId;

						$encryptedData = base64_encode($dataString);
						$tracking_url = "https://gpsscheduler.com/app/admin/trackLocation.php?data=" . urlencode($encryptedData);

						$messageBody = "Maid to Sparkle: Your assigned employee's real-time location is being shared. Click the link below to track their location: $tracking_url";

						// Get customer phone (USE ONE TABLE ONLY)
						$customerDetails = $this->MTS->selectone('customers', array('customer_id' => $customerId));

						$phone = '';
						if (!empty($customerDetails['phone'])) {
							$phone = $customerDetails['phone'];
						} elseif (!empty($customerDetails['cell'])) {
							$phone = $customerDetails['cell'];
						}

						// Normalize phone number
						$phone = preg_replace('/[^0-9]/', '', $phone);

						if (strlen($phone) == 10) {
							$custphone = '+1' . $phone;
						} elseif (strlen($phone) == 11 && substr($phone, 0, 1) == '1') {
							$custphone = '+' . $phone;
						} else {
							error_log("SMS ERROR: Invalid phone format for customer_id=$customerId Phone=$phone");
							$custphone = '';
						}

						// Normalize phone (remove everything except digits) - For Testing

						// if (strlen($phone) == 10) {
						// 	// Standard Indian mobile number
						// 	$custphone = '+91' . $phone;
						// } elseif (strlen($phone) == 12 && substr($phone, 0, 2) == '91') {
						// 	// Already has country code without +
						// 	$custphone = '+' . $phone;
						// } elseif (strlen($phone) == 13 && substr($phone, 0, 3) == '091') {
						// 	// Stored as 091xxxxxxxxxx
						// 	$custphone = '+91' . substr($phone, 3);
						// } else {
						// 	error_log("SMS ERROR: Invalid Indian phone format for customer_id=$customerId Phone=$phone");
						// 	$custphone = '';
						// }

						$responseData = [];

						if (!empty($custphone)) {

							$accountSid = env('TWILIO_ACCOUNT_SID');
							$authToken = env('TWILIO_AUTH_TOKEN');
							$twilioPhoneNumber = env('TWILIO_PHONE');
							$twilioMessagingService = env('TWILIO_MESSAGING_SERVICE_SID');

							$url = "https://api.twilio.com/2010-04-01/Accounts/$accountSid/Messages.json";

							$postData = [
								'MessagingServiceSid' => $twilioMessagingService,
								'To' => $custphone,
								'Body' => $messageBody,
								'StatusCallback' => 'https://gpsscheduler.com/twilio_status_callback.php'
							];

							$ch = curl_init($url);
							curl_setopt($ch, CURLOPT_POST, true);
							curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
							curl_setopt($ch, CURLOPT_USERPWD, "$accountSid:$authToken");
							curl_setopt($ch, CURLOPT_TIMEOUT, 15);
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

							$response = curl_exec($ch);

							if (curl_errno($ch)) {
								$error = curl_error($ch);
								error_log("SMS CURL ERROR: " . $error);
								$responseData = ['error' => $error];
							} else {
								$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
								$responseData = json_decode($response, true);
								if ($httpCode >= 400) {
									error_log("SMS API ERROR: HTTP $httpCode for customer_id=$customerId Response=" . $response);
								}
							}

							curl_close($ch);
						} else {
							error_log("SMS ERROR: No valid phone for customer_id=$customerId");
							$responseData = ['error' => 'No valid phone'];
						}

						// Log SMS response
						file_put_contents(
							"SMS_response.txt",
							"[" . date("Y-m-d H:i:s") . "] CustomerID=$customerId Phone=$custphone Response=" . json_encode($responseData) . PHP_EOL,
							FILE_APPEND
						);

						// ================= SMS SECTION END =================


						$this->status = Ws_Controller::HTTP_OK;
						$data = array();
						$data["isWorkAdded"] = 1;
						$data["customerLat"] = $customerLatitude;
						$data["customerLng"] = $customerLongitude;
						$data["tracking_url"] = $tracking_url;
						$data["SMS"] = $responseData;
						$this->responseData = $data;
						$this->message = "Work details successfully added";
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function startWork()
	{
		$request = \Config\Services::request();

		if (!$request->is('post')) {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
			return;
		}

		$validation = \Config\Services::validation();
		$validation->setRule('nCustId', 'nCustId', 'trim|required');
		$validation->setRule('dLat', 'dLat', 'trim|required');
		$validation->setRule('dLng', 'dLng', 'trim|required');
		$validation->setRule('nDistPrevWork', 'nDistPrevWork', 'trim|required');
		$validation->setRule('nTeamId', 'nTeamId', 'trim|required');

		$PostData = $request->getPost();

		if (!$validation->run($PostData)) {
			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
			$this->message = strip_tags($validation->listErrors());
			return;
		}

		$customerId = $PostData['nCustId'];
		$currentTeamMembers = $PostData['currentTeamMembers'] == ""
			? []
			: explode(",", $PostData['currentTeamMembers']);

		$teamId = $PostData['nTeamId'];
		$employeeLatitude = $PostData['dLat'];
		$employeeLongitude = $PostData['dLng'];
		$distanceTravelled = $PostData['nDistPrevWork'];
		$workHistoryId = $PostData['nWorkHistoryId'];
		$workHdrId = $PostData['workID'];
		$trackId = $PostData['trackId'];

		$vToken = $this->getAuthToken();

		if (!$vToken) {
			$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
			$this->message = "No Token Sent";
			return;
		}

		if (!$this->MTS->authenticate($vToken)) {
			$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
			$this->message = "Wrong Token Sent";
			return;
		}

		// ======= IMPORTANT FIX: SINGLE TIME SOURCE =======
		$currentDate = $this->MTS->getserverdate();
		// ================================================

		// Get user
		$userDetail = $this->MTS->getUserDetail(["vToken" => $vToken]);
		$employeeId = $userDetail['id'];
		$employeeFranchiseeId = $userDetail['nFranchiseeId'];

		// ====== FIX: Compute INCREMENTAL (per-work) distance ======
		// Android accumulates totalDistance for the entire day and never resets between works.
		// Server computes per-work delta: currentTripDistance - SUM(today's employeedistancemst)
		// This gives the distance traveled ONLY for THIS work segment.
		$rawTripDistance = empty($userDetail['dTripDistance']) ? 0 : (float)$userDetail['dTripDistance'];
		$date = date('Y-m-d', strtotime($currentDate));
		$alreadyRecorded = $this->MTS->getEmployeeDistance($employeeId, $date);
		$alreadyRecordedTotal = $alreadyRecorded ? (float)$alreadyRecorded['EmpTotalDistance'] : 0;
		$distanceTravelled = max(0, $rawTripDistance - $alreadyRecordedTotal);
		// ========================================================================

		// Get customer
		$customerData = $this->MTS->selectone('customermst', ['id' => $customerId]);
		$customerLatitude = $customerData['dLat'];
		$customerLongitude = $customerData['dLng'];

		// Distance check
		if (
			$this->MTS->distance(
				$employeeLatitude,
				$employeeLongitude,
				$customerLatitude,
				$customerLongitude,
				"ME"
			) > 100
			|| $customerData['is_condominium']
		) {
			$duplicate = $currentTeamMembers;
			unset($duplicate[array_search($employeeId, $duplicate)]);
			$team_members_list = array_merge(
				[$employeeId],
				array_values($duplicate)
			);

			$team_details = $this->MTS->team_details_start_form(
				implode(',', $team_members_list),
				$teamId
			);

			$data = [
				'customer_name' => $customerData['vName'],
				'employee_list' => $team_details
			];

			if ($customerData['is_condominium']) {
				$message = "Tried to start work in a condo complex";

				$this->MTS->insert_mts('alertmst', [
					"nFranchiseeId" => $employeeFranchiseeId,
					"nUserId" => $employeeId,
					"nCustId" => $customerId,
					"vMessage" => $message,
					"isActive" => 1,
					"isNotified" => 0,
					"dModifiedDate" => $currentDate,
					"dCreatedDate" => $currentDate
				], $employeeId);

				$this->responseData = $data;
				$this->status = Ws_Controller::HTTP_OK;
				$this->message = "Update manually while in a condo complex.";
				return;
			}

			$message = "Tried to start work away from customer home";

			$this->MTS->insert_mts('alertmst', [
				"nFranchiseeId" => $employeeFranchiseeId,
				"nUserId" => $employeeId,
				"nCustId" => $customerId,
				"vMessage" => $message,
				"lat" => $employeeLatitude,
				"lng" => $employeeLongitude,
				"isActive" => 1,
				"isNotified" => 0,
				"dModifiedDate" => $currentDate,
				"dCreatedDate" => $currentDate
			], $employeeId);

			$this->responseData = $data;
			$this->status = Ws_Controller::HTTP_OK;
			$this->message = "Cannot update while away from customer's home.";
			return;
		}

		// ============ MAIN START WORK FLOW (SERVER TIME) ============

		// 1) Add distance record
		$this->MTS->insert_mts('employeedistancemst', [
			'nEmpId' => $employeeId,
			'nTeamId' => $teamId,
			'nWorkhdrId' => $workHdrId,
			"dTotalDistance" => $distanceTravelled,
			"isActive" => 1,
			"dModifiedDate" => $currentDate,
			"dCreatedDate" => $currentDate
		]);

		// 2) Add InTime (SERVER TIME)
		$this->MTS->insert_mts('employeeinoutmst', [
			'nEmpId' => $employeeId,
			"dInTime" => $currentDate,
			'nWorkhdrId' => $workHdrId,
			"isActive" => 1,
			"dModifiedDate" => $currentDate,
			"dCreatedDate" => $currentDate
		]);

		// 3) DO NOT reset dTripDistance between works.
		// Android keeps accumulating and overwrites any reset immediately.
		// Server uses delta computation (above) to get per-work distance.
		// dTripDistance is only reset at end of day (addWorkHistoryNew isReachedOffice=1).

		// 4) Update workhistory distance — incremental add, NOT sum of all workhdr
		$workHistoryData = $this->MTS->selectone('workhistory', ['id' => $workHistoryId]);
		$workHistoryDistance = $workHistoryData['nTotalDistance'] + ($distanceTravelled ?? 0);

		$this->MTS->update_mts(
			"workhistory",
			[
				"nTotalDistance" => $workHistoryDistance,
				"isReachedOffice" => 0
			],
			['id' => $workHistoryId],
			$employeeId
		);

		// 5) Update workhdr START time (SERVER TIME)
		$this->MTS->update_mts(
			'workhdr',
			[
				"nStatus" => 0,
				"tInTime" => $currentDate,
				"nDistPrevWork" => $distanceTravelled
			],
			['id' => $workHdrId]
		);

		// 6) Clear tracking data
		$this->MTS->update_mts(
			'worktrackingmst',
			[
				'tracking_data' => json_encode([]),
				'updated_at' => date('Y-m-d H:i:s')
			],
			['id' => $trackId]
		);

		$this->status = Ws_Controller::HTTP_OK;
		// Return per-work distance (in miles) so Android can show a popup
		$distanceMiles = round($distanceTravelled * 0.000621371, 2);
		$this->responseData = [
			"isWorkAdded" => 1,
			"customerLat" => $customerLatitude,
			"customerLng" => $customerLongitude,
			"perWorkDistanceMeters" => $distanceTravelled,
			"perWorkDistanceMiles" => $distanceMiles
		];
		$this->message = "Work details successfully added";
	}


	private function addTeamMembers($team_members, $leader_id, $team_id, $franchisee_id, $current_date)
	{
		$newArr = array_merge($team_members, [$leader_id]);
		$this->MTS->updateInWorkStatus($newArr, 1, $current_date);
		$this->MTS->updatePrevTeamStatus($team_members, $current_date);
		for ($index = 0; $index < count($team_members); $index++) {
			// Getting the teamhdr table entry
			$teamHdrData = $this->MTS->selectone('teamhdr', array('id' => $team_id, 'isActive' => 1));
			// Checking whether the team member has already in team before(teamdtl table)
			$tdetailData = $this->MTS->selectone('teamdtl', array('nUserId' => $team_members[$index], 'nTeamhdrId' => $team_id));
			if (empty($tdetailData)) {
				$update = $this->MTS->insert_mts('teamdtl', array('nFranchiseeId' => $franchisee_id, 'nTeamhdrId' => $team_id, 'nUserId' => $team_members[$index], "isActive" => 1, "dModifiedDate" => $current_date, "dCreatedDate" => $current_date));
			} else {
				$update = $this->MTS->update_mts('teamdtl', array("isActive" => 1, "dModifiedDate" => $current_date), array('nTeamhdrId' => $team_id, 'nUserId' => $team_members[$index]));
			}
		}
	}

	private function removeTeamMembers($team_members, $team_id, $current_date)
	{
		// Modifying inWork table to make the employee inWork status inactive
		$this->MTS->updateInWorkStatus($team_members, 0, $current_date);
		for ($index = 0; $index < count($team_members); $index++) {
			$update = $this->MTS->update_mts('teamdtl', array('isActive' => 0), array('nUserId' => $team_members[$index], 'nTeamhdrId' => $team_id));
			$insert = $this->MTS->insert_mts("empteammst", array("nUserId" => $team_members[$index], "nTeamId" => $team_id, "nType" => 2, "isActive" => 1, "dModifiedDate" => $current_date, "dCreatedDate" => $current_date));
		}
	}

	function mannualFormSubmit()
	{
		$request = \Config\Services::request();

		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('nCustId', 'nCustId', 'trim|required');
			$validation->setRule('formType', 'formType', 'trim|required');
			$validation->setRule('teamId', 'teamId', 'trim|required');
			$postData = $request->getPost();
			if ($validation->run($postData)) {
				$customerId = $postData['nCustId'];
				$form_type = $postData['formType'];
				$teamId = $postData['teamId'];
				$formData = json_decode(stripslashes($postData['employeeForms']));
				$timeZone =  $postData['timeZone'];
				$workHdrId = $postData['nWorkId'];
				$vToken = $this->getAuthToken();
				$currentDate = $this->MTS->getserverdate();
				$date = date('Y-m-d', strtotime($currentDate));
				if ($vToken) {
					if ($this->MTS->authenticate($vToken)) {
						$userDetail = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$distanceTravelled = empty($userDetail['dTripDistance']) ? NULL : $userDetail['dTripDistance'];
						//Getting Customer details
						$customerData = $this->MTS->selectone('customermst', array('id' => $customerId));
						$customerName = $customerData['vName'];
						$customerLatitude = $customerData['dLat'];
						$customerLongitude = $customerData['dLng'];
						//Getting Employee details
						$employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$employeeId = $employeeData['id'];
						$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
						$teammatesForm = array();
						$teamLeadersData;
						$teammates = array();
						foreach ($formData as $data) {
							$data->nDistanceTravelled = $data->nDistanceTravelled;
							$data->InTime = $this->MTS->timeToUtc($data->InTime, $timeZone);
							$data->OutTime = $this->MTS->timeToUtc($data->OutTime, $timeZone);
							array_push($teammates, $data->id);
							if ($data->id == $employeeId) {
								$teamLeadersData = $data;
							}
						}
						if ($form_type == 0) {
							foreach ($formData as $data) {
								// FIX: Check if distance record exists (GPS may have recorded 0 due to weak signal)
								// If exists, UPDATE it; otherwise INSERT new record
								if (property_exists($data, 'distance_id') && !empty($data->distance_id)) {
									// Update existing record with manual miles
									$this->MTS->update_mts('employeedistancemst', [
										'dTotalDistance' => $data->nDistanceTravelled * 1609.34,
										'manual_distance' => $data->nDistanceTravelled,
										'dModifiedDate' => $currentDate
									], ['id' => $data->distance_id], $data->id);
								} else {
									// Insert new record
									$updatedistance = $this->MTS->insert_mts('employeedistancemst', array('nEmpId' => $data->id, 'nTeamId' => $data->nTeamId, 'nWorkhdrId' => $workHdrId, "dTotalDistance" => $data->nDistanceTravelled * 1609.34, "manual_distance" => $data->nDistanceTravelled, "isActive" => 1, "dModifiedDate" => $currentDate, "dCreatedDate" => $currentDate));
								}
								// FIX: Check if inout record exists before inserting
								$existingInout = $this->MTS->selectone('employeeinoutmst', ['nEmpId' => $data->id, 'nWorkhdrId' => $workHdrId]);
								if (empty($existingInout)) {
									$updateinout = $this->MTS->insert_mts('employeeinoutmst', array('nEmpId' => $data->id, "dInTime" => $data->InTime, 'nWorkhdrId' => $workHdrId, "isActive" => 1, "dModifiedDate" => $currentDate, "dCreatedDate" => $currentDate));
								} else {
									$updateinout = $this->MTS->update_mts('employeeinoutmst', ['dInTime' => $data->InTime, 'dModifiedDate' => $currentDate], ['id' => $existingInout['id']], $data->id);
								}
								$updateuser = $this->MTS->update_mts('usermst', array('dTripDistance' => 0), array('id' => $data->id), $data->id);
								if (property_exists($data, 'workHistoryId')) {
									$distance  = $this->MTS->sumdistancedata($data->id, $date);
									$workHistoryDistance = $distance->TotalDistance;
									$this->MTS->update_mts("workhistory", array("nTotalDistance" => $workHistoryDistance, "isReachedOffice" => 0), array('id' => $data->workHistoryId), $data->id);
									$work_history = $this->MTS->selectone('workhistory', array('id' => $data->workHistoryId));
									if ($work_history['nTrackId']) {
										$this->MTS->update_mts('worktrackingmst', array("tracking_data" => json_encode(array()), 'updated_at' => date('Y-m-d H:i:s')), array('id' => $work_history['nTrackId']));
									}
								}
							}

							// 			foreach ($teammates as $teammateId) {

							//                         // Step 1: Update work_trip_end
							//                         $this->MTS->update_mts('worktrackingmst', array('work_trip_end' => 1, 'updated_at' => date('Y-m-d H:i:s')), array('nTeamId' => $teamId, 'nUserId' => $teammateId, 'nWorkId' => $workHdrId));
							//                         // Step 2: Fetch updated tracking data
							//                         $trackingData = $this->MTS->selectone('worktrackingmst', array('nTeamId' => $teamId, 'nUserId' => $teammateId, 'nWorkId' => $workHdrId, 'work_trip_end' => 1));
							//                         // Step 3: Decode raw tracking data
							//                         $rawTrackingData = json_decode($trackingData['tracking_data'] ?? '[]', true);
							//                         // Step 4: Try snapping the points
							//                         try {
							//                             $snappedPoints = $this->getSnappedPoints($rawTrackingData);
							//                             $logFile = "Logger_getSnappedPoints_error_" . date('Y_m_d') . ".txt";
							//                             $fh = fopen($logFile, 'a');

							//                             if (!empty($snappedPoints)) {
							//                                 // Save snapped data
							//                                 $this->MTS->insert_mts('snappedtrackingmst', array('nTeamId' => $teamId, 'nUserId' => $teammateId, 'nWorkId' => $workHdrId, 'snapped_data' => json_encode($snappedPoints), 'dCreatedDate' => date('Y-m-d H:i:s')) , $teammateId);
							//                             } else {
							//                                 fwrite($fh, "!! No snapped points found for WorkID: $workHdrId, UserID: $teammateId at " . date('Y-m-d H:i:s') . "\n\n");
							//                             }

							//                             fwrite($fh, ">> rawTrackingData for UserID $teammateId: " . json_encode($rawTrackingData) . "\n\n");
							//                             fclose($fh);
							//                         } catch (\Throwable $e) {
							//                             $logFile = "Logger_getSnappedPoints_error_" . date('Y_m_d') . ".txt";
							//                             $fh = fopen($logFile, 'a');
							//                             fwrite($fh, "!! ERROR while snapping points for WorkID: $workHdrId, UserID: $teammateId\n");
							//                             fwrite($fh, $e->getMessage() . "\n");
							//                             fwrite($fh, $e->getTraceAsString() . "\n\n");
							//                             fclose($fh);
							//                         }
							//                     }

							$updatework = $this->MTS->update_mts('workhdr', array("nStatus" => 0, "tInTime" => $currentDate, "nDistPrevWork" => $distanceTravelled), array('id' => $workHdrId));

							$this->status = Ws_Controller::HTTP_OK;
							$response = array();
							$response["isWorkAdded"] = 1;
							$response["customerLat"] = $customerLatitude;
							$response["customerLng"] = $customerLongitude;
							$this->responseData = $response;
							$this->message = "Work details successfully added";
							exit;
						} else if ($form_type == 1) {
							$priceCharged = $postData['dAmount'];
							$workList = $postData['aWorkList'];
							$paymentMethod = $postData['vPaymentMethod'];
							$chequeNumber = $postData['vChequeNo'];
							$workHdrId = $postData['nWorkId'];
							$Workdata = $this->MTS->update_mts("workhdr", array("nUserId" => $employeeId, "dAmount" => $priceCharged, "vPaymentMethod" => $paymentMethod, "vChequeNo" => $chequeNumber, "nStatus" => 1, "tOutTime" => $teamLeadersData->OutTime, "dLat" => $customerLatitude, "dLng" => $customerLongitude, "dModifiedDate" => $currentDate), array("id" => $workHdrId), $employeeId);
							for ($index = 0; $index < count($workList); $index++) {
								$Workdtlid = $this->MTS->insert_mts("workdtl", array("nFranchiseeId" => $employeeFranchiseeId, "nWorkId" => $workHdrId, "nSId" => (explode(",", $workList[$index])[0]), "nUserId" => (explode(",", $workList[$index])[1]), "isActive" => 1, "dModifiedDate" => $currentDate, "dCreatedDate" => $currentDate), $employeeId);
							}
							foreach ($formData as $data) {
								// FIX: Allow manual miles even if GPS recorded 0 (weak signal)
								// If distance_id exists, UPDATE it; otherwise INSERT new record
								if ($data->nDistanceTravelled > 0) {
									if (!empty($data->distance_id)) {
										// Update existing record with manual miles (overwrite GPS 0)
										$this->MTS->update_mts('employeedistancemst', [
											'dTotalDistance' => $data->nDistanceTravelled * 1609.34,
											'manual_distance' => $data->nDistanceTravelled,
											'dModifiedDate' => $currentDate
										], ['id' => $data->distance_id], $data->id);
									} else {
										// Insert new record
										$insertDistance = $this->MTS->insert_mts('employeedistancemst', array('nEmpId' => $data->id, 'nTeamId' => $data->nTeamId, 'nWorkhdrId' => $workHdrId, "dTotalDistance" => $data->nDistanceTravelled * 1609.34, "manual_distance" => $data->nDistanceTravelled, "isActive" => 1, "dModifiedDate" => $currentDate, "dCreatedDate" => $currentDate));
									}
								}
								if (empty($data->time_id)) {
									$updateinout = $this->MTS->insert_mts('employeeinoutmst', array('nEmpId' => $data->id, "dInTime" => $data->InTime, 'nWorkhdrId' => $workHdrId, "isActive" => 1, "dModifiedDate" => $currentDate, "dOutTime" => $data->OutTime, "dCreatedDate" => $currentDate));
								} else {
									$updateinout = $this->MTS->update_mts('employeeinoutmst', array("dOutTime" => $data->OutTime, "dModifiedDate" => $currentDate), array('id' => $data->time_id));
								}
							}

							$this->status = Ws_Controller::HTTP_OK;
							$response = array();
							$response["isWorkAdded"] = 1;
							$this->responseData = $response;
							$this->message = "Work completed successfully!";
						} else {
							$this->status = Ws_Controller::HTTP_BAD_REQUEST;
							$this->message = "Invalid Form";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}


	function completeWork()
	{
		$request = \Config\Services::request();

		if (!$request->is('post')) {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
			return;
		}

		$validation = \Config\Services::validation();
		$validation->setRule('dLat', 'Latitude', 'trim|required');
		$validation->setRule('dLng', 'Longitude', 'trim|required');
		$validation->setRule('nTeamId', 'Team ID', 'trim|required');
		$validation->setRule('nWorkId', 'Work ID', 'trim|required');

		$PostData = $request->getPost();

		if (!$validation->run($PostData)) {
			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
			$this->message = strip_tags($validation->listErrors());
			return;
		}

		$workHdrId = $PostData['nWorkId'];
		$teamId = $PostData['nTeamId'];
		$employeeLatitude = $PostData['dLat'];
		$employeeLongitude = $PostData['dLng'];
		$priceCharged = $PostData['dAmount'] ?? null;
		$paymentMethod = $PostData['vPaymentMethod'] ?? null;
		$chequeNumber = $PostData['vChequeNo'] ?? null;
		$workHistoryId = $PostData['nWorkHistoryId'] ?? null;
		$timeZone = $PostData['timeZone'] ?? null;

		$vToken = $this->getAuthToken();

		if (!$vToken) {
			$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
			$this->message = "No Token Sent";
			return;
		}

		if (!$this->MTS->authenticate($vToken)) {
			$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
			$this->message = "Wrong Token Sent";
			return;
		}

		$currentDate = $this->MTS->getserverdate();

		$workData = $this->MTS->selectone('workhdr', ['id' => $workHdrId]);

		if (empty($workData)) {
			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
			$this->message = "Invalid Work ID";
			return;
		}

		$customerId = $workData['nCustId'];
		$customerData = $this->MTS->selectone('customermst', ['id' => $customerId]);

		$customerLatitude = $customerData['dLat'];
		$customerLongitude = $customerData['dLng'];

		$employeeData = $this->MTS->getUserDetail(["vToken" => $vToken]);
		$employeeId = $employeeData['id'];
		$employeeFranchiseeId = $employeeData['nFranchiseeId'];

		$distanceFromCustomer = $this->MTS->distance(
			$employeeLatitude,
			$employeeLongitude,
			$customerLatitude,
			$customerLongitude,
			"ME"
		);

		$team_details = $this->MTS->team_details_complete_form(
			$workData['team_mates'],
			$teamId,
			$workHdrId,
			$timeZone
		);

		$response = [
			'customer_id' => $customerId,
			'customer_name' => $customerData['vName'],
			'employee_list' => $team_details,
			'distance' => $distanceFromCustomer
		];

		if ($workData['is_manual_update'] == "1" || $customerData['is_condominium']) {

			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
			$this->responseData = $response;
			$this->message = "Manual completion required for condo complex.";
			return;
		}


		if ($distanceFromCustomer > 100 && is_null($workData['tNotificationTime'])) {

			$this->MTS->insert_mts('alertmst', [
				"nFranchiseeId" => $employeeFranchiseeId,
				"nUserId" => $employeeId,
				"nCustId" => $customerId,
				"nWorkhdrId" => $workHdrId,
				"vMessage" => "Tried to stop work away from customer home",
				"lat" => $employeeLatitude,
				"lng" => $employeeLongitude,
				"isActive" => 1,
				"isNotified" => 0,
				"dModifiedDate" => $currentDate,
				"dCreatedDate" => $currentDate
			], $employeeId);

			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
			$this->responseData = $response;
			$this->message = "Too far from customer location.";
			return;
		}

		/**
		 * COMPLETE WORK (REAL COMPLETION)
		 */

		$this->MTS->updateInWorkStatus([$employeeId], 0, $currentDate);

		$this->MTS->update_mts("workhdr", [
			"nUserId" => $employeeId,
			"dAmount" => $priceCharged,
			"vPaymentMethod" => $paymentMethod,
			"vChequeNo" => $chequeNumber,
			"nStatus" => 1,
			"tOutTime" => $currentDate,
			"dLat" => $employeeLatitude,
			"dLng" => $employeeLongitude,
			"dModifiedDate" => $currentDate
		], ["id" => $workHdrId], $employeeId);

		/**
		 * RECORD FINAL DISTANCE PER WORK (NOT PER DAY)
		 * FIX BUG 4: Use delta computation to prevent double-counting
		 */
		$rawTripDistance = (float)$this->MTS->getUserDistance($employeeId);
		$dateForDist = date('Y-m-d', strtotime($currentDate));
		$alreadyRecorded = $this->MTS->getEmployeeDistance($employeeId, $dateForDist);
		$alreadyRecordedTotal = $alreadyRecorded ? (float)$alreadyRecorded['EmpTotalDistance'] : 0;
		$distanceDelta = max(0, $rawTripDistance - $alreadyRecordedTotal);

		if ($distanceDelta > 0) {

			$this->MTS->insert_mts('employeedistancemst', [
				'nEmpId' => $employeeId,
				'nTeamId' => $teamId,
				'nWorkhdrId' => $workHdrId,
				'dTotalDistance' => $distanceDelta,
				'isActive' => 1,
				'dModifiedDate' => $currentDate,
				'dCreatedDate' => $currentDate
			], $employeeId);
		}

		/**
		 * UPDATE WORK HISTORY
		 */
		if (!empty($workHistoryId)) {

			$workHistoryData = $this->MTS->selectone('workhistory', ['id' => $workHistoryId]);

			if (!empty($workHistoryData)) {

				$totalDistance = $workHistoryData['nTotalDistance'] + $distanceDelta;

				$this->MTS->update_mts("workhistory", [
					"nTotalDistance" => $totalDistance,
					"tEndTime" => $currentDate,
					"isReachedOffice" => 0
				], ['id' => $workHistoryId], $employeeId);
			}
		}

		/**
		 * SAVE WORK DETAILS
		 */
		if (!empty($PostData['aWorkList'])) {

			foreach ($PostData['aWorkList'] as $item) {

				$parts = explode(",", $item);

				$this->MTS->insert_mts("workdtl", [
					"nFranchiseeId" => $employeeFranchiseeId,
					"nWorkId" => $workHdrId,
					"nSId" => $parts[0],
					"nUserId" => $parts[1],
					"isActive" => 1,
					"dModifiedDate" => $currentDate,
					"dCreatedDate" => $currentDate
				], $employeeId);
			}
		}

		/**
		 * FINAL CLEANUP
		 */
		$this->MTS->updatAllOutTime($currentDate, $workHdrId);
		$this->MTS->addInOutTime($currentDate, $workHdrId);

		/**
		 * SUCCESS RESPONSE
		 */
		$this->status = Ws_Controller::HTTP_OK;
		$this->responseData = ["isWorkAdded" => 1];
		$this->message = "Work completed successfully!";
	}

	function accrueMiles()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('dLat', 'dLat', 'trim|required');
			$validation->setRule('dLng', 'dLng', 'trim|required');
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$PostData = $request->getPost();
			if ($validation->run($PostData)) {
				$workHdrId = $PostData['nWorkId'];
				$teamId = $PostData['nTeamId'];
				$trackId = $PostData['trackId'];
				$employeeLatitude = $PostData['dLat'];
				$employeeLongitude = $PostData['dLng'];
				$distanceTravelled = $PostData['nDistPrevWork'];
				$workHistoryId = $PostData['nWorkHistoryId'];
				$vToken = $this->getAuthToken();
				$currentDate = $this->MTS->getserverdate();
				if ($vToken) {
					if ($this->MTS->authenticate($vToken)) {
						// Getting Employee details
						$employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$employeeId = $employeeData['id'];
						$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
						// Getting Customer details
						$wordhdrData = $this->MTS->selectone('workhdr', array('id' => $workHdrId));
						$customerData = $this->MTS->selectone('customermst', array('id' => $wordhdrData['nCustId']));
						$customerId = $customerData['id'];
						$customerLatitude = $customerData['dLat'];
						$customerLongitude = $customerData['dLng'];
						if ($wordhdrData['is_manual_update'] == 1) {
							$this->status = Ws_Controller::HTTP_BAD_REQUEST;
							$this->message = "Due to condominium location, your team leader will update your miles manually";
							exit;
						}
						if ($this->MTS->distance($employeeLatitude, $employeeLongitude, $customerLatitude, $customerLongitude, "ME") > 100) {
							$message = "Tried to start work away from customer home";
							$sendNotification = $this->MTS->insert_mts('alertmst', array("nFranchiseeId" => $employeeFranchiseeId, "nUserId" => $employeeId, "nCustId" => $customerId, "lat" => $employeeLatitude, "lng" => $employeeLongitude, "nWorkhdrId" => $workHdrId, "vMessage" => $message, "isActive" => 1, "isNotified" => 0, "dModifiedDate" => $currentDate, "dCreatedDate" => $currentDate), $employeeId);
							$this->status = Ws_Controller::HTTP_BAD_REQUEST;
							$this->message = "Can not update while away from customer's home.";
						} else {
							// ====== FIX: Compute INCREMENTAL distance to prevent double-counting ======
							$rawDistance = $this->MTS->getUserDistance($employeeId);
							$date = date('Y-m-d', strtotime($currentDate));
							$alreadyRecorded = $this->MTS->getEmployeeDistance($employeeId, $date);
							$alreadyRecordedTotal = $alreadyRecorded ? $alreadyRecorded['EmpTotalDistance'] : 0;
							$employee_distance = $rawDistance - $alreadyRecordedTotal;
							if ($employee_distance < 0) {
								$employee_distance = 0;
							}
							// ========================================================================
							$updatedistance = $this->MTS->insert_mts('employeedistancemst', array('nEmpId' => $employeeId, 'nTeamId' => $teamId, 'nWorkhdrId' => $workHdrId, "dTotalDistance" => $employee_distance, "isActive" => 1, "dModifiedDate" => $currentDate, "dCreatedDate" => $currentDate));
							// Adding start time in employeeinoutmst table							
							$employeeData_new = $this->MTS->selectone('employeeinoutmst', array('nEmpId' => $employeeId, 'nWorkhdrId' => $workHdrId));
							if (empty($employeeData_new)) {
								$updateinout = $this->MTS->insert_mts('employeeinoutmst', array('nEmpId' => $employeeId, "dInTime" => $currentDate, 'nWorkhdrId' => $workHdrId, "isActive" => 1, "dModifiedDate" => $currentDate, "dCreatedDate" => $currentDate));
							} else {
								$updateinout = $this->MTS->update_mts('employeeinoutmst', array('dInTime' => $currentDate, 'dModifiedDate' => $currentDate, 'dCreatedDate' => $currentDate), array('nEmpId' => $employeeId, 'nWorkhdrId' => $workHdrId));
							}
							// DO NOT reset dTripDistance between works — Android overwrites it immediately.
							// Delta computation above handles per-work distance correctly.
							// dTripDistance is only reset at end of day (addWorkHistoryNew isReachedOffice=1).
							// Updating team trip distance in workhistory table
							$workHistoryData = $this->MTS->selectone('workhistory', array('id' => $workHistoryId));
							$workHistoryDistance = $workHistoryData['nTotalDistance'] + $employee_distance;
							$this->MTS->update_mts("workhistory", array("nTotalDistance" => $workHistoryDistance, "isReachedOffice" => 0), array('id' => $workHistoryId), $employeeId);

							// Update work id on tracking id
							$trackingData = $this->MTS->selectone('worktrackingmst', array('id' => $trackId));
							$rawTrackingData = json_decode($trackingData['tracking_data'], true);

							try {
								$snappedPoints = $this->getSnappedPoints($rawTrackingData);

								$logFile = "Logger_getSnappedPoints_accrueMiles_" . date('Y_m_d') . ".txt";
								$fh = fopen($logFile, 'a');

								if (!empty($snappedPoints)) {
									// FIX: Check for existing record to avoid duplicates
									$existingSnap = $this->MTS->selectone('snappedtrackingmst', [
										'nWorkId' => $workHdrId,
										'nUserId' => $employeeId
									]);

									if (empty($existingSnap)) {
										$this->MTS->insert_mts('snappedtrackingmst', [
											'nTeamId' => $teamId,
											'nUserId' => $employeeId,
											'nWorkId' => $workHdrId,
											'snapped_data' => json_encode($snappedPoints),
											'dCreatedDate' => date('Y-m-d H:i:s')
										], $employeeId);
										fwrite($fh, ">> Inserted snapped tracking for EmpID: $employeeId, WorkID: $workHdrId at " . date('Y-m-d H:i:s') . "\n");
									} else {
										// Update existing record with new snapped data
										$this->MTS->update_mts('snappedtrackingmst', [
											'snapped_data' => json_encode($snappedPoints),
											'dCreatedDate' => date('Y-m-d H:i:s')
										], ['id' => $existingSnap['id']], $employeeId);
										fwrite($fh, ">> Updated snapped tracking for EmpID: $employeeId, WorkID: $workHdrId at " . date('Y-m-d H:i:s') . "\n");
									}
								} else {
									fwrite($fh, "!! No snapped points found for WorkID: $workHdrId, EmpID: $employeeId at " . date('Y-m-d H:i:s') . "\n\n");
								}

								fwrite($fh, ">> rawTrackingData: " . substr(json_encode($rawTrackingData), 0, 500) . "\n\n");
								fclose($fh);
							} catch (\Throwable $e) {
								$logFile = "Logger_getSnappedPoints_accrueMiles_" . date('Y_m_d') . ".txt";
								$fh = fopen($logFile, 'a');
								fwrite($fh, "!! ERROR while snapping points for WorkID: $workHdrId, EmpID: $employeeId\n");
								fwrite($fh, $e->getMessage() . "\n");
								fwrite($fh, $e->getTraceAsString() . "\n\n");
								fclose($fh);
							}

							$myFile = "Logger_" . date('Y_m_d', $_SERVER['REQUEST_TIME']) . "_" . ".txt";
							$fh = fopen($myFile, 'a');
							$stringData = json_encode($PostData) . " worklist - " . date('Y-m-d H:i:s', $_SERVER['REQUEST_TIME']) . "\n";
							fwrite($fh, $workHdrId);
							fclose($fh);

							$this->MTS->update_mts('worktrackingmst', array("tracking_data" => json_encode(array()), 'updated_at' => date('Y-m-d H:i:s')), array('id' => $trackId), $employeeId);

							$this->status = Ws_Controller::HTTP_OK;
							$data1 = array();
							$data1["isWorkAdded"] = 1;
							$this->responseData = $data1;
							$this->message = "Miles accrued successfully!";
						}
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function leaveTeam()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$PostData = $request->getPost();
			$teamId = $PostData['teamId'];
			$workId = $PostData['workId'];
			$trackId = $PostData['trackID'];
			$vToken = $this->getAuthToken();
			$currentDate = $this->MTS->getserverdate();
			if ($vToken) {
				if ($this->MTS->authenticate($vToken)) {
					// Getting Employee details
					$employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
					$employeeId = $employeeData['id'];
					$employeeFranchiseeId =  $employeeData['nFranchiseeId'];
					$this->MTS->updateInWorkStatus([$employeeId], 0, $currentDate);
					$updateteamdtl = $this->MTS->update_mts('teamdtl', array('isActive' => 2), array('nTeamhdrId' => $teamId, 'nUserId' => $employeeId, 'nFranchiseeId' => $employeeFranchiseeId), $employeeId);
					if ($workId) {
						$updateouttime = $this->MTS->updatOutTime($currentDate, $workId, $employeeId);
					}
					$this->MTS->update_mts('worktrackingmst', array('tracking_data' => json_encode(array()), 'updated_at' => date('Y-m-d H:i:s')), array('id' => $trackId));
					$this->status = Ws_Controller::HTTP_OK;
					$data['sql'] = $updateouttime;
					$this->responseData = $data;
					$this->message = "You have successfully left the team!";
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "Wrong Token Sent";
				}
			} else {
				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				$this->message = "No Token Send";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function updateTeam()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$validation = \Config\Services::validation();
			$validation->setRule('dLat', 'dLat', 'trim|required');
			$validation->setRule('dLng', 'dLng', 'trim|required');
			$validation->setRule('nTeamId', 'nTeamId', 'trim|required');
			$PostData = $request->getPost();

			if ($validation->run($PostData)) {
				$workId = $PostData['nWorkId'];
				$teamId = $PostData['nTeamId'];
				$newTeamMembers = $PostData['vAddEmpId'] == "" ? [] : explode(",", $PostData['vAddEmpId']);
				$deletedTeamMembers = $PostData['vDeleteEmpId'] == "" ? [] : explode(",", $PostData['vDeleteEmpId']);

				// Get the logout times string from Android
				$deleteEmpOutTimestr = isset($PostData['vDeleteEmpOutTimestr']) ? $PostData['vDeleteEmpOutTimestr'] : '';
				$addEmpInTimestr = isset($PostData['vAddEmpInTimestr']) ? $PostData['vAddEmpInTimestr'] : '';

				// Parse the logout times - format is likely "empId1:time1,empId2:time2"
				$logoutTimes = [];
				if (!empty($deleteEmpOutTimestr)) {
					$logoutPairs = explode(",", $deleteEmpOutTimestr);
					foreach ($logoutPairs as $pair) {
						$parts = explode(":", $pair);
						if (count($parts) == 2) {
							$logoutTimes[$parts[0]] = $parts[1]; // empId => logoutTime
						}
					}
				}

				// Parse the login times for new employees
				$loginTimes = [];
				if (!empty($addEmpInTimestr)) {
					$loginPairs = explode(",", $addEmpInTimestr);
					foreach ($loginPairs as $pair) {
						$parts = explode(":", $pair);
						if (count($parts) == 2) {
							$loginTimes[$parts[0]] = $parts[1]; // empId => loginTime
						}
					}
				}

				$manageEmp = isset($PostData['vmanageEmp']) ? $PostData['vmanageEmp'] : '';
				$vToken = $this->getAuthToken();
				$currentDate = $this->MTS->getserverdate();

				if ($vToken) {
					if ($this->MTS->authenticate($vToken)) {
						// Getting Employee details
						$employeeData = $this->MTS->getUserDetail(array("vToken" => $vToken));
						$employeeId = $employeeData['id'];
						$employeeFranchiseeId = $employeeData['nFranchiseeId'];

						if (count($newTeamMembers) > 0) {
							$this->MTS->updateInWorkStatus($newTeamMembers, 1, $currentDate);
							$this->MTS->updatePrevTeamStatus($newTeamMembers, $currentDate);

							for ($index = 0; $index < count($newTeamMembers); $index++) {
								$newEmpId = $newTeamMembers[$index];

								// Use actual login time if provided, otherwise use current time
								$loginTime = isset($loginTimes[$newEmpId]) ? $loginTimes[$newEmpId] : $currentDate;

								// Getting the teamhdr table entry
								$teamHdrData = $this->MTS->selectone('teamhdr', array('id' => $teamId, 'isActive' => 1));

								// Checking whether the team member has already in team before(teamdtl table)
								$tdetailData = $this->MTS->selectone('teamdtl', array('nUserId' => $newEmpId, 'nTeamhdrId' => $teamId));

								if (empty($tdetailData)) {
									$update = $this->MTS->insert_mts('teamdtl', array(
										'nFranchiseeId' => $teamHdrData['nFranchiseeId'],
										'nTeamhdrId' => $teamId,
										'nUserId' => $newEmpId,
										"isActive" => 1,
										"dModifiedDate" => $loginTime,
										"dCreatedDate" => $loginTime
									));
								} else {
									$update = $this->MTS->update_mts(
										'teamdtl',
										array("isActive" => 1, "dModifiedDate" => $loginTime),
										array('nTeamhdrId' => $teamId, 'nUserId' => $newEmpId)
									);
								}
							}

							$getwork = $this->MTS->selectone('workhdr', array('id' => $workId));
							$teammates = array_merge(explode(",", $getwork['team_mates']), $newTeamMembers);
							$updatework = $this->MTS->update_mts(
								'workhdr',
								array("team_mates" => implode(",", $teammates), "dModifiedDate" => $currentDate),
								array('id' => $workId)
							);
						}

						if (count($deletedTeamMembers) > 0) {
							// Modifying inWork table to make the employee inWork status inactive
							$this->MTS->updateInWorkStatus($deletedTeamMembers, 0, $currentDate);

							for ($index = 0; $index < count($deletedTeamMembers); $index++) {
								$employeeIdToDelete = $deletedTeamMembers[$index];

								// Use individual logout time from Android, otherwise use current time
								$logoutTime = isset($logoutTimes[$employeeIdToDelete])
									? $logoutTimes[$employeeIdToDelete]
									: $currentDate;

								$get_in_out = $this->MTS->get_in_out_mts($employeeIdToDelete, $workId);

								if (empty($get_in_out)) {
									$get_teame_leader_inout = $this->MTS->get_team_leader_inout($workId);
									$update = $this->MTS->update_mts(
										'teamdtl',
										array('isActive' => 2),
										array('nUserId' => $employeeIdToDelete, 'nTeamhdrId' => $teamId)
									);
									$insert = $this->MTS->insert_mts("empteammst", array(
										"nUserId" => $employeeIdToDelete,
										"nTeamId" => $teamId,
										"nType" => 2,
										"isActive" => 1,
										"dModifiedDate" => $logoutTime,
										"dCreatedDate" => $logoutTime
									));
									$insert_inoutmst = $this->MTS->insert_mts("employeeinoutmst", array(
										"nEmpId" => $employeeIdToDelete,
										"dInTime" => $get_teame_leader_inout['dInTime'],
										"dOutTime" => $logoutTime,
										"nWorkhdrId" => $workId,
										"dModifiedDate" => $logoutTime,
										"dCreatedDate" => $logoutTime
									));
								} else {
									$update = $this->MTS->update_mts(
										'teamdtl',
										array('isActive' => 2),
										array('nUserId' => $employeeIdToDelete, 'nTeamhdrId' => $teamId)
									);
									$insert = $this->MTS->insert_mts("empteammst", array(
										"nUserId" => $employeeIdToDelete,
										"nTeamId" => $teamId,
										"nType" => 2,
										"isActive" => 1,
										"dModifiedDate" => $logoutTime,
										"dCreatedDate" => $logoutTime
									));
									$updateouttime = $this->MTS->updatOutTime($logoutTime, $workId, $employeeIdToDelete);
								}

								$deletedTeamMembersData = $this->MTS->selectone('usermst', array('id' => $employeeIdToDelete));
							}

							// Remove deleted members from workhdr.team_mates
							$getwork = $this->MTS->selectone('workhdr', array('id' => $workId));
							if ($getwork && !empty($getwork['team_mates'])) {
								$currentTeamMates = explode(",", $getwork['team_mates']);
								$updatedTeamMates = array_values(array_diff($currentTeamMates, $deletedTeamMembers));
								$this->MTS->update_mts(
									'workhdr',
									array("team_mates" => implode(",", $updatedTeamMates), "dModifiedDate" => $currentDate),
									array('id' => $workId)
								);
							}
						}

						if ($manageEmp == '1') {
							if (count($newTeamMembers) > 0) {
								for ($index = 0; $index < count($newTeamMembers); $index++) {
									$newEmpId = $newTeamMembers[$index];
									$loginTime = isset($loginTimes[$newEmpId]) ? $loginTimes[$newEmpId] : $currentDate;

									$employeeData_new = $this->MTS->selectone(
										'employeeinoutmst',
										array('nEmpId' => $newEmpId, 'nWorkhdrId' => $workId)
									);

									if (empty($employeeData_new)) {
										$addinout = $this->MTS->insert_mts('employeeinoutmst', array(
											'nEmpId' => $newEmpId,
											"dInTime" => $loginTime,
											'nWorkhdrId' => $workId,
											"isActive" => 1,
											"dModifiedDate" => $loginTime,
											"dCreatedDate" => $loginTime
										));
									} else {
										if ($employeeData_new['dOutTime'] != NULL) {
											$updateinout = $this->MTS->update_mts(
												'employeeinoutmst',
												array(
													'dInTime' => $loginTime,
													'dOutTime' => NULL,
													'dModifiedDate' => $loginTime,
													'dCreatedDate' => $loginTime
												),
												array('nEmpId' => $newEmpId, 'nWorkhdrId' => $workId)
											);
											$updateinout = $this->MTS->update_mts(
												'employeeinoutmst',
												array('dOutTime' => NULL),
												array('nEmpId' => $newEmpId, 'nWorkhdrId' => $workId, 'dOutTime' => "0000-00-00 00:00:00")
											);
										}
									}
								}
							}
						}

						$this->status = Ws_Controller::HTTP_OK;
						$this->responseData = array();
						$this->message = "Your team has been updated successfully!";
					} else {
						$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
						$this->message = "Wrong Token Sent";
					}
				} else {
					$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
					$this->message = "No Token Send";
				}
			} else {
				$this->status = Ws_Controller::HTTP_BAD_REQUEST;
				$this->message = strip_tags($validation->listErrors());
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}

	function test()
	{
		$inputTime = '16:45';
		$inputTimeZone = 'Asia/Kolkata';
		// Set the default timezone to the input timezone
		date_default_timezone_set($inputTimeZone);
		// Get the timestamp of the input time in the input timezone
		$inputTimestamp = strtotime($inputTime);
		// Set the default timezone to UTC
		date_default_timezone_set('UTC');
		// Format the timestamp as UTC time
		$utcTime = date('Y-m-d H:i:s', $inputTimestamp);
		// Output the result
		echo "Input Time in IST: $inputTime\n";
		echo "Converted Time in UTC: $utcTime\n";
	}

	function del()
	{
		$del = $this->MTS->del();
		print_r($del);
		exit;
	}

	function delf()
	{
		$del = $this->MTS->delf();
		print_r($del);
		exit;
	}

	function updateNotificationTime()
	{
		$request = \Config\Services::request();
		if ($request->is('post')) {
			$PostData = $request->getPost();
			$timestamp = $this->MTS->getserverdate();
			$nWorkId = $PostData['nWorkId'];
			$workData = $this->MTS->selectone('workhdr', array('id' => $nWorkId));
			$customerId = $workData['nCustId'];
			$employeeId = $workData['nUserId'];
			$employeeFranchiseeId = $workData['nFranchiseeId'];
			$employeeData = $this->MTS->selectone('usermst', array('id' => $employeeId));
			$employeeLatitude = $employeeData['dLat'];
			$employeeLongitude = $employeeData['dLng'];
			$message = "Work complete notification has been sent";
			$sendNotification = $this->MTS->insert_mts('alertmst', array(
				"nFranchiseeId" => $employeeFranchiseeId,
				"nUserId" => $employeeId,
				"nCustId" => $customerId,
				"vMessage" => $message,
				"lat" => $employeeLatitude,
				"lng" => $employeeLongitude,
				"isActive" => 1,
				"isNotified" => 0,
				"dModifiedDate" => $timestamp,
				"dCreatedDate" => $timestamp
			), $employeeId);
			$update = $this->MTS->update_mts('workhdr', array("tNotificationTime" => $timestamp), array('id' => $nWorkId));
			if ($update) {
				$this->status = Ws_Controller::HTTP_OK;
				$this->responseData = $data1;
				$this->message = "Work details successfully added";
			} else {
				$this->status = Ws_Controller::HTTP_UNAUTHORIZED;
				$this->message = "Wrong Token Sent";
			}
		} else {
			$this->status = Ws_Controller::HTTP_METHOD_NOT_ALLOWED;
			$this->message = lang('err_invalid_method');
		}
	}


	function getRealtimelocation()
	{
		//$teamleadid= '434';
		//$custid = '9';
		//echo $teamleadid; 
		$teamleadid = isset($_GET['employeeId']) ? $_GET['employeeId'] : '';
		$custid = isset($_GET['customerId']) ? $_GET['customerId'] : '';
		$workid = isset($_GET['workid']) ? $_GET['workid'] : '';
		$userdata = $this->MTS->getUserDetail(array("id" => $teamleadid));
		$employeeData_new = $this->MTS->selectone('employeeinoutmst', array('nEmpId' => $teamleadid, 'nWorkhdrId' => $workid));

		$workData = $this->MTS->selectone('workhdr', array('id' => $workid));


		if (!empty($userdata) && empty($employeeData_new) && !empty($workData)) {
			$data = [
				'lat' => $userdata['dLat'],
				'lng' => $userdata['dLng'],
			];
			$this->status = Ws_Controller::HTTP_OK;
			$this->responseData = $data;
			$this->message = "Successfully Done";
		} else {
			$response = [
				'error' => 'User not found or location not available'
			];
		}
	}

	function getDummyLocation()
	{
		$array = array(
			'78.14382,8.80393',
			'78.14358,8.80393',
			'78.1436,8.80403',
			'78.14362,8.8042',
			'78.14355,8.80415',
			'78.1435,8.80412',
			'78.14343,8.80408',
			'78.14334,8.80405',
			'78.14326,8.80401',
			'78.14329,8.80418',
			'78.14328,8.80434',
			'78.14324,8.80447',
			'78.1433,8.80449',
			'78.14367,8.80467',
			'78.14384,8.80476',
			'78.14382,8.80485',
			'78.14382,8.80489',
			'78.14381,8.80495',
			'78.14381,8.805',
			'78.14382,8.80508',
			'78.14382,8.80519',
			'78.14382,8.80523',
			'78.14383,8.80526',
			'78.14384,8.80531',
			'78.14385,8.80535',
			'78.14386,8.80538',
			'78.14387,8.80541',
			'78.14389,8.80545',
			'78.14392,8.80558',
			'78.14394,8.80567',
			'78.14397,8.8059',
			'78.14339,8.8062',
			'78.1433,8.80625',
			'78.14268,8.8066',
			'78.14264,8.80663',
			'78.14249,8.80673',
			'78.14204,8.80705',
			'78.1419,8.80717',
			'78.14183,8.80723',
			'78.1416,8.80745',
			'78.14152,8.80754',
			'78.14149,8.80757',
			'78.14148,8.80759',
			'78.14145,8.80762',
			'78.14075,8.80836',
			'78.14069,8.80842',
			'78.14062,8.80849',
			'78.14056,8.80856',
			'78.14047,8.80865',
			'78.14041,8.80853',
			'78.14038,8.8085',
			'78.14036,8.80847',
			'78.14034,8.80845',
			'78.14031,8.80843',
			'78.14029,8.80842',
			'78.14026,8.80841',
			'78.14023,8.80841',
			'78.1402,8.80841',
			'78.1398,8.80838',
			'78.13902,8.80831',
			'78.13896,8.80828',
			'78.13893,8.80828',
			'78.1389,8.80828',
			'78.1389,8.80827',
			'78.1389,8.80826',
			'78.1389,8.80825',
			'78.13889,8.80824',
			'78.13889,8.80823',
			'78.13888,8.80823',
			'78.13887,8.80822',
			'78.13886,8.80822',
			'78.13885,8.80821',
			'78.13884,8.80821',
			'78.13883,8.80821',
			'78.13882,8.80821',
			'78.13881,8.80821',
			'78.1388,8.80821',
			'78.13879,8.80821',
			'78.13878,8.80821',
			'78.13877,8.80822',
			'78.13876,8.80822',
			'78.13876,8.80823',
			'78.13875,8.80823',
			'78.13875,8.80824',
			'78.13874,8.80824',
			'78.13874,8.80825',
			'78.13874,8.80826',
			'78.13846,8.80825',
			'78.1372,8.80814',
			'78.13712,8.80814',
			'78.13679,8.80812',
			'78.13639,8.80809',
			'78.13598,8.80806',
			'78.13567,8.80805',
			'78.13537,8.808',
			'78.13529,8.808',
			'78.13529,8.80718',
			'78.13529,8.80717',
			'78.13522,8.80677'
		);

		$array_2 = array('78.14382,8.80393', '78.14358,8.80393', '78.1436,8.80403', '78.14362,8.8042',  '78.14347,8.80442', '78.14343,8.80446', '78.14339,8.80448', '78.14336,8.80449', '78.1433,8.80449', '78.14324,8.80447', '78.14307,8.80437', '78.14299,8.80432', '78.14239,8.804',   '78.14223,8.80391', '78.14143,8.8035', '78.14132,8.80344', '78.14092,8.80321', '78.14082,8.80315', '78.14062,8.80304', '78.1405,8.80295',  '78.14017,8.80374', '78.14004,8.80404', '78.14001,8.80412', '78.13995,8.80426', '78.13986,8.80451', '78.13991,8.80467', '78.1399,8.80497', '78.13987,8.8051',  '78.13973,8.80538', '78.13971,8.8056', '78.13969,8.80581', '78.13939,8.80583', '78.13881,8.80583', '78.13881,8.80593', '78.138,8.80589',   '78.13727,8.80586', '78.13698,8.80584', '78.13653,8.80579', '78.13627,8.80577', '78.13564,8.8057',  '78.13563,8.80625', '78.13563,8.80646', '78.13562,8.80648', '78.13561,8.80649', '78.13561,8.80651', '78.13559,8.80654', '78.13558,8.80655', '78.13558,8.80656', '78.13556,8.80657', '78.13555,8.80657', '78.13553,8.80658', '78.13551,8.80658', '78.13518,8.80651', '78.13522,8.80677');

		$loop = isset($_GET['loop']) ? $_GET['loop'] : '';
		$values = $array_2[$loop];

		$coordinates = explode(',', $values);

		$data = [
			'lat' => $coordinates[1],
			'lng' => $coordinates[0],
		];
		$this->status = Ws_Controller::HTTP_OK;
		$this->responseData = $data;
		$this->message = "Successfully Done";
	}


	public function getViewRealtimelocation()
	{
		$request = \Config\Services::request();
		$workId = isset($_GET['workId']) ? $_GET['workId'] : '';
		$teamId = isset($_GET['teamId']) ? $_GET['teamId'] : '';

		if (!$workId || !$teamId) {
			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
			$this->message = "Missing workId or teamId";
			return $this->respond(); // Assuming respond() handles the response
		}

		$workRow = $this->MTS->selectone('workhdr', ['id' => $workId]);
		if (!$workRow) {
			$this->status = Ws_Controller::HTTP_NOT_FOUND;
			$this->message = "Work ID not found";
			return $this->respond();
		}

		$custId = $workRow['nCustId'];
		$customerRow = $this->MTS->selectone('customermst', ['id' => $custId]);
		if (!$customerRow) {
			$this->status = Ws_Controller::HTTP_NOT_FOUND;
			$this->message = "Customer not found";
			return $this->respond();
		}

		$customer = [
			'lat' => floatval($customerRow['dLat']),
			'lng' => floatval($customerRow['dLng']),
			'name' => $customerRow['vName']
		];

		$teamMembers = [];
		$members = $this->MTS->select_mts('teamdtl', ['nTeamhdrId ' => $teamId]);
		foreach ($members as $member) {
			$user = $this->MTS->selectone('usermst', ['id' => $member['nUserId']]);
			if ($user && $user['dLat'] && $user['dLng']) {
				$teamMembers[] = [
					'userId' => $user['id'],
					'lat' => floatval($user['dLat']),
					'lng' => floatval($user['dLng']),
					'name' => $user['vName']
				];
			}
		}

		$data = [
			'customer' => $customer,
			'teamMembers' => $teamMembers
		];
		$this->status = Ws_Controller::HTTP_OK;
		$this->responseData = $data;
		$this->message = "Successfully Done";
		return $this->respond(); // Ensure this sends the response
	}

	public function getViewHistoriclocation()
	{

		$workId = isset($_GET['workId']) ? $_GET['workId'] : '';
		$teamId = isset($_GET['teamId']) ? $_GET['teamId'] : '';

		if (!$workId || !$teamId) {
			$this->status = Ws_Controller::HTTP_BAD_REQUEST;
			$this->message = "Missing workId or teamId";
			return $this->respond();
		}

		$workRow = $this->MTS->selectone('workhdr', ['id' => $workId]);
		if (!$workRow) {
			$this->status = Ws_Controller::HTTP_NOT_FOUND;
			$this->message = "Work ID not found";
			return $this->respond();
		}

		$custId = $workRow['nCustId'];
		$customerRow = $this->MTS->selectone('customermst', ['id' => $custId]);
		if (!$customerRow) {
			$this->status = Ws_Controller::HTTP_NOT_FOUND;
			$this->message = "Customer not found";
			return $this->respond();
		}

		$customer = [
			'lat' => floatval($customerRow['dLat']),
			'lng' => floatval($customerRow['dLng']),
			'name' => $customerRow['vName']
		];

		$workTrackingList = $this->MTS->select_mts('snappedtrackingmst', [
			'nWorkId' => $workId,
			'nTeamId' => $teamId
		]);

		if (!$workTrackingList || count($workTrackingList) === 0) {
			$this->status = Ws_Controller::HTTP_NOT_FOUND;
			$this->message = "Work Track Details not found";
			return $this->respond();
		}

		$teamTracking = [];

		foreach ($workTrackingList as $trackMst) {
			$userId = $trackMst['nUserId'];

			// Fetch user name only
			$user = $this->MTS->selectone('usermst', ['id' => $userId]);
			$userName = $user ? $user['vName'] : '';

			$trackingData = json_decode($trackMst['snapped_data'], true);

			$teamTracking[] = [
				'userId' => $userId,
				'name' => $userName,
				'tracking_data' => $trackingData
			];
		}


		$data = [
			'customer' => $customer,
			'team_tracking' => $teamTracking
		];
		$this->status = Ws_Controller::HTTP_OK;
		$this->responseData = $data;
		$this->message = "Successfully Done";
		return $this->respond();
	}

	public function getSnappedPoints($gpsPoints = [])
	{
		$snappedPoints = [];
		try {
			if (empty($gpsPoints)) {
				return $snappedPoints;
			}

			$chunks = array_chunk($gpsPoints, 100);
			$apiKey = 'AIzaSyATm-hYOeeli91RhY-c1onwx7boWVaxwe8';

			foreach ($chunks as $chunkIndex => $chunk) {
				$path = implode('|', array_map(function ($point) {
					return $point['lat'] . ',' . $point['lng'];
				}, $chunk));

				$snapUrl = "https://roads.googleapis.com/v1/snapToRoads?interpolate=true&path=" . urlencode($path) . "&key=" . $apiKey;

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $snapUrl);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
				curl_setopt($ch, CURLOPT_TIMEOUT, 10);
				curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);

				$response = curl_exec($ch);

				if (curl_errno($ch)) {
					$error = curl_error($ch);
					error_log("[getSnappedPoints][CURL ERROR][Chunk $chunkIndex] $error");
					$response = false;
				}

				curl_close($ch);

				if ($response !== false) {
					$json = json_decode($response, true);

					if (isset($json['snappedPoints'])) {
						foreach ($json['snappedPoints'] as $snap) {
							$snappedPoints[] = [
								'lat' => round($snap['location']['latitude'], 6),
								'lng' => round($snap['location']['longitude'], 6)
							];
						}
					}
				}
			}
		} catch (\Throwable $e) {
		}
		return $snappedPoints;
	}


	public function testsnappedpoints()
	{

		$trackingData = $this->MTS->selectone('worktrackingmst', array(
			'id' => 49
		));

		$rawTrackingData = json_decode($trackingData['tracking_data'], true);

		try {
			// Prepare log file
			$logFile = "Logger_snappedtrackingmst_test" . date('Y_m_d') . "_Team_" . $teamId . ".txt";
			$fh = fopen($logFile, 'a');

			if (!is_array($rawTrackingData) || empty($rawTrackingData)) {
				fwrite($fh, "[ERROR] rawTrackingData is not a valid array or is empty\n");
			} else {
				$snappedPoints = $this->getSnappedPoints($rawTrackingData);
			}

			// Store result if points exist
			if (!empty($snappedPoints)) {
				$this->MTS->insert_mts('snappedtrackingmst', [
					'nTeamId' => $teamId,
					'nUserId' => $employeeId,
					'nWorkId' => $workHdrId,
					'snapped_data' => json_encode($snappedPoints),
					'dCreatedDate' => date('Y-m-d H:i:s')
				], $employeeId);

				// Log snapped points
				fwrite($fh, "==== Snapped Points for WorkID: $workHdrId at " . date('Y-m-d H:i:s') . " ====\n");
				fwrite($fh, json_encode($snappedPoints, JSON_PRETTY_PRINT) . "\n\n");
			} else {
				// Log empty result
				fwrite($fh, "!! No snapped points found for WorkID: $workHdrId at " . date('Y-m-d H:i:s') . "\n\n");
			}

			// Also log basic post data
			fwrite($fh, ">> Post Data: " . json_encode($PostData) . "\n\n");

			fclose($fh);
		} catch (\Throwable $e) {
			// Handle and log exception
			$logFile = "Logger_" . date('Y_m_d') . ".txt";
			$fh = fopen($logFile, 'a');
			fwrite($fh, "!! ERROR while snapping points for WorkID: $workHdrId\n");
			fwrite($fh, $e->getMessage() . "\n");
			fwrite($fh, $e->getTraceAsString() . "\n\n");
			fclose($fh);
		}
	}
}
