<?php
session_start();
if (isset($_SESSION['GUSTO_SESS_MEMBER_ID'])) {
    header('Location: gusto_employees.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gusto Payroll Admin - Login</title>
    <link rel="shortcut icon" href="../app/admin/images/favicon.ico" type="image/x-icon">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
            width: 100%;
            max-width: 450px;
        }
        .login-header {
            background: linear-gradient(45deg, #28a745, #20c997);
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        .login-header i {
            font-size: 4rem;
            margin-bottom: 20px;
            display: block;
        }
        .login-body {
            padding: 40px;
        }
        .form-control {
            border-radius: 10px;
            padding: 15px;
            border: 2px solid #e9ecef;
            transition: all 0.3s;
        }
        .form-control:focus {
            border-color: #28a745;
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
        }
        .btn-login {
            background: linear-gradient(45deg, #28a745, #20c997);
            color: white;
            border: none;
            padding: 15px;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: bold;
            width: 100%;
            transition: all 0.3s;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(40, 167, 69, 0.3);
        }
        .alert {
            border-radius: 10px;
            border: none;
        }
        .footer-links {
            text-align: center;
            margin-top: 20px;
            color: #6c757d;
            font-size: 0.9rem;
        }
        .footer-links a {
            color: #28a745;
            text-decoration: none;
        }
        .brand-text {
            font-size: 1.5rem;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
            display: block;
        }
        .sub-text {
            color: rgba(255,255,255,0.8);
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="login-header">
            <i class="fas fa-briefcase"></i>
            <h2>Gusto Payroll Admin</h2>
            <p class="sub-text">MaidToSparkle Payroll Management System</p>
        </div>
        <div class="login-body">
            <?php
            if (isset($_SESSION['GUSTO_LOGIN_ERROR'])) {
                echo '<div class="alert alert-danger">' . $_SESSION['GUSTO_LOGIN_ERROR'] . '</div>';
                unset($_SESSION['GUSTO_LOGIN_ERROR']);
            }
            if (isset($_SESSION['GUSTO_LOGIN_SUCCESS'])) {
                echo '<div class="alert alert-success">' . $_SESSION['GUSTO_LOGIN_SUCCESS'] . '</div>';
                unset($_SESSION['GUSTO_LOGIN_SUCCESS']);
            }
            ?>
            <form action="login_check.php" method="POST">
                <div class="mb-4">
                    <label class="form-label">Username</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-user"></i></span>
                        <input type="text" name="username" class="form-control" placeholder="Enter username" required>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label class="form-label">Password</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-lock"></i></span>
                        <input type="password" name="password" class="form-control" placeholder="Enter password" required>
                    </div>
                </div>
                
                <div class="mb-4">
                    <button type="submit" class="btn-login">
                        <i class="fas fa-sign-in-alt"></i> Login to Gusto Payroll
                    </button>
                </div>
            </form>
            
            <div class="footer-links">
                <p>Need help? <a href="mailto:support@gpsscheduler.com">Contact Support</a></p>
                <p>&copy; <?php echo date('Y'); ?> MaidToSparkle</p>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto-focus username field
        document.querySelector('input[name="username"]').focus();
        
        // Add animation to login card
        document.addEventListener('DOMContentLoaded', function() {
            const card = document.querySelector('.login-card');
            card.style.transform = 'translateY(-20px)';
            card.style.opacity = '0';
            
            setTimeout(() => {
                card.style.transition = 'all 0.5s ease';
                card.style.transform = 'translateY(0)';
                card.style.opacity = '1';
            }, 100);
        });
    </script>
</body>
</html>